/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.entity.projectile;

import com.google.common.collect.ImmutableMap;
import com.oblivioussp.spartanweaponry.api.IWeaponPropertyContainer;
import com.oblivioussp.spartanweaponry.api.ToolMaterialEx;
import com.oblivioussp.spartanweaponry.api.weaponproperty.IPropertyCallback;
import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponProperty;
import com.oblivioussp.spartanweaponry.init.EnchantmentRegistrySW;
import com.oblivioussp.spartanweaponry.init.SoundRegistry;
import com.oblivioussp.spartanweaponry.item.ItemThrowingWeapon;
import com.oblivioussp.spartanweaponry.util.DamageSourcesSW;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public class EntityThrownWeapon
extends EntityArrow
implements IThrowableEntity,
IEntityAdditionalSpawnData {
    public static final String NBT_WEAPON = "weapon";
    public static final String NBT_LIFE = "life";
    protected static final DataParameter<ItemStack> DATA_WEAPON = EntityDataManager.func_187226_a(EntityThrownWeapon.class, (DataSerializer)DataSerializers.field_187196_f);
    protected static final DataParameter<Byte> DATA_RETURN = EntityDataManager.func_187226_a(EntityThrownWeapon.class, (DataSerializer)DataSerializers.field_187191_a);
    protected boolean isReturning = false;
    protected boolean playedReturnSound = false;

    public EntityThrownWeapon(World world) {
        super(world);
    }

    public EntityThrownWeapon(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityThrownWeapon(World world, EntityLivingBase shooter) {
        super(world, shooter);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_WEAPON, (Object)ItemStack.field_190927_a);
        this.func_184212_Q().func_187214_a(DATA_RETURN, (Object)0);
    }

    public void setWeapon(ItemStack weaponStack) {
        ItemStack stack = weaponStack.func_77946_l();
        if (stack.func_77942_o() && stack.func_77973_b() instanceof ItemThrowingWeapon) {
            int maxAmmo = ((ItemThrowingWeapon)stack.func_77973_b()).getMaxAmmoBase();
            stack.func_77978_p().func_74768_a("AmmoUsed", maxAmmo - 1);
            stack.func_77978_p().func_74757_a("Original", false);
        }
        this.func_184212_Q().func_187227_b(DATA_WEAPON, (Object)stack);
        this.func_184212_Q().func_187217_b(DATA_WEAPON);
        this.func_184212_Q().func_187227_b(DATA_RETURN, (Object)((byte)EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.THROWING_RETURN, (ItemStack)stack)));
        this.func_184212_Q().func_187217_b(DATA_RETURN);
    }

    protected ItemStack func_184550_j() {
        return (ItemStack)this.func_184212_Q().func_187225_a(DATA_WEAPON);
    }

    public ItemStack getWeaponStack() {
        return this.func_184550_j();
    }

    public boolean isReturning() {
        return this.isReturning;
    }

    public boolean isValidThrowingWeapon() {
        return !this.getWeaponStack().func_190926_b();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74777_a(NBT_LIFE, (short)this.field_70252_j);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70252_j = compound.func_74765_d(NBT_LIFE);
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null) {
            float i;
            ItemStack weapon = this.getWeaponStack();
            float damage = i = (float)MathHelper.func_76143_f((double)this.func_70242_d());
            if (this.func_70241_g()) {
                i += (float)this.field_70146_Z.nextInt((int)i / 2 + 2);
            }
            if (this.field_70250_c != null && (this.canBeCaughtInMidair(this.field_70250_c, entity) || this.isReturning) && entity instanceof EntityPlayer && this.attemptCatch((EntityPlayer)entity)) {
                return;
            }
            if (this.field_70145_X) {
                return;
            }
            DamageSource damagesource = this.field_70250_c == null ? DamageSourcesSW.causeThrownWeaponMobDamage((Entity)this, (Entity)this) : (this.field_70250_c instanceof EntityPlayer ? DamageSourcesSW.causeThrownWeaponPlayerDamage((Entity)this, (EntityPlayer)this.field_70250_c) : DamageSourcesSW.causeThrownWeaponMobDamage((Entity)this, this.field_70250_c));
            if (weapon.func_77973_b() instanceof IWeaponPropertyContainer && entity instanceof EntityLivingBase && this.field_70250_c instanceof EntityLivingBase && !entity.func_70028_i(this.field_70250_c)) {
                IPropertyCallback callback;
                IWeaponPropertyContainer container = (IWeaponPropertyContainer)weapon.func_77973_b();
                ToolMaterialEx materialEx = container.getMaterialEx();
                List<WeaponProperty> properties = container.getAllWeaponProperties();
                for (WeaponProperty prop : properties) {
                    callback = prop.getCallback();
                    if (callback == null) continue;
                    damage = callback.modifyDamageDealt(materialEx, i, i, damagesource, (EntityLivingBase)this.field_70250_c, (EntityLivingBase)entity);
                    callback.onHitEntity(container.getMaterialEx(), weapon, (EntityLivingBase)entity, (EntityLivingBase)this.field_70250_c, (Entity)this);
                }
                for (WeaponProperty prop : materialEx.getAllWeaponProperties()) {
                    callback = prop.getCallback();
                    if (callback == null) continue;
                    damage = callback.modifyDamageDealt(materialEx, i, i, damagesource, (EntityLivingBase)this.field_70250_c, (EntityLivingBase)entity);
                    callback.onHitEntity(materialEx, weapon, (EntityLivingBase)entity, (EntityLivingBase)this.field_70250_c, (Entity)this);
                }
            }
            if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
                entity.func_70015_d(5);
            }
            if (entity.func_70097_a(damagesource, damage)) {
                if (!this.field_70170_p.field_72995_K) {
                    if (damage > i) {
                        ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.CRIT_MAGIC, entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v, 16, 0.2, 0.2, 0.2, 0.0, new int[0]);
                    } else if (damage < i) {
                        ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v, 16, 0.2, 0.2, 0.2, 0.0, new int[0]);
                    }
                }
                if (weapon.func_77976_d() == 1 && weapon.func_96631_a(1, this.field_70146_Z, null)) {
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187635_cQ, this.func_184176_by(), 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                    for (int j = 0; j < 5; ++j) {
                        Vec3d vec3d = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                        vec3d = vec3d.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
                        vec3d = vec3d.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                        double d0 = (double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3;
                        Vec3d vec3d1 = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.3, d0, 0.6);
                        vec3d1 = vec3d1.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
                        vec3d1 = vec3d1.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                        vec3d1 = vec3d1.func_72441_c(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
                        if (this.field_70170_p instanceof WorldServer) {
                            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.ITEM_CRACK, vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, 0, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, 0.0, new int[]{Item.func_150891_b((Item)weapon.func_77973_b()), weapon.func_77960_j()});
                            continue;
                        }
                        this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, new int[]{Item.func_150891_b((Item)weapon.func_77973_b()), weapon.func_77960_j()});
                    }
                    this.func_70106_y();
                }
                if (entity instanceof EntityLivingBase) {
                    float f1;
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                    if (this.field_70256_ap > 0 && (f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                        entitylivingbase.func_70024_g(this.field_70159_w * (double)this.field_70256_ap * (double)0.6f / (double)f1, 0.1, this.field_70179_y * (double)this.field_70256_ap * (double)0.6f / (double)f1);
                    }
                    if (this.field_70250_c instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.field_70250_c);
                        EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (Entity)entitylivingbase);
                    }
                    this.func_184548_a(entitylivingbase);
                    if (this.field_70250_c != null && entitylivingbase != this.field_70250_c && entitylivingbase instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_184185_a(SoundRegistry.THROWING_WEAPON_HIT, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (!(entity instanceof EntityEnderman)) {
                    this.field_70159_w *= -0.1;
                    this.field_70181_x *= -0.1;
                    this.field_70179_y *= -0.1;
                    this.field_70177_z += 180.0f;
                    this.field_70126_B += 180.0f;
                }
            } else {
                this.field_70159_w *= (double)-0.1f;
                this.field_70181_x *= (double)-0.1f;
                this.field_70179_y *= (double)-0.1f;
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                this.field_70257_an = 0;
                if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < (double)0.001f) {
                    if ((Byte)this.func_184212_Q().func_187225_a(DATA_RETURN) > 0 && !this.field_70145_X) {
                        this.field_70145_X = true;
                    }
                    if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
                        this.dropAsItem();
                    }
                    this.func_70106_y();
                }
            }
        } else if (!this.field_70145_X) {
            if (raytraceResultIn.field_72313_a == RayTraceResult.Type.BLOCK) {
                if (!this.field_70170_p.field_72995_K) {
                    ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5, 0.1, 0.1, 0.1, 0.05, new int[]{Block.func_149682_b((Block)this.field_70170_p.func_180495_p(raytraceResultIn.func_178782_a()).func_177230_c())});
                }
                ItemStack stack = this.func_184550_j();
                this.removeEnchantments(stack);
            }
            super.func_184549_a(raytraceResultIn);
        }
    }

    protected void removeEnchantments(ItemStack stack) {
        if (stack.func_77948_v() && stack.func_77942_o() && stack.func_77978_p().func_74764_b("AmmoUsed")) {
            EnchantmentHelper.func_82782_a((Map)ImmutableMap.of(), (ItemStack)stack);
            if (!this.field_70170_p.field_72995_K) {
                ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t, this.field_70163_u, this.field_70161_v, 10, 0.1, 0.1, 0.1, 0.2, new int[0]);
            }
        }
    }

    protected void dropAsItem() {
        ItemStack stack = this.func_184550_j();
        this.removeEnchantments(stack);
        this.func_70099_a(stack, 0.1f);
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (this.field_70254_i) {
            this.attemptCatch(entityIn);
        }
    }

    protected boolean attemptCatch(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.field_70249_b <= 0) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == EntityArrow.PickupStatus.ALLOWED || this.field_70251_a == EntityArrow.PickupStatus.CREATIVE_ONLY && player.field_71075_bZ.field_75098_d;
            if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
                boolean pickUpAsNewItem = true;
                ItemStack weapon = this.getWeaponStack();
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    int maxAmmo;
                    int currentAmmo;
                    ItemStack slotStack = player.field_71071_by.func_70301_a(i);
                    if (!ItemStack.func_185132_d((ItemStack)slotStack, (ItemStack)weapon) || !weapon.func_77942_o() || !slotStack.func_77942_o() || !weapon.func_77978_p().func_186857_a("UUID").equals(slotStack.func_77978_p().func_186857_a("UUID")) || !(weapon.func_77973_b() instanceof ItemThrowingWeapon) || (currentAmmo = (maxAmmo = ((ItemThrowingWeapon)slotStack.func_77973_b()).getMaxAmmo(slotStack)) - slotStack.func_77978_p().func_74762_e("AmmoUsed")) >= maxAmmo) continue;
                    int itemDamage = slotStack.func_77952_i() + weapon.func_77952_i();
                    if (itemDamage > slotStack.func_77958_k()) {
                        player.func_70669_a(weapon);
                        itemDamage -= slotStack.func_77958_k() + 1;
                    } else {
                        slotStack.func_77978_p().func_74768_a("AmmoUsed", maxAmmo - ++currentAmmo);
                    }
                    slotStack.func_77964_b(itemDamage);
                    pickUpAsNewItem = false;
                    flag = true;
                    break;
                }
                if (pickUpAsNewItem) {
                    ItemStack pickUpStack = this.func_184550_j().func_77946_l();
                    this.removeEnchantments(pickUpStack);
                    flag = player.field_71071_by.func_70441_a(pickUpStack);
                }
            }
            if (flag) {
                player.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
            return flag;
        }
        return false;
    }

    protected boolean canBeCaughtInMidair(Entity shooter, Entity entityHit) {
        return shooter == entityHit && this.field_70145_X;
    }

    public int getTicksInAir() {
        return this.field_70257_an;
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        if (this.field_70254_i) {
            ++this.field_70252_j;
        }
        if (this.field_184552_b > 4 || this.isReturning && this.field_70250_c != null) {
            byte returnLevel = (Byte)this.func_184212_Q().func_187225_a(DATA_RETURN);
            if (returnLevel > 0 && this.field_70250_c.func_70089_S() && (!(this.field_70250_c instanceof EntityPlayerMP) || this.field_70250_c instanceof EntityPlayer && !((EntityPlayer)this.field_70250_c).func_175149_v())) {
                if (!this.isReturning) {
                    this.field_70145_X = true;
                    this.field_70254_i = false;
                    this.isReturning = true;
                    this.func_189654_d(true);
                }
                Vec3d distance = this.field_70250_c.func_174824_e(1.0f).func_178788_d(this.func_174791_d());
                this.field_70163_u += distance.field_72448_b * 0.015 * (double)returnLevel;
                if (this.field_70170_p.field_72995_K) {
                    this.field_70167_r = this.field_70163_u;
                }
                double velocity = 1.0 + 0.25 * (double)(returnLevel - 1);
                Vec3d motionVec = distance.func_72432_b().func_186678_a(velocity);
                this.field_70159_w = motionVec.field_72450_a;
                this.field_70181_x = motionVec.field_72448_b;
                this.field_70179_y = motionVec.field_72449_c;
                if (!this.playedReturnSound) {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundRegistry.THROWING_WEAPON_RETURN, SoundCategory.NEUTRAL, 10.0f, 0.1f);
                    this.playedReturnSound = true;
                }
            } else if (returnLevel > 0 && !this.field_70250_c.func_70089_S()) {
                this.field_70145_X = false;
                this.isReturning = false;
                this.func_189654_d(false);
                this.func_184212_Q().func_187227_b(DATA_RETURN, (Object)0);
            }
        }
        if (this.field_70252_j >= 1200) {
            if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
                this.dropAsItem();
            }
            this.func_70106_y();
        }
        if (!this.field_70254_i) {
            ++this.field_70257_an;
        } else if (this.field_70257_an != 0) {
            this.field_70257_an = 0;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        BlockPos blockpos = new BlockPos(this.field_145791_d, this.field_145792_e, this.field_145789_f);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() != Material.field_151579_a && !this.field_70145_X && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != Block.field_185506_k && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.field_70254_i = true;
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.field_70254_i && !this.field_70145_X) {
            int j = block.func_176201_c(iblockstate);
            if (!(block == this.field_145790_g && j == this.field_70253_h || this.field_70170_p.func_184143_b(this.func_174813_aQ().func_186662_g(0.05)))) {
                this.field_70254_i = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70252_j = 0;
                this.field_70257_an = 0;
            } else {
                ++this.field_70252_j;
                if (this.field_70252_j >= 1200) {
                    if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
                        this.dropAsItem();
                    }
                    this.func_70106_y();
                }
            }
            ++this.field_184552_b;
        } else {
            Entity entity;
            this.field_184552_b = 0;
            ++this.field_70257_an;
            Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
            vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (raytraceresult != null) {
                vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            if ((entity = this.func_184551_a(vec3d1, vec3d)) != null) {
                raytraceresult = new RayTraceResult(entity);
            }
            if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
                if (this.field_70250_c instanceof EntityPlayer && !((EntityPlayer)this.field_70250_c).func_96122_a(entityplayer)) {
                    raytraceresult = null;
                }
            }
            if (raytraceresult != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((EntityArrow)this, (RayTraceResult)raytraceresult)) {
                this.func_184549_a(raytraceresult);
            }
            if (this.func_70241_g()) {
                for (int k = 0; k < 4; ++k) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + this.field_70159_w * (double)k / 4.0, this.field_70163_u + this.field_70181_x * (double)k / 4.0, this.field_70161_v + this.field_70179_y * (double)k / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y, new int[0]);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = this.field_70145_X ? (float)(MathHelper.func_181159_b((double)(-this.field_70159_w), (double)(-this.field_70179_y)) * 57.29577951308232) : (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f4) * 57.29577951308232);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f1 = 0.99f;
            float f2 = 0.05f;
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    float f3 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                ItemStack weaponStack = this.getWeaponStack();
                float f = f1 = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.THROWING_HYDRODYNAMIC, (ItemStack)weaponStack) > 0 ? 0.99f : 0.6f;
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            if (!this.field_70145_X) {
                this.field_70159_w *= (double)f1;
                this.field_70181_x *= (double)f1;
                this.field_70179_y *= (double)f1;
                if (!this.func_189652_ae()) {
                    this.field_70181_x -= (double)0.05f;
                }
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    public void func_70240_a(int knockback) {
        this.field_70256_ap = knockback;
    }

    public Entity getThrower() {
        return this.field_70250_c;
    }

    public void setThrower(Entity entity) {
        this.field_70250_c = entity;
    }

    public void func_174812_G() {
        if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
            this.dropAsItem();
        }
        super.func_174812_G();
    }

    public void writeSpawnData(ByteBuf buffer) {
    }

    public void readSpawnData(ByteBuf additionalData) {
    }
}

