/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweakercore;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;

public class Config {
    private final Configuration configFile;
    private final File whereAreWe;
    private String[] asmBlacklist = new String[0];
    private boolean removeLateAssignments;
    private boolean actualFillerBlocks;
    private boolean oceanTopBlock;
    private boolean oceanFillerBlock;
    private boolean grassColor;
    private boolean foliageColor;
    private boolean waterColor;
    private boolean skyColor;
    private boolean fogColor;
    private boolean initialSnow;

    public Config(File whereAreWe) {
        this.configFile = new Configuration(new File(whereAreWe, "BiomeTweakerCore.cfg"));
        this.whereAreWe = whereAreWe;
        this.configFile.load();
        if (this.configFile.hasChanged()) {
            this.configFile.save();
        }
    }

    public void loadValues() {
        this.actualFillerBlocks = this.configFile.getBoolean("Actual Filler Blocks", "ASM Tweaks", false, "Enables the 'addActualFillerBlock' command.");
        this.oceanTopBlock = this.configFile.getBoolean("Ocean Top Block", "ASM Tweaks", false, "Enables 'oceanTopBlock' in the set command.");
        this.oceanFillerBlock = this.configFile.getBoolean("Ocean Filler Block", "ASM Tweaks", false, "Enables 'oceanFillerBlock' in the set command.");
        this.grassColor = this.configFile.getBoolean("Grass Color", "ASM Tweaks", false, "Enables 'grassColor' in the set command.");
        this.foliageColor = this.configFile.getBoolean("Foliage Color", "ASM Tweaks", false, "Enables 'foliageColor' in the set command.");
        this.waterColor = this.configFile.getBoolean("Water Color", "ASM Tweaks", false, "Enables 'waterColor' in the set command.");
        this.skyColor = this.configFile.getBoolean("Sky Color", "ASM Tweaks", false, "Enables 'skyColor' in the set command.");
        this.fogColor = this.configFile.getBoolean("Fog Color", "ASM Tweaks", false, "Enables 'fogColor' in the set command.");
        this.initialSnow = this.configFile.getBoolean("Initial Snow Gen", "ASM Tweaks", false, "Enables 'genInitialSnow' in the set command.");
        this.removeLateAssignments = this.configFile.getBoolean("Remove Late Block Assignments", "ASM Tweaks", false, "Enable this if you want BiomeTweaker to force topBlock and fillerBlock overrides in most biomes. This is done by using ASM to strip some assignments that happen in the 'genTerrainBlocks' method. This will not work for all biomes. This WILL cause issues where some biomes will have incorrect top and filler blocks if you do not override them (Extreme Hills (M), Mutated Savannah, Taiga). light ASM must be disabled for this to have any effect.");
        this.asmBlacklist = this.configFile.getStringList("ASM Blacklist", "ASM", new String[0], "This can be used to specify biome classes BiomeTweaker should not touch with ASM. You can find the class for a biome in the output files. You should only be using this if you understand what ASM is, and you know the issue it is causing.");
        if (this.configFile.hasChanged()) {
            this.configFile.save();
        }
    }

    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID().equals("biometweakercore")) {
            this.loadValues();
        }
    }

    public Configuration getConfigFile() {
        return this.configFile;
    }

    public File getWhereAreWe() {
        return this.whereAreWe;
    }

    public String[] getAsmBlacklist() {
        return this.asmBlacklist;
    }

    public boolean isRemoveLateAssignments() {
        return this.removeLateAssignments;
    }

    public boolean isActualFillerBlocks() {
        return this.actualFillerBlocks;
    }

    public boolean isOceanTopBlock() {
        return this.oceanTopBlock;
    }

    public boolean isOceanFillerBlock() {
        return this.oceanFillerBlock;
    }

    public boolean isGrassColor() {
        return this.grassColor;
    }

    public boolean isFoliageColor() {
        return this.foliageColor;
    }

    public boolean isWaterColor() {
        return this.waterColor;
    }

    public boolean isSkyColor() {
        return this.skyColor;
    }

    public boolean isFogColor() {
        return this.fogColor;
    }

    public boolean isInitialSnow() {
        return this.initialSnow;
    }
}

