/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.chests;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.model.ModelLargeChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.module.storage.chests.BlockChestCharset;
import pl.asie.charset.module.storage.chests.TileEntityChestCharset;

public class TileEntityChestRendererCharset
extends TileEntitySpecialRenderer<TileEntityChestCharset> {
    protected static final TileEntityChestRendererCharset INSTANCE = new TileEntityChestRendererCharset();
    protected static final ResourceLocation TEXTURE_NORMAL_DOUBLE = new ResourceLocation("charset_generated:textures/entity/chest/normal_double.png");
    protected static final ResourceLocation TEXTURE_NORMAL = new ResourceLocation("charset_generated:textures/entity/chest/normal.png");
    private static final ResourceLocation[] NORMAL_LOCS = new ResourceLocation[]{TEXTURE_NORMAL, TEXTURE_NORMAL_DOUBLE};
    private static final Map<ItemMaterial, ResourceLocation[]> textureLocMap = new HashMap<ItemMaterial, ResourceLocation[]>();
    private final ModelChest singleChest = new ModelChest();
    private final ModelLargeChest doubleChest = new ModelLargeChest();

    public static void onResourceManagerReload() {
        textureLocMap.clear();
    }

    protected TileEntityChestRendererCharset() {
    }

    public void render(TileEntityChestCharset te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        boolean isDouble;
        EnumFacing neighborFacing;
        TileEntityChestCharset neighbor;
        ModelLargeChest model;
        IBlockState state;
        if (te == null) {
            ModCharset.logger.error("TileEntityChestCharset null in renderer! This should not happen! This is a bug!");
            new Throwable().printStackTrace();
            return;
        }
        EnumFacing facing = EnumFacing.SOUTH;
        if (te.func_145831_w() != null && te.func_174877_v() != null && (state = te.func_145831_w().func_180495_p(te.func_174877_v())).func_177230_c() instanceof BlockChestCharset) {
            facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING4);
        }
        if (te.hasNeighbor()) {
            model = this.doubleChest;
            neighbor = te.getNeighbor();
            neighborFacing = te.getNeighborFace();
            isDouble = true;
            if (neighborFacing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                return;
            }
        } else {
            model = this.singleChest;
            neighbor = null;
            neighborFacing = null;
            isDouble = false;
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        boolean applyColor = false;
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)(isDouble ? 8.0f : 4.0f), (float)4.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)0.03125, (double)0.03125, (double)0.03125);
            GlStateManager.func_179128_n((int)5888);
        } else {
            ItemMaterial mat = te.material.getMaterial();
            ResourceLocation[] locs = textureLocMap.get(mat);
            if (locs == null) {
                ResourceLocation locOverride2;
                ResourceLocation locDouble = TEXTURE_NORMAL_DOUBLE;
                ResourceLocation locNormal = TEXTURE_NORMAL;
                IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
                boolean found = false;
                try {
                    locOverride2 = new ResourceLocation("charset", "textures/entity/chest/" + mat.getIdForTexture() + "_double.png");
                    if (manager.func_110536_a(locOverride2) != null) {
                        locDouble = locOverride2;
                        found = true;
                    }
                }
                catch (IOException locOverride2) {
                    // empty catch block
                }
                try {
                    locOverride2 = new ResourceLocation("charset", "textures/entity/chest/" + mat.getIdForTexture() + ".png");
                    if (manager.func_110536_a(locOverride2) != null) {
                        locNormal = locOverride2;
                        found = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                locs = found ? new ResourceLocation[]{locNormal, locDouble} : NORMAL_LOCS;
                textureLocMap.put(mat, locs);
            }
            if (locs == NORMAL_LOCS) {
                applyColor = true;
            }
            this.func_147499_a(isDouble ? locs[1] : locs[0]);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        int j = 0;
        switch (facing) {
            case NORTH: {
                j = 180;
                if (!isDouble) break;
                GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                j = 90;
                break;
            }
            case EAST: {
                j = 270;
                if (!isDouble) break;
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            }
        }
        GlStateManager.func_179114_b((float)j, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float f = te.getLidAngle(partialTicks);
        if (neighborFacing != null && neighborFacing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
            f = Math.max(neighbor.getLidAngle(partialTicks), f);
        }
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        model.field_78233_c.field_78795_f = model.field_78234_a.field_78795_f = -(f * 1.5707964f);
        ItemMaterial mat = te.material.getMaterial();
        if (applyColor) {
            RenderUtils.glColor((int)RenderUtils.getAverageColor((TextureAtlasSprite)RenderUtils.getItemSprite((ItemStack)mat.getStack(), (World)te.func_145831_w(), null, null), (RenderUtils.AveragingMode)RenderUtils.AveragingMode.FULL), (float)alpha);
        }
        model.field_78234_a.func_78785_a(0.0625f);
        model.field_78232_b.func_78785_a(0.0625f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        model.field_78233_c.func_78785_a(0.0625f);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    public static class Stack
    extends TileEntityItemStackRenderer {
        public void func_192838_a(ItemStack stack, float partialTicks) {
            TileEntityChestCharset chest = new TileEntityChestCharset();
            chest.loadFromStack(stack);
            INSTANCE.render(chest, 0.0, 0.0, 0.0, partialTicks, -1, 1.0f);
        }
    }
}

