/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.tileentity.util;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import subaraki.exsartagine.recipe.CustomFluidRecipe;
import subaraki.exsartagine.recipe.IRecipeType;
import subaraki.exsartagine.recipe.ModRecipes;
import subaraki.exsartagine.tileentity.util.KitchenwareBlockEntity;

public abstract class FluidRecipeBlockEntity<T extends IItemHandler, U extends IFluidHandler, R extends CustomFluidRecipe<T, U>>
extends KitchenwareBlockEntity {
    protected T inventoryInput;
    protected T inventoryOutput;
    protected U fluidInventoryInput;
    protected U fluidInventoryOutput;
    protected R cached;
    protected IRecipeType<R> recipeType;
    public boolean cooking;

    protected FluidRecipeBlockEntity() {
        this.initInventory();
    }

    protected abstract void initInventory();

    public T getInventoryInput() {
        return this.inventoryInput;
    }

    public T getInventoryOutput() {
        return this.inventoryOutput;
    }

    public T getEntireItemInventory() {
        return (T)new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)this.inventoryInput, (IItemHandlerModifiable)this.inventoryOutput});
    }

    public U getFluidInventoryInput() {
        return this.fluidInventoryInput;
    }

    public R getOrCreateRecipe() {
        if (this.cached != null && this.cached.match(this.inventoryInput, this.fluidInventoryInput)) {
            return this.cached;
        }
        this.cached = ModRecipes.findFluidRecipe(this.inventoryInput, this.fluidInventoryInput, this.recipeType);
        return this.cached;
    }

    public boolean canStart() {
        R recipe = this.getOrCreateRecipe();
        if (recipe == null) {
            return false;
        }
        if (!this.checkFluids(recipe)) {
            return false;
        }
        List<ItemStack> results = recipe.getResults(this.inventoryInput);
        for (ItemStack stack : results) {
            ItemStack remainder = stack.func_77946_l();
            for (int i = 0; i < this.inventoryInput.getSlots() && !(remainder = this.inventoryInput.insertItem(i, remainder, true)).func_190926_b(); ++i) {
            }
            if (remainder.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void decreaseProgress() {
        if (this.progress > 0) {
            --this.progress;
            this.func_70296_d();
        }
        this.cooking = false;
    }

    public void process() {
        this.progress = 0;
        this.processItems();
        this.processFluids();
    }

    public void start() {
        this.cooking = true;
        this.clientCookTime = this.cached.getCookTime();
    }

    public abstract void processItems();

    public void processFluids() {
        if (this.cached.getInputFluid() != null) {
            this.fluidInventoryInput.drain(this.cached.getInputFluid().amount, true);
        }
        if (this.cached.getOutputFluid() != null) {
            this.fluidInventoryOutput.fill(this.cached.getOutputFluid(), true);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("cooking", this.cooking);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.cooking = compound.func_74767_n("cooking");
    }

    public boolean checkFluids(R recipe) {
        if (!recipe.fluidMatch(this.fluidInventoryInput)) {
            return false;
        }
        return this.checkFluidInv(recipe);
    }

    public abstract boolean checkFluidInv(R var1);
}

