/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.tileentity;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import subaraki.exsartagine.init.ModSounds;
import subaraki.exsartagine.init.RecipeTypes;
import subaraki.exsartagine.recipe.WokRecipe;
import subaraki.exsartagine.tileentity.util.FluidRecipeBlockEntity;

public class WokBlockEntity
extends FluidRecipeBlockEntity<ItemStackHandler, FluidTank, WokRecipe>
implements ITickable {
    private int flips;
    public double rotation;

    public WokBlockEntity() {
        this.initInventory();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.canStart() && this.activeHeatSourceBelow()) {
                WokRecipe recipe = (WokRecipe)this.getOrCreateRecipe();
                if (recipe.getCookTime() <= this.progress && this.canProcess(recipe)) {
                    this.process();
                } else {
                    if (this.cooking) {
                        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, ModSounds.FRYING, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        }
                    } else {
                        this.start();
                    }
                    ++this.progress;
                    this.func_70296_d();
                }
            } else {
                this.decreaseProgress();
            }
        }
    }

    public boolean canProcess(WokRecipe recipe) {
        return recipe.getFlips() <= this.flips;
    }

    public ItemStack addSingleItem(ItemStack stack) {
        ItemStack stack1 = stack.func_77946_l();
        for (int i = 0; i < ((ItemStackHandler)this.inventoryInput).getSlots(); ++i) {
            if (!(stack1 = ((ItemStackHandler)this.inventoryInput).insertItem(i, stack1, false)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack1;
    }

    public void flip(EntityPlayer player, ItemStack stack) {
        WokRecipe recipe = (WokRecipe)this.getOrCreateRecipe();
        if (recipe == null) {
            return;
        }
        ++this.flips;
        if (this.flips == recipe.getFlips()) {
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        this.rotation = this.field_145850_b.field_73012_v.nextDouble() * 360.0;
        this.func_70296_d();
    }

    @Override
    public void processItems() {
        List<ItemStack> results = ((WokRecipe)this.cached).getResults((ItemStackHandler)this.inventoryInput);
        boolean count = false;
        for (int i = 0; i < ((ItemStackHandler)this.inventoryInput).getSlots(); ++i) {
            ItemStack itemstack = ((ItemStackHandler)this.inventoryInput).getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            ((ItemStackHandler)this.inventoryInput).extractItem(i, 1, false);
        }
        for (ItemStack stack : results) {
            ItemStack remainder = stack.func_77946_l();
            for (int i = 0; i < ((ItemStackHandler)this.inventoryOutput).getSlots() && !(remainder = ((ItemStackHandler)this.inventoryOutput).insertItem(i, remainder, false)).func_190926_b(); ++i) {
            }
        }
    }

    @Override
    public void process() {
        super.process();
        this.flips = 0;
    }

    @Override
    public boolean checkFluidInv(WokRecipe recipe) {
        return true;
    }

    @Override
    protected void initInventory() {
        this.inventoryInput = new WokStackHandler();
        this.inventoryOutput = new WokStackHandler();
        this.fluidInventoryInput = new WokTank(10000);
        ((FluidTank)this.fluidInventoryInput).setTileEntity((TileEntity)this);
        this.recipeType = RecipeTypes.WOK;
    }

    public void clearInput() {
        for (int i = 0; i < ((ItemStackHandler)this.inventoryInput).getSlots(); ++i) {
            ((ItemStackHandler)this.inventoryInput).setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.cooking = false;
        this.cached = null;
        this.progress = 0;
        this.func_70296_d();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventoryInput;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean isCooking() {
        return this.cooking;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inv", (NBTBase)((ItemStackHandler)this.inventoryInput).serializeNBT());
        compound.func_74782_a("invO", (NBTBase)((ItemStackHandler)this.inventoryOutput).serializeNBT());
        compound.func_74782_a("fluidinv", (NBTBase)((FluidTank)this.fluidInventoryInput).writeToNBT(new NBTTagCompound()));
        compound.func_74768_a("flips", this.flips);
        compound.func_74780_a("rotation", this.rotation);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        ((ItemStackHandler)this.inventoryInput).deserializeNBT(compound.func_74775_l("inv"));
        ((ItemStackHandler)this.inventoryOutput).deserializeNBT(compound.func_74775_l("invO"));
        ((FluidTank)this.fluidInventoryInput).readFromNBT(compound.func_74775_l("fluidinv"));
        this.flips = compound.func_74762_e("flips");
        this.rotation = compound.func_74769_h("rotation");
    }

    public void giveItems(EntityPlayer playerIn) {
        for (int i = 0; i < ((ItemStackHandler)this.inventoryOutput).getSlots(); ++i) {
            ItemStack stack = ((ItemStackHandler)this.inventoryOutput).extractItem(i, Integer.MAX_VALUE, false);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)stack);
        }
    }

    public class WokTank
    extends FluidTank {
        public WokTank(int capacity) {
            super(capacity);
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            WokBlockEntity.this.func_70296_d();
        }
    }

    public class WokStackHandler
    extends ItemStackHandler {
        WokStackHandler() {
            super(9);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            WokBlockEntity.this.func_70296_d();
        }
    }
}

