/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import subaraki.exsartagine.block.BlockRange;
import subaraki.exsartagine.block.BlockRangeExtension;
import subaraki.exsartagine.tileentity.TileEntityRangeExtension;

public class TileEntityRange
extends TileEntity
implements ITickable {
    private final ItemStackHandler inventory = new ItemStackHandler(9);
    private boolean selfIgnitingUpgrade;
    private final List<BlockPos> connected = new ArrayList<BlockPos>();
    private int fuelTimer = 0;
    private int maxFuelTimer = 0;
    private int sparks;

    public void func_73660_a() {
        if (this.fuelTimer > 0) {
            --this.fuelTimer;
        }
        if (this.sparks > 0) {
            --this.sparks;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.fuelTimer == 0) {
                this.lookForFuel();
            }
            if (this.fuelTimer == 0 && this.isHeated()) {
                this.setCooking(false);
                this.maxFuelTimer = 0;
                this.func_70296_d();
            }
        }
    }

    public void lookForFuel() {
        if (this.manualIgnition() && !this.isHeated() && this.sparks <= 0) {
            return;
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !TileEntityFurnace.func_145954_b((ItemStack)stack)) continue;
            this.maxFuelTimer = this.fuelTimer = (int)((double)TileEntityFurnace.func_145952_a((ItemStack)stack) * ((BlockRange)this.func_145838_q()).getFuelEfficiency());
            this.setCooking(true);
            this.inventory.getStackInSlot(i).func_190918_g(1);
            this.func_70296_d();
            break;
        }
    }

    private void setCooking(boolean cooking) {
        this.setRangeConnectionsCooking(cooking);
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        IBlockState newState = state.func_177226_a((IProperty)BlockRange.HEATED, (Comparable)Boolean.valueOf(cooking));
        this.field_145850_b.func_175656_a(this.field_174879_c, newState);
    }

    public boolean isHeated() {
        return (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockRange.HEATED);
    }

    public boolean isFueled() {
        return this.fuelTimer > 0;
    }

    public int getFuelTimer() {
        return this.fuelTimer;
    }

    public int getMaxFuelTimer() {
        return this.maxFuelTimer;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inv", (NBTBase)this.inventory.serializeNBT());
        compound.func_74768_a("fuel", this.fuelTimer);
        compound.func_74768_a("max", this.maxFuelTimer);
        NBTTagCompound connections = new NBTTagCompound();
        int slot = 0;
        for (BlockPos pos : this.connected) {
            connections.func_74772_a(Integer.toString(slot), pos.func_177986_g());
            ++slot;
        }
        compound.func_74782_a("connections", (NBTBase)connections);
        this.saveCommon(compound);
        return compound;
    }

    public void saveCommon(NBTTagCompound compound) {
        compound.func_74757_a("self_igniting_upgrade", this.selfIgnitingUpgrade);
    }

    public NBTTagCompound saveToItemNbt(NBTTagCompound compound) {
        this.saveCommon(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inv"));
        this.fuelTimer = compound.func_74762_e("fuel");
        this.maxFuelTimer = compound.func_74762_e("max");
        this.connected.clear();
        NBTTagCompound connections = compound.func_74775_l("connections");
        for (int i = 0; i < 4; ++i) {
            if (!connections.func_74764_b(String.valueOf(i))) continue;
            BlockPos pos = BlockPos.func_177969_a((long)connections.func_74763_f(String.valueOf(i)));
            this.connected.add(pos);
        }
        this.selfIgnitingUpgrade = compound.func_74767_n("self_igniting_upgrade");
    }

    public int getMaxExtensions() {
        return ((BlockRange)this.func_145838_q()).getMaxExtensions();
    }

    public boolean manualIgnition() {
        return ((BlockRange)this.func_145838_q()).isManualIgnition().get() != false && !this.selfIgnitingUpgrade;
    }

    public void createSparks() {
        this.sparks += 5;
    }

    public boolean canConnect() {
        return this.connected.size() < this.getMaxExtensions();
    }

    public void connect(TileEntityRangeExtension tere) {
        if (this.canConnect()) {
            this.connected.add(tere.func_174877_v());
            tere.setParentRange(this.func_174877_v());
            this.setRangeConnectionCooking(tere.func_174877_v(), this.isHeated());
        }
        this.func_70296_d();
    }

    public void disconnect(BlockPos entry) {
        this.connected.remove(entry);
        this.func_70296_d();
    }

    public void setRangeConnectionsCooking(boolean setCooking) {
        if (!this.connected.isEmpty()) {
            for (BlockPos extPos : this.connected) {
                this.setRangeConnectionCooking(extPos, setCooking);
            }
        }
    }

    public void setRangeConnectionCooking(BlockPos extPos, boolean setCooking) {
        IBlockState state = this.field_145850_b.func_180495_p(extPos);
        if (state.func_177230_c() instanceof BlockRangeExtension) {
            BlockRangeExtension blockRangeExtension = (BlockRangeExtension)state.func_177230_c();
            Block blockNew = setCooking ? blockRangeExtension.getHotBlock() : blockRangeExtension.getColdBlock();
            IBlockState state1 = blockNew.func_176223_P().func_177226_a((IProperty)BlockRangeExtension.FACING, state.func_177229_b((IProperty)BlockRangeExtension.FACING));
            this.field_145850_b.func_175656_a(extPos, state1);
            TileEntity te = this.field_145850_b.func_175625_s(extPos);
            if (te instanceof TileEntityRangeExtension) {
                TileEntityRangeExtension rangeExtension = (TileEntityRangeExtension)te;
                rangeExtension.setParentRange(this.field_174879_c);
            }
        }
    }

    public void setFuelTimer(int timer) {
        this.fuelTimer = timer;
        if (this.maxFuelTimer < this.fuelTimer) {
            this.maxFuelTimer = this.fuelTimer;
        }
        if (timer > 0 && !this.isHeated()) {
            this.setCooking(true);
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        super.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean isSelfIgnitingUpgrade() {
        return this.selfIgnitingUpgrade;
    }

    public void setSelfIgnitingUpgrade(boolean selfIgnitingUpgrade) {
        this.selfIgnitingUpgrade = selfIgnitingUpgrade;
        this.func_70296_d();
    }
}

