/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.tileentity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import subaraki.exsartagine.block.BlockPot;
import subaraki.exsartagine.init.RecipeTypes;
import subaraki.exsartagine.recipe.ModRecipes;
import subaraki.exsartagine.recipe.PotRecipe;
import subaraki.exsartagine.tileentity.TileEntityCooker;

public class TileEntityPot
extends TileEntityCooker {
    public PotRecipe cached;
    public FluidTank fluidTank = new FluidTank(1000);

    public TileEntityPot() {
        this.initInventory(2);
    }

    public int getWaterLevel() {
        return this.fluidTank.getFluidAmount();
    }

    public void replenishWater() {
        this.fluidTank.fill(new FluidStack(FluidRegistry.WATER, 1000), false);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.canRun() && this.activeHeatSourceBelow()) {
                PotRecipe recipe = this.getOrCreateRecipe();
                if (recipe.getCookTime() <= this.progress) {
                    this.process();
                } else {
                    ++this.progress;
                    if (this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                        this.fluidTank.drain(5, true);
                    }
                    this.func_70296_d();
                }
            } else {
                this.decreaseProgress();
                this.func_70296_d();
            }
            if (!((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockPot.FULL)).booleanValue() && this.getWaterLevel() > 0) {
                this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockPot.FULL, (Comparable)Boolean.valueOf(true)), 3);
            }
            if (((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockPot.FULL)).booleanValue() && this.getWaterLevel() == 0) {
                this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockPot.FULL, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public void decreaseProgress() {
        if (this.progress > 0) {
            --this.progress;
        }
    }

    public boolean canRun() {
        if (this.getWaterLevel() <= 0) {
            return false;
        }
        ItemStack input = this.getInput();
        ItemStack output = this.getOutput();
        if (!input.func_190926_b()) {
            PotRecipe potRecipe = this.getOrCreateRecipe();
            if (potRecipe == null) {
                return false;
            }
            if (output.func_190926_b()) {
                return true;
            }
            ItemStack result = potRecipe.getResult(this.getInventory());
            return this.getInventory().insertItem(1, result, true).func_190926_b();
        }
        return false;
    }

    public PotRecipe getOrCreateRecipe() {
        if (this.cached != null && this.cached.itemMatch(this.getInventory())) {
            return this.cached;
        }
        this.cached = (PotRecipe)ModRecipes.findRecipe(this.getInventory(), RecipeTypes.POT);
        return this.cached;
    }

    public void process() {
        this.progress = 0;
        if (this.getInput().func_190916_E() > 0 && this.getOutput().func_190916_E() < this.getOutput().func_77976_d()) {
            ItemStack result = ModRecipes.getCookingResult(this.getInventory(), RecipeTypes.POT);
            if (this.getOutput().func_190926_b()) {
                this.setResult(result.func_77946_l());
            } else {
                this.getOutput().func_190917_f(result.func_190916_E());
            }
            this.getInput().func_190918_g(1);
        }
    }

    @Override
    public boolean isValid(ItemStack stack) {
        return ModRecipes.hasResult(stack, RecipeTypes.POT);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.fluidTank.writeToNBT(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.fluidTank.readFromNBT(compound);
    }
}

