/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import subaraki.exsartagine.gui.common.KettleFSH;
import subaraki.exsartagine.gui.common.KettleISH;
import subaraki.exsartagine.recipe.KettleRecipe;
import subaraki.exsartagine.recipe.ModRecipes;
import subaraki.exsartagine.tileentity.util.KitchenwareBlockEntity;

public class TileEntityKettle
extends KitchenwareBlockEntity
implements ITickable {
    private static final int OUTPUT_START = 10;
    public KettleRecipe cached;
    public boolean running;
    public final ItemStackHandler handler = new KettleISH(this, 20);
    public final FluidTank fluidInputTank = new KettleFSH(this, 1000);
    public final FluidTank fluidOutputTank = new KettleFSH(this, 1000);
    public final IFluidHandler iFluidHandlerWrapper = new IFluidHandlerWrapper();

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.activeHeatSourceBelow() && this.canStart()) {
                KettleRecipe recipe = this.getOrCreateRecipe();
                if (recipe != null) {
                    this.clientCookTime = recipe.getCookTime();
                    if (this.clientCookTime == this.progress) {
                        this.process();
                    } else {
                        if (!this.running) {
                            this.start();
                        }
                        ++this.progress;
                        this.func_70296_d();
                    }
                }
            } else {
                this.decreaseProgress();
            }
        }
    }

    public void decreaseProgress() {
        if (this.progress > 0) {
            --this.progress;
            this.func_70296_d();
        }
        this.running = false;
    }

    public boolean canStart() {
        KettleRecipe recipe = this.getOrCreateRecipe();
        if (recipe == null) {
            return false;
        }
        if (!this.checkFluids(recipe)) {
            return false;
        }
        List<ItemStack> results = recipe.getResults((IItemHandler)this.handler);
        for (ItemStack stack : results) {
            ItemStack remainder = stack.func_77946_l();
            for (int i = 10; i < 19 && !(remainder = this.handler.insertItem(i, remainder, true)).func_190926_b(); ++i) {
            }
            if (remainder.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void swapTanks() {
        FluidStack oldInput = this.fluidInputTank.getFluid();
        FluidStack oldOutput = this.fluidOutputTank.getFluid();
        if (oldInput != null || oldOutput != null) {
            FluidStack oldInputCopy = null;
            FluidStack oldOutputCopy = null;
            if (oldInput != null) {
                oldInputCopy = oldInput.copy();
            }
            if (oldOutput != null) {
                oldOutputCopy = oldOutput.copy();
            }
            this.fluidInputTank.setFluid(oldOutputCopy);
            this.fluidOutputTank.setFluid(oldInputCopy);
            this.func_70296_d();
        }
    }

    public void tryOutputFluid() {
        FluidActionResult fluidActionResult;
        ItemStack stack = this.handler.getStackInSlot(19);
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (fluidActionResult = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)this.fluidOutputTank, (int)this.fluidOutputTank.getFluidAmount(), null, (boolean)true)).isSuccess()) {
            this.handler.setStackInSlot(19, fluidActionResult.getResult());
        }
    }

    public boolean checkFluids(KettleRecipe recipe) {
        if (!recipe.fluidMatch((IFluidHandler)this.fluidInputTank)) {
            return false;
        }
        FluidStack outputStack = recipe.getOutputFluid();
        if (outputStack == null) {
            return true;
        }
        int filled = this.fluidOutputTank.fill(outputStack, false);
        return filled >= outputStack.amount;
    }

    public void start() {
        this.running = true;
        this.clientCookTime = this.cached.getCookTime();
    }

    public KettleRecipe getOrCreateRecipe() {
        if (this.cached != null && this.cached.match(this.handler, this.fluidInputTank)) {
            return this.cached;
        }
        this.cached = ModRecipes.findKettleRecipe(this.handler, this.fluidInputTank);
        return this.cached;
    }

    public void process() {
        this.progress = 0;
        List<ItemStack> results = this.cached.getResults((IItemHandler)this.handler);
        for (int i = 1; i < 10; ++i) {
            this.handler.extractItem(i, 1, false);
        }
        for (ItemStack stack : results) {
            ItemStack remainder = stack.func_77946_l();
            for (int i = 10; i < 19 && !(remainder = this.handler.insertItem(i, remainder, false)).func_190926_b(); ++i) {
            }
        }
        this.processFluids();
    }

    public void processFluids() {
        if (this.cached.getInputFluid() != null) {
            this.fluidInputTank.drainInternal(this.cached.getInputFluid().amount, true);
        }
        if (this.cached.getOutputFluid() != null) {
            this.fluidOutputTank.fillInternal(this.cached.getOutputFluid(), true);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.iFluidHandlerWrapper : null);
    }

    @Override
    public IItemHandler getEntireItemInventory() {
        return this.handler;
    }

    public int addFluids(FluidStack fluid) {
        if (fluid != null) {
            return this.fluidInputTank.fill(fluid, true);
        }
        return 0;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("running", this.running);
        compound.func_74782_a("inv", (NBTBase)this.handler.serializeNBT());
        NBTTagCompound fluidInputCompound = new NBTTagCompound();
        NBTTagCompound fluidOutputCompound = new NBTTagCompound();
        this.fluidInputTank.writeToNBT(fluidInputCompound);
        this.fluidOutputTank.writeToNBT(fluidOutputCompound);
        compound.func_74782_a("fluidInputTank", (NBTBase)fluidInputCompound);
        compound.func_74782_a("fluidOutputTank", (NBTBase)fluidOutputCompound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.running = compound.func_74767_n("running");
        if (compound.func_74764_b("inv")) {
            this.handler.deserializeNBT(compound.func_74775_l("inv"));
        }
        NBTTagCompound fluidInputCompound = compound.func_74775_l("fluidInputTank");
        NBTTagCompound fluidOutputCompound = compound.func_74775_l("fluidOutputTank");
        this.fluidInputTank.readFromNBT(fluidInputCompound);
        this.fluidOutputTank.readFromNBT(fluidOutputCompound);
    }

    public class IFluidHandlerWrapper
    implements IFluidHandler {
        IFluidTankProperties[] iFluidTankProperties;

        public IFluidTankProperties[] getTankProperties() {
            if (this.iFluidTankProperties == null) {
                ArrayList tanks = Lists.newArrayList();
                Collections.addAll(tanks, TileEntityKettle.this.fluidInputTank.getTankProperties());
                Collections.addAll(tanks, TileEntityKettle.this.fluidOutputTank.getTankProperties());
                return tanks.toArray(new IFluidTankProperties[0]);
            }
            return this.iFluidTankProperties;
        }

        public int fill(FluidStack resource, boolean doFill) {
            return TileEntityKettle.this.fluidInputTank.fill(resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return TileEntityKettle.this.fluidOutputTank.drain(resource, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return TileEntityKettle.this.fluidOutputTank.drain(maxDrain, doDrain);
        }
    }
}

