/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import subaraki.exsartagine.tileentity.util.KitchenwareBlockEntity;

public abstract class TileEntityCooker
extends KitchenwareBlockEntity
implements ITickable {
    protected static final int RESULT = 1;
    protected static final int INPUT = 0;
    private ISHCooker inventory;
    private RangedWrapper input;
    private RangedWrapper output;

    protected void initInventory(int slots) {
        this.inventory = new ISHCooker(slots);
        this.input = new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 1);
        this.output = new RangedWrapper((IItemHandlerModifiable)this.inventory, 1, slots);
    }

    @Override
    public IItemHandler getEntireItemInventory() {
        return this.inventory;
    }

    public void setResult(ItemStack stack) {
        this.setResult(1, stack);
    }

    public void setResult(int slot, ItemStack stack) {
        this.getInventory().insertItem(slot, stack, false);
    }

    public ItemStack getInput() {
        return this.getInventory().getStackInSlot(0);
    }

    public ItemStack getOutput() {
        return this.getOutput(1);
    }

    public ItemStack getOutput(int slot) {
        return this.getInventory().getStackInSlot(slot);
    }

    public ItemStack getEntryStackOne() {
        ItemStack stack = this.getInventory().getStackInSlot(0);
        return stack.func_77946_l();
    }

    public abstract boolean isValid(ItemStack var1);

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return facing != EnumFacing.UP;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)((Object)this.inventory);
            }
            if (EnumFacing.DOWN == facing) {
                return (T)this.output;
            }
            return (T)this.input;
        }
        return (T)super.getCapability(capability, facing);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inv", (NBTBase)this.inventory.serializeNBT());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("inv")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inv"));
        }
    }

    public class ISHCooker
    extends ItemStackHandler {
        public ISHCooker(int slots) {
            super(slots);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 0 && TileEntityCooker.this.isValid(stack) || slot > 0) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        protected void onContentsChanged(int slot) {
            TileEntityCooker.this.func_70296_d();
        }
    }
}

