/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.recipe;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import subaraki.exsartagine.init.RecipeTypes;
import subaraki.exsartagine.recipe.CustomFluidRecipe;
import subaraki.exsartagine.recipe.IItemHandlerRecipeItemHelper;
import subaraki.exsartagine.recipe.IRecipeType;

public class WokRecipe
implements CustomFluidRecipe<ItemStackHandler, FluidTank> {
    private final List<Ingredient> ingredients;
    private final FluidStack fluid;
    private final List<ItemStack> outputs;
    private final int flips;

    public WokRecipe(List<Ingredient> inputs, FluidStack fluid, List<ItemStack> outputs, int flips) {
        this.ingredients = inputs;
        this.fluid = fluid;
        this.outputs = outputs;
        this.flips = flips;
    }

    @Override
    public boolean itemMatch(ItemStackHandler handler) {
        int ingredientCount = 0;
        IItemHandlerRecipeItemHelper recipeItemHelper = new IItemHandlerRecipeItemHelper();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack itemstack = handler.getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            ++ingredientCount;
            recipeItemHelper.accountStack(itemstack, 1);
        }
        if (ingredientCount != this.ingredients.size()) {
            return false;
        }
        return recipeItemHelper.canCraft(this, null);
    }

    @Override
    public boolean fluidMatch(FluidTank handler) {
        if (this.fluid == null) {
            return true;
        }
        FluidStack fluidStack = handler.getTankProperties()[0].getContents();
        return fluidStack != null && fluidStack.containsFluid(this.fluid);
    }

    @Override
    public FluidStack getInputFluid() {
        return this.fluid;
    }

    @Override
    public List<Ingredient> getIngredients() {
        return Lists.newArrayList(this.ingredients);
    }

    @Override
    public ItemStack getDisplay() {
        return ItemStack.field_190927_a;
    }

    @Override
    public List<ItemStack> getResults(ItemStackHandler handler) {
        return this.outputs;
    }

    @Override
    public int getCookTime() {
        return 125;
    }

    public int getFlips() {
        return this.flips;
    }

    @Override
    public IRecipeType<?> getType() {
        return RecipeTypes.WOK;
    }
}

