/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreIngredient;
import subaraki.exsartagine.ExSartagine;
import subaraki.exsartagine.block.BlockRange;
import subaraki.exsartagine.init.ExSartagineBlocks;
import subaraki.exsartagine.init.ExSartagineItems;
import subaraki.exsartagine.init.RecipeTypes;
import subaraki.exsartagine.recipe.CustomFluidRecipe;
import subaraki.exsartagine.recipe.CustomRecipe;
import subaraki.exsartagine.recipe.IRecipeType;
import subaraki.exsartagine.recipe.KettleRecipe;
import subaraki.exsartagine.recipe.PotRecipe;
import subaraki.exsartagine.recipe.SmelterRecipe;
import subaraki.exsartagine.recipe.WokRecipe;
import subaraki.exsartagine.tileentity.util.BlockInfo;

public class ModRecipes {
    private static final Map<IBlockState, BlockInfo> placeable = new HashMap<IBlockState, BlockInfo>();
    protected static final Map<IRecipeType<?>, Map<ResourceLocation, CustomRecipe<?>>> recipes = new HashMap();
    static int i = 0;
    private static final ItemStackHandler DUMMY = new ItemStackHandler();
    public static Set<Item> validItems = new HashSet<Item>();

    public static <I extends IItemHandler, T extends CustomRecipe<I>> void addRecipe(T recipe) {
        ResourceLocation name = new ResourceLocation("crafttweaker", "autogenerated_" + i);
        ++i;
        ModRecipes.addRecipe(name, recipe);
    }

    public static <I extends IItemHandler, R extends CustomRecipe<I>> void addRecipe(ResourceLocation name, R recipe) {
        IRecipeType<?> type = recipe.getType();
        Map<ResourceLocation, CustomRecipe<?>> recs = recipes.get(type);
        if (recs == null) {
            recipes.put(type, new HashMap());
            recs = recipes.get(type);
        }
        if (recs.put(name, recipe) != null) {
            throw new RuntimeException("duplicate recipe:" + type + name);
        }
    }

    public static <I extends IItemHandler, R extends CustomRecipe<I>> boolean removeRecipeByName(ResourceLocation name, IRecipeType<R> type) {
        Object map = ModRecipes.getRecipeMap(type);
        return map.remove(name) != null;
    }

    public static void addPotRecipe(Ingredient input, ItemStack result) {
        ModRecipes.addRecipe(result.func_77973_b().getRegistryName(), new PotRecipe(input, result));
    }

    public static void addWokRecipe(List<Ingredient> ingredients, FluidStack fluid, List<ItemStack> stacks, int flips) {
        WokRecipe wokRecipe = new WokRecipe(ingredients, fluid, stacks, flips);
        ModRecipes.addRecipe(wokRecipe);
    }

    public static void addSmelterRecipe(Ingredient ingredient, ItemStack itemStack) {
        ModRecipes.addRecipe(itemStack.func_77973_b().getRegistryName(), new SmelterRecipe(ingredient, itemStack));
    }

    public static void addBuiltinKettleRecipe(List<Ingredient> ingredients, Ingredient catalyst, @Nullable FluidStack inputFluid, @Nullable FluidStack outputFluid, List<ItemStack> results, int cookTime) {
        ModRecipes.addRecipe(new ResourceLocation("exsartagine", results.get(0).func_77973_b().getRegistryName().func_110623_a()), new KettleRecipe(ingredients, catalyst, inputFluid, outputFluid, results, cookTime));
    }

    public static void addKettleRecipe(List<Ingredient> ingredients, Ingredient catalyst, @Nullable FluidStack inputFluid, @Nullable FluidStack outputFluid, List<ItemStack> results, int cookTime) {
        ModRecipes.addRecipe(new KettleRecipe(ingredients, catalyst, inputFluid, outputFluid, results, cookTime));
    }

    public static <T extends IItemHandler, U extends CustomRecipe<T>> boolean hasResult(ItemStack stack, IRecipeType<U> type) {
        DUMMY.setStackInSlot(0, stack);
        return ModRecipes.hasResult(DUMMY, type);
    }

    public static boolean removePotRecipe(ItemStack output) {
        return ModRecipes.getRecipes(RecipeTypes.POT).removeIf(r -> ItemStack.func_77989_b((ItemStack)r.getResult(new ItemStackHandler()), (ItemStack)output));
    }

    public static boolean removePotRecipe(ItemStack input, ItemStack output) {
        return ModRecipes.getRecipes(RecipeTypes.POT).removeIf(r -> r.itemMatch((IItemHandler)new ItemStackHandler(NonNullList.func_193580_a((Object)input, (Object[])new ItemStack[0]))) && ItemStack.func_77989_b((ItemStack)r.getResult(new ItemStackHandler()), (ItemStack)output));
    }

    public static boolean removePotRecipe(Ingredient input, ItemStack output) {
        boolean changed = false;
        for (ItemStack i : input.func_193365_a()) {
            if (!ModRecipes.removePotRecipe(i, output)) continue;
            changed = true;
        }
        return changed;
    }

    public static Collection<WokRecipe> getWokRecipes() {
        return ModRecipes.getRecipes(RecipeTypes.WOK);
    }

    public static boolean removeWokRecipeByName(ResourceLocation name) {
        return ModRecipes.removeRecipeByName(name, RecipeTypes.WOK);
    }

    public static boolean removeSmelterRecipe(ItemStack output) {
        return ModRecipes.getRecipes(RecipeTypes.SMELTER).removeIf(r -> ItemStack.func_77989_b((ItemStack)r.getResult((IItemHandler)new ItemStackHandler()), (ItemStack)output));
    }

    public static boolean removeSmelterRecipe(ItemStack input, ItemStack output) {
        return ModRecipes.getRecipes(RecipeTypes.SMELTER).removeIf(r -> r.itemMatch((IItemHandler)new ItemStackHandler(NonNullList.func_193580_a((Object)input, (Object[])new ItemStack[0]))) && ItemStack.func_77989_b((ItemStack)r.getResult((IItemHandler)new ItemStackHandler()), (ItemStack)output));
    }

    public static boolean removeSmelterRecipe(Ingredient input, ItemStack output) {
        boolean changed = false;
        for (ItemStack i : input.func_193365_a()) {
            if (!ModRecipes.removeSmelterRecipe(i, output)) continue;
            changed = true;
        }
        return changed;
    }

    public static Collection<KettleRecipe> getKettleRecipes() {
        return ModRecipes.getRecipes(RecipeTypes.KETTLE);
    }

    public static boolean removeKettleRecipeByName(ResourceLocation name) {
        return ModRecipes.removeRecipeByName(name, RecipeTypes.KETTLE);
    }

    public static <I extends IItemHandler, R extends CustomRecipe<I>> ItemStack getCookingResult(I handler, IRecipeType<R> type) {
        for (CustomRecipe recipe : ModRecipes.getRecipes(type)) {
            if (!recipe.itemMatch(handler)) continue;
            return recipe.getResult(handler);
        }
        return ItemStack.field_190927_a;
    }

    public static <I extends IItemHandler, R extends CustomRecipe<I>> List<ItemStack> getCookingResults(I handler, IRecipeType<R> type) {
        for (CustomRecipe recipe : ModRecipes.getRecipes(type)) {
            if (!recipe.itemMatch(handler)) continue;
            return recipe.getResults(handler);
        }
        return new ArrayList<ItemStack>();
    }

    public static <I extends IItemHandler, R extends CustomRecipe<I>> CustomRecipe<I> findRecipe(I handler, IRecipeType<R> type) {
        Collection<CustomRecipe> recipes = ModRecipes.getRecipes(type);
        for (CustomRecipe recipe : recipes) {
            if (!recipe.itemMatch(handler)) continue;
            return recipe;
        }
        return null;
    }

    public static <I extends IItemHandler, F extends IFluidHandler, FR extends CustomFluidRecipe<I, F>> FR findFluidRecipe(I handler, F fluidHandler, IRecipeType<FR> type) {
        Collection<CustomFluidRecipe> recipes = ModRecipes.getRecipes(type);
        for (CustomFluidRecipe recipe : recipes) {
            if (!recipe.match(handler, fluidHandler)) continue;
            return (FR)recipe;
        }
        return null;
    }

    public static <I extends IItemHandler, F extends IFluidHandler> KettleRecipe findKettleRecipe(I handler, F fluidHandler) {
        return ModRecipes.findFluidRecipe(handler, fluidHandler, RecipeTypes.KETTLE);
    }

    public static <I extends IItemHandler, T extends CustomRecipe<I>> boolean hasResult(I handler, IRecipeType<T> type) {
        return ModRecipes.getRecipes(type).stream().anyMatch(customRecipe -> customRecipe.itemMatch(handler));
    }

    public static void addPlaceable(Block block, boolean hot, boolean legs) {
        ModRecipes.addPlaceable(block, iBlockState -> true, hot, legs);
    }

    public static void addPlaceable(Block block, Predicate<IBlockState> predicate, boolean hot, boolean legs) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            if (!predicate.test(state)) continue;
            ModRecipes.addPlaceable(state, hot, legs);
        }
    }

    public static void addPlaceable(Collection<IBlockState> states, boolean hot, boolean legs) {
        for (IBlockState state : states) {
            ModRecipes.addPlaceable(state, hot, legs);
        }
    }

    public static void addPlaceable(IBlockState state, boolean hot, boolean legs) {
        placeable.put(state, new BlockInfo(hot, legs));
    }

    public static boolean removePlaceable(IBlockState state) {
        return placeable.remove(state) != null;
    }

    public static void removePlaceable(Block block) {
        ModRecipes.removePlaceables((Collection<IBlockState>)block.func_176194_O().func_177619_a());
    }

    public static boolean removePlaceables(Collection<IBlockState> states) {
        states.forEach(ModRecipes::removePlaceable);
        return true;
    }

    public static <I extends IItemHandler, R extends CustomRecipe<I>> Collection<R> getRecipes(IRecipeType<R> type) {
        Object map = ModRecipes.getRecipeMap(type);
        if (map != null) {
            return map.values();
        }
        return Collections.emptyList();
    }

    public static <I extends IItemHandler, R extends CustomRecipe<I>, S extends Map<ResourceLocation, R>> S getRecipeMap(IRecipeType<R> type) {
        return (S)recipes.get(type);
    }

    public static boolean isHeatSource(IBlockState state) {
        return ModRecipes.placeable.getOrDefault((Object)state, (BlockInfo)BlockInfo.INVALID).hot;
    }

    public static boolean isPlaceable(IBlockState state) {
        return placeable.containsKey(state);
    }

    public static boolean hasLegs(IBlockState state) {
        return ModRecipes.placeable.getOrDefault((Object)state, (BlockInfo)BlockInfo.INVALID).legs;
    }

    public static void init() {
        ModRecipes.addPlaceable(Blocks.field_150460_al, false, false);
        ModRecipes.addPlaceable(Blocks.field_150470_am, true, false);
        ModRecipes.addPlaceable(ExSartagineBlocks.range_extended, false, false);
        ModRecipes.addPlaceable(ExSartagineBlocks.range_extended_lit, true, false);
        ModRecipes.addPlaceable(ExSartagineBlocks.hearth_extended, false, false);
        ModRecipes.addPlaceable(ExSartagineBlocks.hearth_extended_lit, true, false);
        ModRecipes.addPlaceable(ExSartagineBlocks.range, iBlockState -> (Boolean)iBlockState.func_177229_b((IProperty)BlockRange.HEATED) == false, false, false);
        ModRecipes.addPlaceable(ExSartagineBlocks.range, iBlockState -> (Boolean)iBlockState.func_177229_b((IProperty)BlockRange.HEATED), true, false);
        ModRecipes.addPlaceable(ExSartagineBlocks.hearth, iBlockState -> (Boolean)iBlockState.func_177229_b((IProperty)BlockRange.HEATED) == false, false, false);
        ModRecipes.addPlaceable(ExSartagineBlocks.hearth, iBlockState -> (Boolean)iBlockState.func_177229_b((IProperty)BlockRange.HEATED), true, false);
        FurnaceRecipes.func_77602_a().func_151396_a((Item)ExSartagineItems.pizza_chicken_raw, new ItemStack((Item)ExSartagineItems.pizza_chicken), 0.6f);
        FurnaceRecipes.func_77602_a().func_151396_a((Item)ExSartagineItems.pizza_meat_raw, new ItemStack((Item)ExSartagineItems.pizza_meat), 0.6f);
        FurnaceRecipes.func_77602_a().func_151396_a((Item)ExSartagineItems.pizza_sweet_raw, new ItemStack((Item)ExSartagineItems.pizza_sweet), 0.6f);
        FurnaceRecipes.func_77602_a().func_151396_a((Item)ExSartagineItems.pizza_fish_raw, new ItemStack((Item)ExSartagineItems.pizza_fish), 0.6f);
        FurnaceRecipes.func_77602_a().func_151396_a(ExSartagineItems.bread_dough, new ItemStack((Item)ExSartagineItems.bread_fine), 0.6f);
        FurnaceRecipes.func_77602_a().func_151396_a((Item)ExSartagineItems.bread_meat_raw, new ItemStack((Item)ExSartagineItems.bread_meat), 0.6f);
        FurnaceRecipes.func_77602_a().func_151396_a((Item)ExSartagineItems.bread_veggie_raw, new ItemStack((Item)ExSartagineItems.bread_veggie), 0.6f);
        ModRecipes.addPotRecipe(Ingredient.func_193367_a((Item)Items.field_151110_aK), new ItemStack((Item)ExSartagineItems.boiled_egg, 1));
        ModRecipes.addPotRecipe(Ingredient.func_193367_a((Item)Items.field_185163_cU), new ItemStack((Item)ExSartagineItems.boiled_beans, 1));
        ModRecipes.addPotRecipe(Ingredient.func_193367_a((Item)Items.field_151174_bG), new ItemStack((Item)ExSartagineItems.boiled_potato, 1));
        ModRecipes.addPotRecipe(Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150348_b)), new ItemStack(ExSartagineItems.salt, 1));
        ModRecipes.addPotRecipe(Ingredient.func_193367_a((Item)ExSartagineItems.spaghetti_raw), new ItemStack((Item)ExSartagineItems.spaghetti_cooked));
        ModRecipes.addPotRecipe(Ingredient.func_193367_a((Item)ExSartagineItems.noodles_chicken), new ItemStack((Item)ExSartagineItems.noodles_chicken_cooked));
        ModRecipes.addPotRecipe(Ingredient.func_193367_a((Item)ExSartagineItems.noodles_fish), new ItemStack((Item)ExSartagineItems.noodles_fish_cooked));
        ModRecipes.addPotRecipe(Ingredient.func_193367_a((Item)ExSartagineItems.noodles_meat), new ItemStack((Item)ExSartagineItems.noodles_meat_cooked));
        ModRecipes.addPotRecipe(Ingredient.func_193367_a((Item)ExSartagineItems.noodles_veggie), new ItemStack((Item)ExSartagineItems.noodles_veggie_cooked));
        ModRecipes.addSmelterRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150366_p)}), new ItemStack(Items.field_151042_j));
        ModRecipes.addSmelterRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150352_o)}), new ItemStack(Items.field_151043_k));
        ModRecipes.addSmelterRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151119_aD)}), new ItemStack(Items.field_151118_aC));
        ModRecipes.addSmelterRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150424_aL)}), new ItemStack(Items.field_151130_bT));
        FurnaceRecipes.func_77602_a().func_77599_b().entrySet().stream().filter(entry -> ((ItemStack)entry.getKey()).func_77973_b() instanceof ItemFood).forEach(entry -> {
            ArrayList<Ingredient> i = new ArrayList<Ingredient>();
            i.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)entry.getKey()}));
            ArrayList<ItemStack> o = new ArrayList<ItemStack>();
            o.add((ItemStack)entry.getValue());
            WokRecipe wokRecipe = new WokRecipe(i, null, o, 0);
            ResourceLocation name = ((ItemStack)entry.getKey()).func_77973_b().getRegistryName();
            String path = name.func_110623_a() + (((ItemStack)entry.getKey()).func_77973_b().func_77614_k() ? Integer.valueOf(((ItemStack)entry.getKey()).func_77960_j()) : "");
            ModRecipes.addRecipe(new ResourceLocation(name.func_110624_b(), path), wokRecipe);
        });
        ModRecipes.addBuiltinKettleRecipe(Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_193367_a((Item)ExSartagineItems.dry_noodles), Ingredient.func_193367_a((Item)Items.field_151076_bf), Ingredient.func_193367_a((Item)Items.field_151054_z)}), null, new FluidStack(FluidRegistry.WATER, 100), null, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ExSartagineItems.noodles_chicken_cooked)}), 200);
        ModRecipes.addBuiltinKettleRecipe(Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_193367_a((Item)ExSartagineItems.dry_noodles), Ingredient.func_193368_a((Item[])new Item[]{Items.field_151082_bd, Items.field_151147_al}), Ingredient.func_193367_a((Item)Items.field_151054_z)}), null, new FluidStack(FluidRegistry.WATER, 100), null, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ExSartagineItems.noodles_meat_cooked)}), 200);
        ModRecipes.addBuiltinKettleRecipe(Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_193367_a((Item)ExSartagineItems.dry_noodles), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151115_aP, 1, 0), new ItemStack(Items.field_151115_aP, 1, 1)}), Ingredient.func_193367_a((Item)Items.field_151054_z)}), null, new FluidStack(FluidRegistry.WATER, 100), null, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ExSartagineItems.noodles_fish_cooked)}), 200);
        ModRecipes.addBuiltinKettleRecipe(Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_193367_a((Item)ExSartagineItems.dry_noodles), Ingredient.func_193367_a((Item)Items.field_151172_bF), Ingredient.func_193367_a((Item)Items.field_151054_z)}), null, new FluidStack(FluidRegistry.WATER, 100), null, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ExSartagineItems.noodles_veggie_cooked)}), 200);
        ModRecipes.addBuiltinKettleRecipe(Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_193367_a((Item)ExSartagineItems.spaghetti_raw), Ingredient.func_193367_a((Item)Items.field_151054_z)}), null, new FluidStack(FluidRegistry.WATER, 100), null, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ExSartagineItems.spaghetti_cooked)}), 200);
        ModRecipes.addBuiltinKettleRecipe(Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_193367_a((Item)ExSartagineItems.spaghetti_raw), Ingredient.func_193367_a((Item)Items.field_185164_cV), Ingredient.func_193367_a((Item)Items.field_151054_z)}), null, new FluidStack(FluidRegistry.WATER, 100), null, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ExSartagineItems.spaghetti_sauced)}), 200);
        ModRecipes.addBuiltinKettleRecipe(Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_193367_a((Item)ExSartagineItems.spaghetti_raw), Ingredient.func_193367_a((Item)Items.field_185164_cV), Ingredient.func_193368_a((Item[])new Item[]{Items.field_151082_bd, Items.field_151147_al, Items.field_179561_bm}), Ingredient.func_193367_a((Item)Items.field_151054_z)}), null, new FluidStack(FluidRegistry.WATER, 100), null, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ExSartagineItems.spaghetti_bolognaise)}), 200);
        ModRecipes.addBuiltinKettleRecipe(Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_193367_a((Item)ExSartagineItems.spaghetti_raw), Ingredient.func_193367_a((Item)Items.field_185164_cV), new OreIngredient("itemCheese"), Ingredient.func_193367_a((Item)Items.field_151054_z)}), null, new FluidStack(FluidRegistry.WATER, 100), null, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ExSartagineItems.spaghetti_cheese)}), 200);
        ModRecipes.addBuiltinKettleRecipe(Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_193367_a((Item)ExSartagineItems.spaghetti_raw), Ingredient.func_193367_a((Item)Items.field_185164_cV), Ingredient.func_193367_a((Item)Items.field_151172_bF), Ingredient.func_193367_a((Item)Items.field_151054_z)}), null, new FluidStack(FluidRegistry.WATER, 100), null, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ExSartagineItems.spaghetti_veggie)}), 200);
        if (ExSartagine.DEBUG) {
            ExSartagine.DebugStuff.run();
        }
    }

    public static void cacheWokInputs() {
        for (WokRecipe wokRecipe : ModRecipes.getWokRecipes()) {
            List<Ingredient> ingredients = wokRecipe.getIngredients();
            for (Ingredient ingredient : ingredients) {
                for (ItemStack stack : ingredient.func_193365_a()) {
                    validItems.add(stack.func_77973_b());
                }
            }
        }
    }

    public static <I extends IItemHandler, R extends CustomRecipe<I>> NonNullList<ItemStack> getRemainingItems(I craftMatrix, World worldIn, IRecipeType<R> type) {
        Collection<CustomRecipe> recipes = ModRecipes.getRecipes(type);
        for (CustomRecipe irecipe : recipes) {
            if (!irecipe.itemMatch(craftMatrix)) continue;
            return irecipe.getRemainingItems(craftMatrix);
        }
        NonNullList nonnulllist = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)craftMatrix.getStackInSlot(i));
        }
        return nonnulllist;
    }
}

