/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.recipe;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import subaraki.exsartagine.init.RecipeTypes;
import subaraki.exsartagine.recipe.CustomFluidRecipe;
import subaraki.exsartagine.recipe.CustomRecipe;
import subaraki.exsartagine.recipe.IIngredientWrapper;
import subaraki.exsartagine.recipe.IItemHandlerRecipeItemHelper;
import subaraki.exsartagine.recipe.IRecipeType;

public class KettleRecipe
implements CustomFluidRecipe<IItemHandler, IFluidHandler> {
    private final List<Ingredient> inputs;
    @Nullable
    private final Ingredient catalyst;
    private final FluidStack inputFluid;
    private final FluidStack outputFluid;
    private final List<ItemStack> outputs;
    private final int time;

    public KettleRecipe(List<Ingredient> inputs, @Nullable Ingredient catalyst, FluidStack inputFluid, FluidStack outputFluid, List<ItemStack> outputs, int time) {
        this.inputs = inputs;
        this.catalyst = catalyst;
        this.inputFluid = inputFluid;
        this.outputFluid = outputFluid;
        this.outputs = outputs;
        this.time = time;
    }

    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    @Override
    public boolean fluidMatch(IFluidHandler handler) {
        if (this.inputFluid == null) {
            return true;
        }
        FluidStack fluidStack = handler.getTankProperties()[0].getContents();
        return fluidStack != null && fluidStack.containsFluid(this.inputFluid);
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(IItemHandler handler) {
        return this.kettleRecipeGetRemainingItems(handler);
    }

    public NonNullList<ItemStack> kettleRecipeGetRemainingItems(IItemHandler inv) {
        NonNullList ret = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
        if (this.catalyst instanceof IIngredientWrapper) {
            IIngredient iIngredient = ((IIngredientWrapper)this.catalyst).getiIngredient();
            if (iIngredient != null && iIngredient.hasNewTransformers()) {
                try {
                    IItemStack remainingItem = iIngredient.applyNewTransform(CraftTweakerMC.getIItemStack((ItemStack)inv.getStackInSlot(0)));
                    ret.set(0, (Object)CraftTweakerMC.getItemStack((IItemStack)remainingItem));
                }
                catch (Throwable e) {
                    CraftTweakerAPI.logError((String)("Could not execute NewRecipeTransformer on " + iIngredient.toCommandString()), (Throwable)e);
                }
            }
        } else {
            ret.set(0, (Object)inv.getStackInSlot(0).func_77946_l());
        }
        for (int i = 1; i < 10; ++i) {
            ret.set(i, (Object)inv.getStackInSlot(i).func_77946_l());
        }
        return ret;
    }

    @Override
    public boolean itemMatch(IItemHandler handler) {
        if (this.catalyst != null && !this.catalyst.test((Object)handler.getStackInSlot(0))) {
            return false;
        }
        int ingredientCount = 0;
        IItemHandlerRecipeItemHelper recipeItemHelper = new IItemHandlerRecipeItemHelper();
        for (int i = 1; i < 10; ++i) {
            ItemStack itemstack = handler.getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            ++ingredientCount;
            recipeItemHelper.accountStack(itemstack, 1);
        }
        if (ingredientCount != this.inputs.size()) {
            return false;
        }
        return recipeItemHelper.canCraft(this, null);
    }

    @Override
    public List<ItemStack> getResults(IItemHandler handler) {
        return this.outputs;
    }

    @Override
    public ItemStack getDisplay() {
        return ItemStack.field_190927_a;
    }

    @Override
    public List<Ingredient> getIngredients() {
        return this.inputs;
    }

    @Override
    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    @Override
    public int getCookTime() {
        return this.time;
    }

    @Override
    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    @Override
    public int compareTo(CustomRecipe<IItemHandler> o) {
        boolean otherFluidRequirement;
        if (!(o instanceof KettleRecipe)) {
            return 0;
        }
        boolean thisFluidRequirement = this.getInputFluid() != null;
        boolean bl = otherFluidRequirement = ((KettleRecipe)o).getInputFluid() != null;
        if (thisFluidRequirement && otherFluidRequirement) {
            return 0;
        }
        if (thisFluidRequirement) {
            return -1;
        }
        if (otherFluidRequirement) {
            return 1;
        }
        return 0;
    }

    @Override
    public IRecipeType<?> getType() {
        return RecipeTypes.KETTLE;
    }
}

