/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.integration.jei.wrappers;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemStackHandler;
import subaraki.exsartagine.recipe.WokRecipe;

public class WokRecipeWrapper
implements IRecipeWrapper {
    private final WokRecipe recipe;
    private final IJeiHelpers jeiHelpers;
    private final ResourceLocation name;

    public WokRecipeWrapper(WokRecipe recipe, IJeiHelpers jeiHelpers, ResourceLocation name) {
        this.recipe = recipe;
        this.jeiHelpers = jeiHelpers;
        this.name = name;
    }

    public void getIngredients(IIngredients ingredients) {
        IStackHelper stackHelper = this.jeiHelpers.getStackHelper();
        List inputLists = stackHelper.expandRecipeItemStackInputs((List)Lists.newArrayList(this.recipe.getIngredients()));
        ingredients.setInputLists(VanillaTypes.ITEM, inputLists);
        ingredients.setOutputs(VanillaTypes.ITEM, this.recipe.getResults((ItemStackHandler)null));
        ingredients.setInput(VanillaTypes.FLUID, (Object)this.recipe.getInputFluid());
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int flips = this.recipe.getFlips();
        if (flips > 0) {
            String flipString = "" + flips;
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_78256_a(flipString);
            fontRenderer.func_78276_b(flipString, recipeWidth - stringWidth - 66, 47, Color.gray.getRGB());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("exsartagine", "textures/gui/jei/spatula.png"));
            Gui.func_146110_a((int)(recipeWidth / 2 - 3), (int)31, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }
    }
}

