/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.integration.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.item.ItemStack;
import subaraki.exsartagine.gui.client.screen.GuiPot;
import subaraki.exsartagine.gui.client.screen.GuiSmelter;
import subaraki.exsartagine.gui.client.screen.KettleScreen;
import subaraki.exsartagine.gui.common.ContainerKettle;
import subaraki.exsartagine.init.ExSartagineBlocks;
import subaraki.exsartagine.init.RecipeTypes;
import subaraki.exsartagine.integration.jei.category.AbstractCookingRecipeCategory;
import subaraki.exsartagine.integration.jei.category.KettleRecipeCategory;
import subaraki.exsartagine.integration.jei.category.PotRecipeCategory;
import subaraki.exsartagine.integration.jei.category.SmelterSmeltingRecipeCategory;
import subaraki.exsartagine.integration.jei.category.WokRecipeCategory;

@JEIPlugin
public class JeiPlugin
implements IModPlugin {
    private List<AbstractCookingRecipeCategory<?>> categories;
    private KettleRecipeCategory kettleRecipeCategory;

    public void registerCategories(IRecipeCategoryRegistration reg) {
        this.categories = new ArrayList();
        IGuiHelper helper = reg.getJeiHelpers().getGuiHelper();
        this.categories.add(new SmelterSmeltingRecipeCategory(new ItemStack(ExSartagineBlocks.smelter), helper));
        this.categories.add(new PotRecipeCategory(new ItemStack(ExSartagineBlocks.pot), helper));
        this.kettleRecipeCategory = new KettleRecipeCategory(new ItemStack(ExSartagineBlocks.kettle), helper);
        this.categories.add(this.kettleRecipeCategory);
        this.categories.add(new WokRecipeCategory(new ItemStack(ExSartagineBlocks.wok), helper));
        for (AbstractCookingRecipeCategory<?> category : this.categories) {
            reg.addRecipeCategories(new IRecipeCategory[]{category});
        }
    }

    public void register(IModRegistry registry) {
        for (AbstractCookingRecipeCategory<?> category : this.categories) {
            category.setup(registry);
        }
        registry.addRecipeClickArea(GuiPot.class, 80, 32, 26, 23, new String[]{"exsartagine." + RecipeTypes.POT.name()});
        registry.addRecipeClickArea(GuiSmelter.class, 78, 20, 28, 23, new String[]{"exsartagine." + RecipeTypes.SMELTER.name()});
        registry.addRecipeClickArea(KettleScreen.class, 85, 34, 21, 17, new String[]{"exsartagine." + RecipeTypes.KETTLE.name()});
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler(ContainerKettle.class, this.kettleRecipeCategory.getUid(), 0, 10, 20, 36);
    }
}

