/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.integration;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDevice1;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.util.EnumFacing;
import subaraki.exsartagine.recipe.ModRecipes;
import subaraki.exsartagine.tileentity.TileEntityRange;
import subaraki.exsartagine.tileentity.util.KitchenwareBlockEntity;

public class ImmersiveEngineering {
    public static void registerHeatableAdapters() {
        ExternalHeaterHandler.registerHeatableAdapter(KitchenwareBlockEntity.class, (ExternalHeaterHandler.HeatableAdapter)new KitchenwareAdapter());
        ImmersiveEngineering.addPlaceableForHeater();
        ExternalHeaterHandler.registerHeatableAdapter(TileEntityRange.class, (ExternalHeaterHandler.HeatableAdapter)new RangeAdapter());
    }

    private static void addPlaceableForHeater() {
        ModRecipes.addPlaceable((Block)IEContent.blockMetalDevice1, iBlockState -> iBlockState.func_177229_b((IProperty)PropertyEnum.func_177709_a((String)"type", BlockTypes_MetalDevice1.class)) == BlockTypes_MetalDevice1.FURNACE_HEATER && (Boolean)iBlockState.func_177229_b((IProperty)IEProperties.MULTIBLOCKSLAVE) == false && iBlockState.func_177229_b((IProperty)IEProperties.FACING_ALL) != EnumFacing.UP && (Boolean)iBlockState.func_177229_b((IProperty)IEProperties.BOOLEANS[0]) != false, true, false);
        ModRecipes.addPlaceable((Block)IEContent.blockMetalDevice1, iBlockState -> iBlockState.func_177229_b((IProperty)PropertyEnum.func_177709_a((String)"type", BlockTypes_MetalDevice1.class)) == BlockTypes_MetalDevice1.FURNACE_HEATER && (Boolean)iBlockState.func_177229_b((IProperty)IEProperties.MULTIBLOCKSLAVE) == false && iBlockState.func_177229_b((IProperty)IEProperties.FACING_ALL) != EnumFacing.UP && (Boolean)iBlockState.func_177229_b((IProperty)IEProperties.BOOLEANS[0]) == false, false, false);
    }

    public static class RangeAdapter
    extends ExternalHeaterHandler.HeatableAdapter<TileEntityRange> {
        public int doHeatTick(TileEntityRange tileEntity, int energyAvailable, boolean redstone) {
            int heatEnergyRatio;
            int heatAttempt;
            int energyToUse;
            int heat;
            int burnTime;
            int energyConsumed = 0;
            if (redstone && (burnTime = tileEntity.getFuelTimer()) < 200 && (heat = (energyToUse = Math.min(energyAvailable, (heatAttempt = 4) * (heatEnergyRatio = Math.max(1, Config.IEConfig.Machines.heater_consumption)))) / heatEnergyRatio) > 0) {
                tileEntity.setFuelTimer(burnTime + heat);
                energyConsumed += heat * heatEnergyRatio;
            }
            return energyConsumed;
        }
    }

    public static class KitchenwareAdapter
    extends ExternalHeaterHandler.HeatableAdapter<KitchenwareBlockEntity> {
        public int doHeatTick(KitchenwareBlockEntity tileEntity, int energyAvailable, boolean redstone) {
            int consumption = Config.IEConfig.Machines.heater_consumption;
            if (redstone && energyAvailable >= consumption) {
                return consumption;
            }
            return 0;
        }
    }
}

