/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.integration;

import com.google.common.collect.Sets;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import subaraki.exsartagine.recipe.IIngredientWrapper;
import subaraki.exsartagine.recipe.ModRecipes;

@ZenRegister
@ZenClass(value="mods.exsartagine.ExSartagine")
public class CraftTweakerSupport {
    @ZenMethod
    public static void addPotRecipe(IIngredient input, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new AddPotAction(CraftTweakerMC.getIngredient((IIngredient)input), CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    @ZenMethod
    public static void removePotRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new RemovePotAction(CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    @ZenMethod
    public static void removePotRecipe(IIngredient input, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new RemovePotAction(CraftTweakerMC.getIngredient((IIngredient)input), CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    @ZenMethod
    public static void addWokRecipe(IIngredient[] inputs, IItemStack[] outputs, @Optional int flips) {
        CraftTweakerSupport.addWokRecipe(inputs, null, outputs, flips);
    }

    @ZenMethod
    public static void addWokRecipe(IIngredient[] inputs, ILiquidStack liquid, IItemStack[] outputs, @Optional int flips) {
        List<Ingredient> iinputs = Arrays.stream(inputs).map(CraftTweakerMC::getIngredient).collect(Collectors.toList());
        FluidStack fluidStack = CraftTweakerMC.getLiquidStack((ILiquidStack)liquid);
        List<ItemStack> iOutputs = Arrays.stream(outputs).map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
        CraftTweakerAPI.apply((IAction)new AddWokAction(iinputs, fluidStack, iOutputs, flips));
    }

    @ZenMethod
    public static void removeWokRecipe(String name) {
        CraftTweakerAPI.apply((IAction)new RemoveWokAction(new ResourceLocation(name)));
    }

    @ZenMethod
    public static void addSmelterRecipe(IIngredient input, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new AddSmelterAction(CraftTweakerMC.getIngredient((IIngredient)input), CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    @ZenMethod
    public static void removeSmelterRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new RemoveSmelterAction(CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    @ZenMethod
    public static void removeSmelterRecipe(IIngredient input, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new RemoveSmelterAction(CraftTweakerMC.getIngredient((IIngredient)input), CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    @ZenMethod
    public static void addKettleRecipe(IIngredient[] inputs, ILiquidStack liquid, IItemStack[] outputs, @Optional(value="200") int time) {
        CraftTweakerSupport.addKettleRecipe(inputs, null, liquid, null, outputs, time);
    }

    @ZenMethod
    public static void addKettleRecipe(IIngredient[] inputs, IIngredient catalyst, ILiquidStack liquid, IItemStack[] outputs, @Optional(value="200") int time) {
        CraftTweakerSupport.addKettleRecipe(inputs, catalyst, liquid, null, outputs, time);
    }

    @ZenMethod
    public static void addKettleRecipe(IIngredient[] inputs, IIngredient catalyst, ILiquidStack liquidInput, ILiquidStack liquidOutput, IItemStack[] outputs, @Optional(value="200") int time) {
        List<Ingredient> iinputs = Arrays.stream(inputs).map(CraftTweakerMC::getIngredient).collect(Collectors.toList());
        IIngredientWrapper iCatalyst = new IIngredientWrapper(catalyst);
        FluidStack iFluidInput = CraftTweakerMC.getLiquidStack((ILiquidStack)liquidInput);
        FluidStack iFluidOutput = CraftTweakerMC.getLiquidStack((ILiquidStack)liquidOutput);
        List<ItemStack> iOutputs = Arrays.stream(outputs).map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
        CraftTweakerAPI.apply((IAction)new AddKettleAction(iinputs, iCatalyst, iFluidInput, iFluidOutput, iOutputs, time));
    }

    @ZenMethod
    public static void removeKettleRecipe(String name) {
        CraftTweakerAPI.apply((IAction)new RemoveKettleAction(new ResourceLocation(name)));
    }

    @ZenMethod
    public static void addPlaceable(crafttweaker.api.block.IBlockState state, boolean heat, @Optional boolean legs) {
        CraftTweakerAPI.apply((IAction)new BlockStateAction(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state), heat, true, legs));
    }

    @ZenMethod
    public static void addPlaceable(IBlock block, boolean heat, @Optional boolean legs) {
        CraftTweakerAPI.apply((IAction)new BlockStateAction((Collection<IBlockState>)CraftTweakerMC.getBlock((IBlock)block).func_176194_O().func_177619_a(), heat, true, legs));
    }

    @ZenMethod
    public static void removePlaceable(crafttweaker.api.block.IBlockState state) {
        CraftTweakerAPI.apply((IAction)new BlockStateAction(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state), false, false, false));
    }

    @ZenMethod
    public static void removePlaceable(IBlock block) {
        CraftTweakerAPI.apply((IAction)new BlockStateAction((Collection<IBlockState>)CraftTweakerMC.getBlock((IBlock)block).func_176194_O().func_177619_a(), false, false, false));
    }

    private static class AddSmelterAction
    implements IAction {
        private final Ingredient input;
        private final ItemStack output;

        public AddSmelterAction(Ingredient input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public String describe() {
            return "Adding pot recipe with input " + this.input;
        }

        public void apply() {
            ModRecipes.addSmelterRecipe(this.input, this.output);
        }
    }

    private static class RemoveWokAction
    implements IAction {
        private final ResourceLocation name;

        public RemoveWokAction(ResourceLocation name) {
            this.name = name;
        }

        public String describe() {
            return "Removing wok recipe with name " + this.name;
        }

        public void apply() {
            boolean done = ModRecipes.removeWokRecipeByName(this.name);
            if (!done) {
                CraftTweakerAPI.logWarning((String)("No pot recipes removed for name " + this.name));
            }
        }
    }

    private static class BlockStateAction
    implements IAction {
        private final Collection<IBlockState> states;
        private final boolean isHeatSource;
        private final boolean legs;
        private final boolean add;

        public BlockStateAction(IBlockState state, boolean isHeatSource, boolean add, boolean legs) {
            this(Sets.newHashSet((Object[])new IBlockState[]{state}), isHeatSource, add, legs);
        }

        public BlockStateAction(Collection<IBlockState> states, boolean isHeatSource, boolean add, boolean legs) {
            this.states = states;
            this.isHeatSource = isHeatSource;
            this.add = add;
            this.legs = legs;
        }

        public String describe() {
            return (this.add ? "Adding " : "Removing ") + (this.isHeatSource ? "heat source " : "placeable ") + "with block states " + this.states.stream().map(Object::toString).collect(Collectors.joining(",")) + " legs:" + this.legs;
        }

        public void apply() {
            if (this.add) {
                ModRecipes.addPlaceable(this.states, this.isHeatSource, this.legs);
            } else {
                boolean done = ModRecipes.removePlaceables(this.states);
                if (!done) {
                    CraftTweakerAPI.logWarning((String)("No " + (this.isHeatSource ? "heat sources " : "placeables ") + "were removed for block state " + this.states));
                }
            }
        }
    }

    private static class RemoveKettleAction
    implements IAction {
        private final ResourceLocation name;

        public RemoveKettleAction(ResourceLocation name) {
            this.name = name;
        }

        public String describe() {
            return "Removing kettle recipe with name " + this.name;
        }

        public void apply() {
            boolean done = ModRecipes.removeKettleRecipeByName(this.name);
            if (!done) {
                CraftTweakerAPI.logWarning((String)("No kettle recipes removed for name " + this.name));
            }
        }
    }

    private static class AddWokAction
    implements IAction {
        private final List<Ingredient> inputs;
        private final FluidStack fluid;
        private final List<ItemStack> output;
        private final int flips;

        public AddWokAction(List<Ingredient> inputs, FluidStack fluid, List<ItemStack> output, int flips) {
            this.inputs = inputs;
            this.fluid = fluid;
            this.output = output;
            this.flips = flips;
        }

        public String describe() {
            return "Adding wok recipe with input " + this.inputs;
        }

        public void apply() {
            ModRecipes.addWokRecipe(this.inputs, this.fluid, this.output, this.flips);
        }
    }

    private static class AddKettleAction
    implements IAction {
        private final List<Ingredient> inputs;
        private final Ingredient catalyst;
        private final FluidStack fluidInput;
        private final FluidStack fluidOutput;
        private final List<ItemStack> outputs;
        private final int time;

        public AddKettleAction(List<Ingredient> inputs, Ingredient catalyst, @Nullable FluidStack fluidInput, @Nullable FluidStack fluidOutput, List<ItemStack> outputs, int time) {
            this.inputs = inputs;
            this.catalyst = catalyst;
            this.fluidInput = fluidInput;
            this.fluidOutput = fluidOutput;
            this.outputs = outputs;
            this.time = time;
        }

        public String describe() {
            return "Adding kettle " + this.fluidOutput == null ? "consumption" : "transformation recipe with inputs " + this.inputs + ", catalyst " + this.catalyst + ", fluid input " + this.fluidInput + (this.fluidOutput == null ? "" : ", fluid output " + this.fluidOutput) + ", outputs " + this.outputs + ", and duration " + this.time;
        }

        public void apply() {
            ModRecipes.addKettleRecipe(this.inputs, this.catalyst, this.fluidInput, this.fluidOutput, this.outputs, this.time);
        }
    }

    private static class RemoveSmelterAction
    implements IAction {
        private final Ingredient input;
        private final ItemStack output;

        public RemoveSmelterAction(ItemStack output) {
            this.input = null;
            this.output = output;
        }

        public RemoveSmelterAction(Ingredient input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public String describe() {
            if (this.input == null) {
                return "Removing smelter recipe with output " + this.output;
            }
            return "Removing smelter recipe with input " + this.input + " and output " + this.output;
        }

        public void apply() {
            boolean done = this.input == null ? ModRecipes.removeSmelterRecipe(this.output) : ModRecipes.removeSmelterRecipe(this.input, this.output);
            if (!done) {
                if (this.input == null) {
                    CraftTweakerAPI.logWarning((String)("No smelter recipes removed for output " + this.output));
                } else {
                    CraftTweakerAPI.logWarning((String)("No smelter recipes removed for input " + this.input + " and output " + this.output));
                }
            }
        }
    }

    private static class RemovePotAction
    implements IAction {
        private final Ingredient input;
        private final ItemStack output;

        public RemovePotAction(ItemStack output) {
            this.input = null;
            this.output = output;
        }

        public RemovePotAction(Ingredient input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public String describe() {
            if (this.input == null) {
                return "Removing pot recipe with output " + this.output;
            }
            return "Removing pot recipe with input " + this.input + " and output " + this.output;
        }

        public void apply() {
            boolean done = this.input == null ? ModRecipes.removePotRecipe(this.output) : ModRecipes.removePotRecipe(this.input, this.output);
            if (!done) {
                CraftTweakerAPI.logWarning((String)("No pot recipes removed for input " + this.input + " and output " + this.output));
            }
        }
    }

    private static class AddPotAction
    implements IAction {
        private final Ingredient input;
        private final ItemStack output;

        public AddPotAction(Ingredient input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public String describe() {
            return "Adding pot recipe with input " + this.input;
        }

        public void apply() {
            ModRecipes.addPotRecipe(this.input, this.output);
        }
    }
}

