/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.gui.client.screen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import subaraki.exsartagine.gui.client.SmallButton;
import subaraki.exsartagine.gui.common.ContainerKettle;
import subaraki.exsartagine.network.ClearTankPacket;
import subaraki.exsartagine.network.PacketHandler;
import subaraki.exsartagine.network.SwapTanksPacket;
import subaraki.exsartagine.tileentity.TileEntityKettle;

public class KettleScreen
extends GuiContainer {
    private static final ResourceLocation GUI_POT = new ResourceLocation("exsartagine", "textures/gui/kettle.png");
    private final InventoryPlayer playerInventory;
    private final TileEntityKettle kettle;
    private static final int BUTTON_ID = 837890435;
    private static final ResourceLocation BUTTON_TEXTURE = new ResourceLocation("exsartagine", "textures/gui/switch.png");
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    private static final int FL_WIDTH = 7;
    private static final int FL_HEIGHT = 52;
    private static final int FL_Y = 18;
    private static final int FL_INPUT_X = 77;
    private static final int FL_OUTPUT_X = 108;

    public KettleScreen(EntityPlayer player, TileEntityKettle kettle) {
        super((Container)new ContainerKettle(player.field_71071_by, kettle));
        this.playerInventory = player.field_71071_by;
        this.kettle = kettle;
        this.field_146999_f += 16;
        this.field_147000_g += 16;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.func_189646_b((GuiButton)new GuiButtonImage(837890435, this.field_147003_i + 86, this.field_147009_r + 50, 20, 20, 0, 0, 0, BUTTON_TEXTURE));
        this.func_189646_b(new SmallButton(1, this.field_147003_i + 76, this.field_147009_r + 69, 10, 10, ""));
        this.func_189646_b(new SmallButton(2, this.field_147003_i + 107, this.field_147009_r + 69, 10, 10, ""));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 837890435) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new SwapTanksPacket());
        } else if (button.field_146127_k == 1) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new ClearTankPacket(true));
        } else if (button.field_146127_k == 2) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new ClearTankPacket(false));
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = I18n.func_135052_a((String)"kettle.gui", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(s, 1, 0, 0xFFFFFF);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 10, this.field_147000_g - 93, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(GUI_POT);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        float progress = 22.0f * (float)this.kettle.getProgress() / (float)this.kettle.getClientCookTime();
        this.func_73729_b(i + 85, j + 34, 0, 182, (int)progress, 15);
        this.renderFluid(this.field_146297_k, i + 77, j + 18 - 2, this.kettle.fluidInputTank);
        this.renderFluid(this.field_146297_k, i + 108, j + 18 - 2, this.kettle.fluidOutputTank);
    }

    public void renderFluid(Minecraft minecraft, int xPosition, int yPosition, FluidTank fluidTank) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        this.drawFluid(minecraft, xPosition, yPosition, fluidTank);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    private void drawFluid(Minecraft minecraft, int xPosition, int yPosition, FluidTank fluidTank) {
        FluidStack fluidStack = fluidTank.getFluid();
        if (fluidStack == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return;
        }
        TextureAtlasSprite fluidStillSprite = KettleScreen.getStillFluidSprite(minecraft, fluid);
        int fluidColor = fluid.getColor(fluidStack);
        int scaledAmount = fluidStack.amount * 52 / fluidTank.getCapacity();
        if (fluidStack.amount > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        if (scaledAmount > this.field_146295_m) {
            scaledAmount = this.field_146295_m;
        }
        this.drawTiledSprite(minecraft, xPosition, yPosition, 7, 52, fluidColor, scaledAmount, fluidStillSprite);
    }

    private void drawTiledSprite(Minecraft minecraft, int xPosition, int yPosition, int tiledWidth, int tiledHeight, int color, int scaledAmount, TextureAtlasSprite sprite) {
        minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        KettleScreen.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = yPosition + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = xPosition + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                KettleScreen.drawTextureWithMasking(x, y, sprite, maskTop, maskRight, 100.0);
            }
        }
    }

    private static TextureAtlasSprite getStillFluidSprite(Minecraft minecraft, Fluid fluid) {
        TextureMap textureMapBlocks = minecraft.func_147117_R();
        ResourceLocation fluidStill = fluid.getStill();
        TextureAtlasSprite fluidStillSprite = null;
        if (fluidStill != null) {
            fluidStillSprite = textureMapBlocks.getTextureExtry(fluidStill.toString());
        }
        if (fluidStillSprite == null) {
            fluidStillSprite = textureMapBlocks.func_174944_f();
        }
        return fluidStillSprite;
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private static void drawTextureWithMasking(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        double uMin = textureSprite.func_94209_e();
        double uMax = textureSprite.func_94212_f();
        double vMin = textureSprite.func_94206_g();
        double vMax = textureSprite.func_94210_h();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b(xCoord, yCoord + 16.0, zLevel).func_187315_a(uMin, vMax).func_181675_d();
        bufferBuilder.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_187315_a(uMax, vMax).func_181675_d();
        bufferBuilder.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_187315_a(uMax, vMin).func_181675_d();
        bufferBuilder.func_181662_b(xCoord, yCoord + (double)maskTop, zLevel).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    public List<String> getFluidTooltip(FluidTank fluidTank) {
        ArrayList<String> tooltip = new ArrayList<String>();
        FluidStack fluidStack = fluidTank.getFluid();
        if (fluidStack == null) {
            return tooltip;
        }
        String fluidName = fluidStack.getLocalizedName();
        tooltip.add(fluidName);
        String amount = I18n.func_135052_a((String)"jei.tooltip.liquid.amount.with.capacity", (Object[])new Object[]{fluidStack.amount, fluidTank.getCapacity()});
        tooltip.add(TextFormatting.GRAY + amount);
        return tooltip;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_191948_b(int x, int y) {
        super.func_191948_b(x, y);
        if (this.func_146978_c(77, 18, 7, 52, x, y) && this.kettle.fluidInputTank.getFluid() != null) {
            this.drawHoveringText(this.getFluidTooltip(this.kettle.fluidInputTank), x, y, this.field_146289_q);
        }
        if (this.func_146978_c(108, 18, 7, 52, x, y) && this.kettle.fluidOutputTank.getFluid() != null) {
            this.drawHoveringText(this.getFluidTooltip(this.kettle.fluidOutputTank), x, y, this.field_146289_q);
        }
    }
}

