/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import subaraki.exsartagine.Oredict;
import subaraki.exsartagine.Utils;
import subaraki.exsartagine.block.KitchenwareBlock;
import subaraki.exsartagine.init.ExSartagineItems;
import subaraki.exsartagine.recipe.ModRecipes;
import subaraki.exsartagine.tileentity.WokBlockEntity;
import subaraki.exsartagine.tileentity.util.KitchenwareBlockEntity;

public class WokBlock
extends KitchenwareBlock {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public WokBlock() {
        super(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(ExSartagineItems.pots);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149711_c(3.5f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new WokBlockEntity();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof WokBlockEntity) {
            WokBlockEntity wokBlockEntity = (WokBlockEntity)tileEntity;
            if (!worldIn.field_72995_K) {
                if (!stack.func_190926_b()) {
                    if (Oredict.checkMatch("ore:spatula", stack)) {
                        wokBlockEntity.flip(playerIn, stack);
                    } else {
                        FluidActionResult fluidActionResult = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, wokBlockEntity.getFluidInventoryInput(), (IItemHandler)new InvWrapper((IInventory)playerIn.field_71071_by), (int)Integer.MAX_VALUE, (EntityPlayer)playerIn, (boolean)true);
                        if (fluidActionResult.isSuccess()) {
                            playerIn.func_184611_a(hand, fluidActionResult.getResult());
                        } else if (ModRecipes.validItems.contains(stack.func_77973_b())) {
                            ItemStack single = stack.func_77946_l();
                            single.func_190920_e(1);
                            ItemStack returns = wokBlockEntity.addSingleItem(single);
                            if (returns.func_190926_b() && !playerIn.field_71075_bZ.field_75098_d) {
                                stack.func_190918_g(1);
                            }
                        }
                    }
                } else {
                    wokBlockEntity.giveItems(playerIn);
                }
            }
        }
        return true;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        TileEntity tileentity;
        if (!worldIn.field_72995_K && playerIn.func_70093_af() && (tileentity = worldIn.func_175625_s(pos)) instanceof KitchenwareBlockEntity) {
            KitchenwareBlockEntity te = (KitchenwareBlockEntity)tileentity;
            Utils.scatter(worldIn, pos, te.getEntireItemInventory());
            te.func_70296_d();
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        WokBlockEntity wokBlockEntity;
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.15;
        double d2 = (double)pos.func_177952_p() + 0.5;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof WokBlockEntity && (wokBlockEntity = (WokBlockEntity)tileEntity).isCooking()) {
            worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + (RANDOM.nextDouble() / 1.5 - 0.35), d1, d2 + (RANDOM.nextDouble() / 1.5 - 0.35), 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + (RANDOM.nextDouble() / 1.5 - 0.35), d1, d2 + (RANDOM.nextDouble() / 1.5 - 0.35), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LEGS});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + super.func_176201_c(state);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        boolean legs = (meta & 8) != 0;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)LEGS, (Comparable)Boolean.valueOf(legs));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }
}

