/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import subaraki.exsartagine.Utils;
import subaraki.exsartagine.recipe.ModRecipes;
import subaraki.exsartagine.tileentity.util.KitchenwareBlockEntity;

public abstract class KitchenwareBlock
extends Block {
    public static final PropertyBool LEGS = PropertyBool.func_177716_a((String)"legs");
    public static final int LEGS_BIT = 8;

    public KitchenwareBlock(Material materialIn) {
        super(materialIn);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)LEGS, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return ModRecipes.isPlaceable(world.func_180495_p(pos.func_177977_b()).func_185899_b((IBlockAccess)world, pos.func_177977_b()));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof KitchenwareBlockEntity) {
            KitchenwareBlockEntity te = (KitchenwareBlockEntity)tileentity;
            Utils.scatter(worldIn, pos, te.getEntireItemInventory());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LEGS});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LEGS) != false ? 8 : 0;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        boolean legs = ModRecipes.hasLegs(state);
        return this.func_176223_P().func_177226_a((IProperty)LEGS, (Comparable)Boolean.valueOf(legs));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState down;
        if (fromPos.func_177984_a().equals((Object)pos) && !ModRecipes.isPlaceable(down = world.func_180495_p(fromPos))) {
            this.func_176226_b(world, pos, this.func_176223_P(), 0);
            world.func_175698_g(pos);
        }
    }
}

