/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.block;

import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import subaraki.exsartagine.block.BlockRange;
import subaraki.exsartagine.tileentity.TileEntityRange;
import subaraki.exsartagine.tileentity.TileEntityRangeExtension;

public class BlockRangeExtension
extends Block {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private final boolean lit;
    private final Supplier<Block> cold;
    private final Supplier<Block> hot;
    private final Supplier<Set<Block>> valid;

    public BlockRangeExtension(boolean lit, Supplier<Block> cold, Supplier<Block> hot, Supplier<Set<Block>> valid) {
        super(Material.field_151576_e);
        this.lit = lit;
        this.cold = cold;
        this.hot = hot;
        this.valid = valid;
        this.func_149711_c(8.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(CreativeTabs.field_78040_i);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(3.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH));
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityRangeExtension rangeExtension;
        BlockPos contPos;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityRangeExtension && ((contPos = (rangeExtension = (TileEntityRangeExtension)te).getParentRange()) == null || !this.canStay(world, pos))) {
            world.func_175655_b(pos, true);
        }
    }

    public boolean canStay(World level, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.Plane.HORIZONTAL) {
            BlockPos offset = pos.func_177972_a(dir);
            Block block = level.func_180495_p(offset).func_177230_c();
            if (!this.valid.get().contains(block)) continue;
            return true;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity range;
        BlockPos parentRange;
        TileEntity tile;
        IBlockState newState = worldIn.func_180495_p(pos);
        if (!(newState.func_177230_c() instanceof BlockRangeExtension) && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityRangeExtension && (parentRange = ((TileEntityRangeExtension)tile).getParentRange()) != null && (range = worldIn.func_175625_s(parentRange)) instanceof TileEntityRange) {
            ((TileEntityRange)range).disconnect(pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.Plane.HORIZONTAL) {
            TileEntity te1;
            TileEntityRangeExtension rangeExtension;
            BlockPos rangePos;
            BlockPos offset = pos.func_177972_a(dir);
            TileEntity te = worldIn.func_175625_s(offset);
            if (!(te instanceof TileEntityRangeExtension ? (rangePos = (rangeExtension = (TileEntityRangeExtension)te).getParentRange()) != null && (te1 = worldIn.func_175625_s(rangePos)) instanceof TileEntityRange : te instanceof TileEntityRange)) continue;
            TileEntityRange range = (TileEntityRange)te1;
            return range.canConnect() && super.func_176196_c(worldIn, pos);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityRangeExtension();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.lit) {
            BlockRange.smokeParticles(stateIn, worldIn, pos, rand);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.getColdBlock());
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(this.getColdBlock());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta & 3));
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityRangeExtension && !worldIn.field_72995_K) {
            for (EnumFacing dir : EnumFacing.Plane.HORIZONTAL) {
                TileEntityRange range;
                BlockPos offset = pos.func_177972_a(dir);
                TileEntity te = worldIn.func_175625_s(offset);
                if (te instanceof TileEntityRangeExtension) {
                    TileEntityRange range2;
                    TileEntity te1;
                    TileEntityRangeExtension rangeExtension = (TileEntityRangeExtension)te;
                    BlockPos rangePos = rangeExtension.getParentRange();
                    if (rangePos == null || !((te1 = worldIn.func_175625_s(rangePos)) instanceof TileEntityRange) || !(range2 = (TileEntityRange)te1).canConnect()) continue;
                    range2.connect((TileEntityRangeExtension)tile);
                    return;
                }
                if (!(te instanceof TileEntityRange) || !(range = (TileEntityRange)te).canConnect()) continue;
                range.connect((TileEntityRangeExtension)tile);
                return;
            }
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public Block getColdBlock() {
        return this.cold.get();
    }

    public Block getHotBlock() {
        return this.hot.get();
    }
}

