/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine.block;

import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableAdjacentIgniterBlock;
import com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableWithIgniterItem;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import subaraki.exsartagine.ExSartagine;
import subaraki.exsartagine.Oredict;
import subaraki.exsartagine.Utils;
import subaraki.exsartagine.init.ExSartagineItems;
import subaraki.exsartagine.tileentity.TileEntityRange;

@Optional.InterfaceList(value={@Optional.Interface(modid="pyrotech", iface="com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableWithIgniterItem"), @Optional.Interface(modid="pyrotech", iface="com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableAdjacentIgniterBlock")})
public class BlockRange
extends Block
implements IBlockIgnitableWithIgniterItem,
IBlockIgnitableAdjacentIgniterBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool HEATED = PropertyBool.func_177716_a((String)"heated");
    private final Supplier<Boolean> manualIgnition;
    private final int maxExtensions;
    private final boolean hearth;
    private final double fuelEfficiency;

    public BlockRange(Supplier<Boolean> manualIgnition, int maxExtensions, boolean hearth, double fuelEfficiency) {
        super(Material.field_151573_f);
        this.manualIgnition = manualIgnition;
        this.maxExtensions = maxExtensions;
        this.hearth = hearth;
        this.fuelEfficiency = fuelEfficiency;
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(ExSartagineItems.pots);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149711_c(3.5f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)HEATED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileEntityRange)) {
            return false;
        }
        if (this.manualIgnition.get().booleanValue() && !((TileEntityRange)tile).isSelfIgnitingUpgrade()) {
            ItemStack stack = player.func_184586_b(hand);
            boolean matches = Oredict.checkMatch("ore:igniter", stack);
            if (matches) {
                if (!worldIn.field_72995_K) {
                    ((TileEntityRange)tile).createSparks();
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, player.func_70681_au().nextFloat() * 0.4f + 0.8f);
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
                return true;
            }
            matches = Oredict.checkMatch("exsartagine:self_igniter_upgrade", stack);
            if (matches) {
                if (!worldIn.field_72995_K) {
                    ((TileEntityRange)tile).setSelfIgnitingUpgrade(true);
                    stack.func_190918_g(1);
                }
                return true;
            }
        }
        player.openGui((Object)ExSartagine.instance, 3, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
    }

    public int func_149750_m(IBlockState state) {
        if (this.hearth && ((Boolean)state.func_177229_b((IProperty)HEATED)).booleanValue()) {
            return 14;
        }
        return super.func_149750_m(state);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityRange) {
            TileEntityRange entityRange = (TileEntityRange)tileentity;
            ItemStack itemstack = new ItemStack(Item.func_150898_a((Block)this));
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound.func_74782_a("BlockEntityTag", (NBTBase)entityRange.saveToItemNbt(nbttagcompound1));
            itemstack.func_77982_d(nbttagcompound);
            BlockRange.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
            worldIn.func_175666_e(pos, state.func_177230_c());
            TileEntityRange range = (TileEntityRange)tileentity;
            Utils.scatter(worldIn, pos, (IItemHandler)range.getInventory());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Optional.Method(modid="pyrotech")
    public void igniteWithIgniterItem(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityRange) {
            TileEntityRange range = (TileEntityRange)tile;
            if (blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL) == facing && this.manualIgnition.get().booleanValue() && !range.isSelfIgnitingUpgrade() && !world.field_72995_K) {
                range.createSparks();
            }
        }
    }

    @Optional.Method(modid="pyrotech")
    public void igniteWithAdjacentIgniterBlock(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityRange) {
            TileEntityRange range = (TileEntityRange)tile;
            if (this.manualIgnition.get().booleanValue() && !range.isSelfIgnitingUpgrade() && !world.field_72995_K) {
                range.createSparks();
            }
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityRange();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (worldIn.func_175625_s(pos) instanceof TileEntityRange && ((TileEntityRange)worldIn.func_175625_s(pos)).isFueled()) {
            if (this.hearth) {
                BlockRange.vanillaFurnaceParticles(stateIn, worldIn, pos, rand);
            } else {
                BlockRange.smokeParticles(stateIn, worldIn, pos, rand);
            }
        }
    }

    public static void vanillaFurnaceParticles(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
        double x0 = (double)pos.func_177958_n() + 0.5;
        double y0 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0 + 0.0625;
        double z0 = (double)pos.func_177952_p() + 0.5;
        double d3 = 0.52;
        double d4 = rand.nextDouble() * 0.6 - 0.3;
        if (rand.nextDouble() < 0.1) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
        switch (enumfacing) {
            case WEST: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x0 - d3, y0, z0 + d4, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, x0 - d3, y0, z0 + d4, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case EAST: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x0 + d3, y0, z0 + d4, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, x0 + d3, y0, z0 + d4, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case NORTH: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x0 + d4, y0, z0 - d3, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, x0 + d4, y0, z0 - d3, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case SOUTH: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x0 + d4, y0, z0 + d3, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, x0 + d4, y0, z0 + d3, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public static void smokeParticles(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
        double x0 = (double)pos.func_177958_n() + 0.5;
        double y0 = (double)pos.func_177956_o() + rand.nextDouble() * 2.0 / 16.0 + 0.625;
        double z0 = (double)pos.func_177952_p() + 0.5;
        double d3 = 0.52;
        double d4 = rand.nextDouble() * 4.0 / 16.0 - 0.125;
        switch (enumfacing) {
            case WEST: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x0 + d3, y0, z0 + d4, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case EAST: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x0 - d3, y0, z0 + d4, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case NORTH: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x0 + d4, y0, z0 + d3, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case SOUTH: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x0 + d4, y0, z0 - d3, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HEATED});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() | ((Boolean)state.func_177229_b((IProperty)HEATED) != false ? 4 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        boolean heated = (meta & 4) != 0;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)HEATED, (Comparable)Boolean.valueOf(heated));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public int getMaxExtensions() {
        return this.maxExtensions;
    }

    public Supplier<Boolean> isManualIgnition() {
        return this.manualIgnition;
    }

    public double getFuelEfficiency() {
        return this.fuelEfficiency;
    }
}

