/*
 * Decompiled with CFR 0.152.
 */
package subaraki.exsartagine;

import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void scatter(World worldIn, BlockPos pos, IItemHandler inventory) {
        Utils.dropInventoryItems(worldIn, pos, inventory);
    }

    public static void dropInventoryItems(World worldIn, BlockPos pos, IItemHandler inventory) {
        Utils.dropInventoryItems(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), inventory);
    }

    public static void dropInventoryItems(World worldIn, Entity entityAt, IItemHandler inventory) {
        Utils.dropInventoryItems(worldIn, entityAt.field_70165_t, entityAt.field_70163_u, entityAt.field_70161_v, inventory);
    }

    private static void dropInventoryItems(World worldIn, double x, double y, double z, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)worldIn, (double)x, (double)y, (double)z, (ItemStack)itemstack);
        }
    }

    public static boolean doesStackMatchOre(@Nonnull ItemStack stack, String name) {
        if (!OreDictionary.doesOreNameExist((String)name)) {
            LOGGER.warn("doesStackMatchOre called with non-existing name. stack: {} name: {}", (Object)stack, (Object)name);
            return false;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        int needle = OreDictionary.getOreID((String)name);
        int[] var3 = OreDictionary.getOreIDs((ItemStack)stack);
        return Arrays.stream(var3).anyMatch(id -> id == needle);
    }

    public static NonNullList<ItemStack> defaultRecipeGetRemainingItems(IItemHandler inv) {
        NonNullList ret = NonNullList.func_191197_a((int)inv.getSlots(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)inv.getStackInSlot(i)));
        }
        return ret;
    }
}

