/*
 * Decompiled with CFR 0.152.
 */
package fluke.stygian.world.genlayers;

import fluke.stygian.config.Configs;
import fluke.stygian.world.genlayers.GenLayerEndBiomes;
import fluke.stygian.world.genlayers.GenLayerReduceFrequency;
import fluke.stygian.world.genlayers.GenLayerRemoveSomeOcean;
import net.minecraft.init.Biomes;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerAddIsland;
import net.minecraft.world.gen.layer.GenLayerAddSnow;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class EndGenLayer {
    private long worldGenSeed;
    protected GenLayer parent;
    private long chunkSeed;
    protected long baseSeed;

    public static GenLayer[] initializeAllBiomeGenerators(long seed, WorldType worldType, ChunkGeneratorSettings genSettings) {
        GenLayerAddIsland genlayeraddisland3;
        GenLayerReduceFrequency reduceBiomes;
        GenLayerIsland genlayer = new GenLayerIsland(1L);
        genlayer = new GenLayerFuzzyZoom(2000L, (GenLayer)genlayer);
        GenLayerAddIsland genlayeraddisland = new GenLayerAddIsland(1L, (GenLayer)genlayer);
        GenLayerZoom genlayerzoom = new GenLayerZoom(2001L, (GenLayer)genlayeraddisland);
        GenLayerAddIsland genlayeraddisland1 = new GenLayerAddIsland(2L, (GenLayer)genlayerzoom);
        genlayeraddisland1 = new GenLayerAddIsland(50L, (GenLayer)genlayeraddisland1);
        genlayeraddisland1 = new GenLayerAddIsland(70L, (GenLayer)genlayeraddisland1);
        GenLayerRemoveSomeOcean genlayerremovetoomuchocean = new GenLayerRemoveSomeOcean(2L, (GenLayer)genlayeraddisland1);
        GenLayerAddSnow genlayeraddsnow = new GenLayerAddSnow(2L, (GenLayer)genlayerremovetoomuchocean);
        GenLayerAddIsland genlayeraddisland2 = new GenLayerAddIsland(3L, (GenLayer)genlayeraddsnow);
        GenLayerReduceFrequency genlayeredge = reduceBiomes = new GenLayerReduceFrequency(10L, (GenLayer)genlayeraddisland2);
        GenLayerZoom genlayerzoom1 = new GenLayerZoom(2002L, (GenLayer)genlayeredge);
        genlayerzoom1 = new GenLayerZoom(2003L, (GenLayer)genlayerzoom1);
        GenLayerAddIsland genlayerdeepocean = genlayeraddisland3 = new GenLayerAddIsland(4L, (GenLayer)genlayerzoom1);
        GenLayer genlayer4 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerdeepocean, (int)0);
        int biomeSize = Configs.worldgen.endBiomeSize;
        int riverSize = 4;
        GenLayer genlayerriverinit = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer4, (int)0);
        GenLayerEndBiomes genlayerendbiomes = new GenLayerEndBiomes(200L, genlayer4);
        GenLayer lvt_9_1_ = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
        GenLayer genlayer5 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
        genlayer5 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer5, (int)riverSize);
        GenLayerSmooth genlayersmooth = new GenLayerSmooth(1000L, genlayer5);
        for (int k = 0; k < biomeSize; ++k) {
            genlayerendbiomes = new GenLayerZoom((long)(1000 + k), (GenLayer)genlayerendbiomes);
            if (k != 0) continue;
            genlayerendbiomes = new GenLayerAddIsland(3L, (GenLayer)genlayerendbiomes);
        }
        GenLayerSmooth genlayersmooth1 = new GenLayerSmooth(1000L, (GenLayer)genlayerendbiomes);
        GenLayerVoronoiZoom genlayer3 = new GenLayerVoronoiZoom(10L, (GenLayer)genlayersmooth1);
        genlayersmooth1.func_75905_a(seed);
        genlayer3.func_75905_a(seed);
        return new GenLayer[]{genlayersmooth1, genlayer3, genlayersmooth1};
    }

    public EndGenLayer(long seed) {
        this.baseSeed = seed;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += seed;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += seed;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += seed;
    }

    public void initWorldGenSeed(long seed) {
        this.worldGenSeed = seed;
        if (this.parent != null) {
            this.parent.func_75905_a(seed);
        }
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
    }

    public void initChunkSeed(long xSeed, long zSeed) {
        this.chunkSeed = this.worldGenSeed;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += xSeed;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += zSeed;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += xSeed;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += zSeed;
    }

    protected int nextInt(int max) {
        int i = (int)((this.chunkSeed >> 24) % (long)max);
        if (i < 0) {
            i += max;
        }
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += this.worldGenSeed;
        return i;
    }

    public abstract int[] getInts(int var1, int var2, int var3, int var4);

    protected static boolean biomesEqualOrMesaPlateau(int biomeIDA, int biomeIDB) {
        if (biomeIDA == biomeIDB) {
            return true;
        }
        Biome biome = Biome.func_150568_d((int)biomeIDA);
        Biome biome1 = Biome.func_150568_d((int)biomeIDB);
        if (biome != null && biome1 != null) {
            if (biome != Biomes.field_150607_aa && biome != Biomes.field_150608_ab) {
                return biome == biome1 || biome.func_150562_l() == biome1.func_150562_l();
            }
            return biome1 == Biomes.field_150607_aa || biome1 == Biomes.field_150608_ab;
        }
        return false;
    }

    protected static boolean isBiomeOceanic(int biomeID) {
        return BiomeManager.oceanBiomes.contains(Biome.func_150568_d((int)biomeID));
    }

    protected long nextLong(long par1) {
        long j = (this.chunkSeed >> 24) % par1;
        if (j < 0L) {
            j += par1;
        }
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += this.worldGenSeed;
        return j;
    }

    public static int getModdedBiomeSize(WorldType worldType, int original) {
        WorldTypeEvent.BiomeSize event = new WorldTypeEvent.BiomeSize(worldType, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.getNewSize();
    }

    protected int selectRandom(int ... p_151619_1_) {
        return p_151619_1_[this.nextInt(p_151619_1_.length)];
    }

    protected int selectModeOrRandom(int p_151617_1_, int p_151617_2_, int p_151617_3_, int p_151617_4_) {
        if (p_151617_2_ == p_151617_3_ && p_151617_3_ == p_151617_4_) {
            return p_151617_2_;
        }
        if (p_151617_1_ == p_151617_2_ && p_151617_1_ == p_151617_3_) {
            return p_151617_1_;
        }
        if (p_151617_1_ == p_151617_2_ && p_151617_1_ == p_151617_4_) {
            return p_151617_1_;
        }
        if (p_151617_1_ == p_151617_3_ && p_151617_1_ == p_151617_4_) {
            return p_151617_1_;
        }
        if (p_151617_1_ == p_151617_2_ && p_151617_3_ != p_151617_4_) {
            return p_151617_1_;
        }
        if (p_151617_1_ == p_151617_3_ && p_151617_2_ != p_151617_4_) {
            return p_151617_1_;
        }
        if (p_151617_1_ == p_151617_4_ && p_151617_2_ != p_151617_3_) {
            return p_151617_1_;
        }
        if (p_151617_2_ == p_151617_3_ && p_151617_1_ != p_151617_4_) {
            return p_151617_2_;
        }
        if (p_151617_2_ == p_151617_4_ && p_151617_1_ != p_151617_3_) {
            return p_151617_2_;
        }
        return p_151617_3_ == p_151617_4_ && p_151617_1_ != p_151617_2_ ? p_151617_3_ : this.selectRandom(p_151617_1_, p_151617_2_, p_151617_3_, p_151617_4_);
    }
}

