/*
 * Decompiled with CFR 0.152.
 */
package fluke.stygian.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.util.math.BlockPos;

public class MathUtils {
    public static BlockPos[] getQuadBezierArray(BlockPos start, BlockPos curvePoint, BlockPos end) {
        ArrayList<BlockPos> linePoints = new ArrayList<BlockPos>();
        int x0 = start.func_177958_n();
        int y0 = start.func_177956_o();
        int x1 = curvePoint.func_177958_n();
        int y1 = curvePoint.func_177956_o();
        int x2 = end.func_177958_n();
        int y2 = end.func_177956_o();
        int z = start.func_177952_p();
        int sx = x2 - x1;
        int sy = y2 - y1;
        long xx = x0 - x1;
        long yy = y0 - y1;
        double cur = xx * (long)sy - yy * (long)sx;
        assert (xx * (long)sx >= 0L && yy * (long)sy >= 0L);
        if ((long)sx * (long)sx + (long)sy * (long)sy > xx * xx + yy * yy) {
            x2 = x0;
            x0 = sx + x1;
            y2 = y0;
            y0 = sy + y1;
            cur = -cur;
        }
        if (cur != 0.0) {
            xx += (long)sx;
            sx = x0 < x2 ? 1 : -1;
            yy += (long)sy;
            sy = y0 < y2 ? 1 : -1;
            long xy = 2L * (xx *= (long)sx) * (yy *= (long)sy);
            xx *= xx;
            yy *= yy;
            if (cur * (double)sx * (double)sy < 0.0) {
                xx = -xx;
                yy = -yy;
                xy = -xy;
                cur = -cur;
            }
            double dx = 4.0 * (double)sy * (double)(x1 - x0) * cur + (double)xx - (double)xy;
            double dy = 4.0 * (double)sx * (double)(y0 - y1) * cur + (double)yy - (double)xy;
            xx += xx;
            yy += yy;
            double err = dx + dy + (double)xy;
            do {
                cur = Math.min(dx + (double)xy, (double)(-xy) - dy);
                double ed = Math.max(dx + (double)xy, (double)(-xy) - dy);
                ed = 255.0 / (ed + 2.0 * ed * cur * cur / (4.0 * ed * ed + cur * cur));
                linePoints.add(new BlockPos(x0, y0, z));
                if (x0 == x2 && y0 == y2) {
                    return linePoints.toArray(new BlockPos[0]);
                }
                x1 = x0;
                cur = dx - err;
                int n = y1 = 2.0 * err + dy < 0.0 ? 1 : 0;
                if (2.0 * err + dx > 0.0) {
                    if (err - dy < ed) {
                        linePoints.add(new BlockPos(x0, y0 + sy, z));
                    }
                    x0 += sx;
                    dx -= (double)xy;
                    err += (dy += (double)yy);
                }
                if (y1 == 0) continue;
                if (cur < ed) {
                    linePoints.add(new BlockPos(x1 + sx, y0, z));
                }
                y0 += sy;
                dy -= (double)xy;
                err += (dx += (double)xx);
            } while (dy < dx);
        }
        Collections.addAll(linePoints, MathUtils.getBresehnamArrays(start.func_177982_a(x0, y0, 0), start.func_177982_a(x2, y2, 0)));
        return linePoints.toArray(new BlockPos[0]);
    }

    public static BlockPos[] getBresehnamArrays(BlockPos src, BlockPos dest) {
        return MathUtils.getBresehnamArrays(src.func_177958_n(), src.func_177956_o(), src.func_177952_p(), dest.func_177958_n(), dest.func_177956_o(), dest.func_177952_p());
    }

    public static BlockPos[] getBresehnamArrays(int x1, int y1, int z1, int x2, int y2, int z2) {
        BlockPos[] lineArray;
        BlockPos pixel = new BlockPos(x1, y1, z1);
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int x_inc = dx < 0 ? -1 : 1;
        int absDx = Math.abs(dx);
        int y_inc = dy < 0 ? -1 : 1;
        int absDy = Math.abs(dy);
        int z_inc = dz < 0 ? -1 : 1;
        int absDz = Math.abs(dz);
        int doubleAbsDx = absDx << 1;
        int doubleAbsDy = absDy << 1;
        int doubleAbsDz = absDz << 1;
        if (absDx >= absDy && absDx >= absDz) {
            int err_1 = doubleAbsDy - absDx;
            int err_2 = doubleAbsDz - absDx;
            lineArray = new BlockPos[absDx + 1];
            for (int i = 0; i < absDx; ++i) {
                lineArray[i] = pixel;
                if (err_1 > 0) {
                    pixel = pixel.func_177981_b(y_inc);
                    err_1 -= doubleAbsDx;
                }
                if (err_2 > 0) {
                    pixel = pixel.func_177970_e(z_inc);
                    err_2 -= doubleAbsDx;
                }
                err_1 += doubleAbsDy;
                err_2 += doubleAbsDz;
                pixel = pixel.func_177965_g(x_inc);
            }
        } else if (absDy >= absDx && absDy >= absDz) {
            int err_1 = doubleAbsDx - absDy;
            int err_2 = doubleAbsDz - absDy;
            lineArray = new BlockPos[absDy + 1];
            for (int i = 0; i < absDy; ++i) {
                lineArray[i] = pixel;
                if (err_1 > 0) {
                    pixel = pixel.func_177965_g(x_inc);
                    err_1 -= doubleAbsDy;
                }
                if (err_2 > 0) {
                    pixel = pixel.func_177970_e(z_inc);
                    err_2 -= doubleAbsDy;
                }
                err_1 += doubleAbsDx;
                err_2 += doubleAbsDz;
                pixel = pixel.func_177981_b(y_inc);
            }
        } else {
            int err_1 = doubleAbsDy - absDz;
            int err_2 = doubleAbsDx - absDz;
            lineArray = new BlockPos[absDz + 1];
            for (int i = 0; i < absDz; ++i) {
                lineArray[i] = pixel;
                if (err_1 > 0) {
                    pixel = pixel.func_177981_b(y_inc);
                    err_1 -= doubleAbsDz;
                }
                if (err_2 > 0) {
                    pixel = pixel.func_177965_g(x_inc);
                    err_2 -= doubleAbsDz;
                }
                err_1 += doubleAbsDy;
                err_2 += doubleAbsDx;
                pixel = pixel.func_177970_e(z_inc);
            }
        }
        lineArray[lineArray.length - 1] = pixel;
        return lineArray;
    }

    public static BlockPos getDirectionalPoint(BlockPos startPoint, int degreesToRotate, int distanceFromCenter) {
        double stupidRadians = Math.toRadians(degreesToRotate);
        int xDist = (int)Math.round(Math.cos(stupidRadians) * (double)distanceFromCenter);
        int zDist = (int)Math.round(Math.sin(stupidRadians) * (double)distanceFromCenter);
        BlockPos endPoint = startPoint.func_177982_a(xDist, 0, zDist *= -1);
        return endPoint;
    }

    public static int randIntBetween(int min, int max, Random rand) {
        if (max + 1 - min <= 0) {
            return 0;
        }
        return rand.nextInt(max + 1 - min) + min;
    }
}

