/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.util;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class DirectionUtils {
    public static RayTraceResult rayTrace(World world, EntityLivingBase entity, float distance) {
        Vec3d pos = entity.func_174791_d().func_72441_c(0.0, entity.field_70163_u, 0.0);
        Vec3d dir = entity.func_70040_Z();
        Vec3d lastVec = pos.func_72441_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
        RayTraceResult blockRay = world.func_147447_a(pos, pos.func_72441_c(dir.field_72450_a * (double)distance, dir.field_72448_b * (double)distance, dir.field_72449_c * (double)distance), false, false, true);
        int x = 0;
        while ((float)x < 16.0f * distance) {
            float reach = (float)x * 0.0625f;
            Vec3d vec = pos.func_72441_c(dir.field_72450_a * (double)reach, dir.field_72448_b * (double)reach, dir.field_72449_c * (double)reach);
            if (blockRay == null || blockRay.field_72307_f == null) {
                return new RayTraceResult(dir, null);
            }
            if (blockRay.field_72307_f.func_72438_d(pos) < vec.func_72438_d(pos)) break;
            AxisAlignedBB AABB = new AxisAlignedBB(lastVec.field_72450_a, lastVec.field_72448_b, lastVec.field_72449_c, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            List entities = world.func_72839_b((Entity)entity, AABB);
            if (!entities.isEmpty()) {
                return new RayTraceResult((Entity)entities.get(0), dir);
            }
            lastVec = vec;
            ++x;
        }
        return blockRay;
    }

    @Deprecated
    public static RayTraceResult getPlayerRayTrace(World world, EntityPlayer player, float distance) {
        return DirectionUtils.rayTrace(world, (EntityLivingBase)player, distance);
    }

    public static EnumFacing getFacing(Vec3d vec) {
        return EnumFacing.func_176737_a((float)((float)vec.field_72450_a), (float)((float)vec.field_72448_b), (float)((float)vec.field_72449_c));
    }

    public static EnumFacing getRandomDirectionXZ(Random rand) {
        return DirectionUtils.getXZDirection(rand.nextInt(4));
    }

    public static EnumFacing getXZDirection(int direction) {
        switch (direction) {
            case 1: {
                return EnumFacing.SOUTH;
            }
            case 2: {
                return EnumFacing.EAST;
            }
            case 3: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.NORTH;
    }

    public static int getXZMeta(EnumFacing facing) {
        return facing.func_176745_a() + (facing == EnumFacing.UP || facing == EnumFacing.DOWN ? 4 : -2);
    }

    public static Vec3d getDirectionVecXZ(Vec3i start, Vec3i end) {
        return DirectionUtils.getDirectionVecXZ(DirectionUtils.centerOf(start), DirectionUtils.centerOf(end));
    }

    public static Vec3d getDirectionVecXZ(Vec3d start, Vec3d end) {
        double dx = end.field_72450_a - start.field_72450_a;
        double dz = end.field_72449_c - start.field_72449_c;
        double angle = Math.atan2(dz, dx);
        return DirectionUtils.getDirectionVecXZ(angle);
    }

    public static Vec3d getDirectionVecXZ(Entity start, Entity end) {
        return DirectionUtils.getDirectionVecXZ(start.func_174791_d(), end.func_174791_d());
    }

    public static Vec3d getDirectionVecXZDegrees(double angle) {
        return DirectionUtils.getDirectionVecXZ(Math.toRadians(angle));
    }

    public static Vec3d getDirectionVecXZ(double angle) {
        return new Vec3d(Math.cos(angle), 0.0, Math.sin(angle));
    }

    public static Vec3d getRandomDirectionVecXZ(Random rand) {
        return DirectionUtils.getDirectionVecXZDegrees(rand.nextInt(360));
    }

    public static Vec3d getDirectionVec(Entity start, Entity end) {
        return DirectionUtils.getDirectionVec(start.func_174791_d(), end.func_174791_d());
    }

    public static Vec3d getDirectionVec(Vec3i start, Vec3i end) {
        return DirectionUtils.getDirectionVec(DirectionUtils.centerOf(start), DirectionUtils.centerOf(end));
    }

    public static Vec3d getDirectionVec(Vec3d start, Vec3d end) {
        if (start.equals((Object)end)) {
            return new Vec3d(0.0, 0.0, 0.0);
        }
        double dx = end.field_72450_a - start.field_72450_a;
        double dy = end.field_72448_b - start.field_72448_b;
        double dz = end.field_72449_c - start.field_72449_c;
        double magnitude = Math.sqrt(dx * dx + dy * dy + dz * dz);
        return new Vec3d(dx / magnitude, dy / magnitude, dz / magnitude);
    }

    public static BlockPos getClosestLoadedPos(World world, BlockPos basepos, Vec3d direction, double radius) {
        BlockPos pos = world.func_175672_r(basepos.func_177963_a(direction.field_72450_a * radius, 0.0, direction.field_72449_c * radius));
        while (!world.func_175726_f(pos).func_177410_o()) {
            if (radius == 0.0) {
                return basepos;
            }
            pos = world.func_175672_r(basepos.func_177963_a(direction.field_72450_a * (radius -= 1.0), 0.0, direction.field_72449_c * radius));
        }
        return pos;
    }

    public static BlockPos getClosestLoadedPos(World world, BlockPos basepos, Vec3d direction, double radius, int maxlight, int minlight) {
        BlockPos pos = world.func_175672_r(basepos.func_177963_a(direction.field_72450_a * radius, 0.0, direction.field_72449_c * radius));
        while (!world.func_175726_f(pos).func_177410_o() || !DirectionUtils.isBrightnessAllowed(world, basepos, maxlight, minlight)) {
            if (radius == 0.0) {
                return basepos;
            }
            pos = world.func_175672_r(basepos.func_177963_a(direction.field_72450_a * (radius -= 1.0), 0.0, direction.field_72449_c * radius));
        }
        return pos;
    }

    public static boolean isBrightnessAllowed(World world, BlockPos pos, int maxlight, int minlight) {
        int blocklight = world.func_175671_l(pos);
        if (blocklight > maxlight) {
            return false;
        }
        return blocklight >= minlight;
    }

    public static Vec3d centerOf(Vec3i pos) {
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static void throwItem(EntityLivingBase entity, ItemStack stack, Vec3d target) {
        EntityItem item = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() - 0.3, entity.field_70161_v, stack);
        item.func_145799_b(entity.func_110124_au().toString());
        Vec3d vel = target.func_178786_a(item.field_70165_t, item.field_70163_u, item.field_70161_v).func_72432_b().func_186678_a(0.3);
        item.field_70159_w = vel.field_72450_a;
        item.field_70181_x = vel.field_72448_b;
        item.field_70179_y = vel.field_72449_c;
        item.func_174869_p();
        entity.field_70170_p.func_72838_d((Entity)item);
    }

    public static Vec2f getProjectedPos(Vec3d pos, Vec3d cameraPos, float yaw, float pitch, int screenWidth, int screenHeight, float fov) {
        double scaledFov = Math.tan(Math.toRadians(fov) / 2.0);
        double aspectRatio = (double)screenWidth / (double)screenHeight;
        pos = pos.func_178788_d(cameraPos);
        pos.func_178785_b(-yaw);
        pos.func_178789_a(-pitch);
        return new Vec2f((float)(pos.field_72450_a / (-pos.field_72449_c * scaledFov)) * (float)screenWidth, (float)(pos.field_72448_b * aspectRatio / (-pos.field_72449_c * scaledFov)) * (float)screenHeight);
    }
}

