/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.item;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.smileycorp.atlas.api.item.ToolItemAxe;
import net.smileycorp.atlas.api.item.ToolItemHoe;
import net.smileycorp.atlas.api.item.ToolItemPickaxe;
import net.smileycorp.atlas.api.item.ToolItemSpade;
import net.smileycorp.atlas.api.item.ToolItemSword;
import org.apache.commons.lang3.ArrayUtils;

public class ToolSet {
    final String modid;
    final String name;
    final Item.ToolMaterial material;
    final boolean ignoreOredict;
    Map<ToolType, Item> tools = new HashMap<ToolType, Item>();

    public ToolSet(String modid, String name, Item.ToolMaterial material, CreativeTabs tab) {
        this(modid, name, material, tab, false);
    }

    public ToolSet(String modid, String name, Item.ToolMaterial material, CreativeTabs tab, boolean ignoreOredict) {
        this.name = name;
        this.modid = modid;
        this.material = material;
        for (ToolType type : ToolType.values()) {
            Item item = type.createItem(modid, name, material, tab);
            if (item == null) continue;
            this.tools.put(type, item);
        }
        this.ignoreOredict = ignoreOredict;
    }

    public ToolSet(String modid, String name, Item.ToolMaterial material, CreativeTabs tab, float axedamage, float axespeed) {
        this(modid, name, material, tab, axedamage, axespeed, false);
    }

    public ToolSet(String modid, String name, Item.ToolMaterial material, CreativeTabs tab, float axedamage, float axespeed, boolean ignoreOredict) {
        this.name = name;
        this.modid = modid;
        this.material = material;
        for (ToolType type : ToolType.values()) {
            ToolItemAxe item;
            ToolItemAxe toolItemAxe = item = type == ToolType.AXE ? new ToolItemAxe(modid, name, material, tab, axedamage, axespeed) : type.createItem(modid, name, material, tab);
            if (item == null) continue;
            this.tools.put(type, (Item)item);
        }
        this.ignoreOredict = ignoreOredict;
    }

    public String getModID() {
        return this.modid;
    }

    public String getName() {
        return this.name;
    }

    public Item.ToolMaterial getMaterial() {
        return this.material;
    }

    public Item getItem(ToolType type) {
        return this.tools.get((Object)type);
    }

    public Collection<Item> getItems() {
        return this.tools.values();
    }

    public void registerItems(IForgeRegistry<Item> registry) {
        for (Item tool : this.tools.values()) {
            registry.register((IForgeRegistryEntry)tool);
        }
    }

    public void registerModels() {
        for (Map.Entry<ToolType, Item> tool : this.tools.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)tool.getValue(), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.modid + ":items/" + this.name.toLowerCase() + "_tools", tool.getKey().name()));
        }
    }

    public void registerRecipes() {
        ItemStack stack = this.material.getRepairItemStack();
        int[] ores = this.ignoreOredict ? new int[]{} : OreDictionary.getOreIDs((ItemStack)stack);
        OreIngredient ingredient = ores == null || ores.length == 0 ? Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}) : new OreIngredient(OreDictionary.getOreName((int)ores[0]));
        for (Map.Entry<ToolType, Item> tool : this.tools.entrySet()) {
            tool.getKey().registerRecipe(this.modid, this.name, tool.getValue(), (Ingredient)ingredient);
        }
    }

    public static enum ToolType {
        SWORD("sword", ToolItemSword.class, "M", "M", "S"),
        HOE("hoe", ToolItemHoe.class, "MM", " S", " S"),
        PICKAXE("pickaxe", ToolItemPickaxe.class, "MMM", " S ", " S "),
        AXE("axe", ToolItemAxe.class, "MM", "MS", " S"),
        SPADE("spade", ToolItemSpade.class, "M", "S", "S");

        final String name;
        final Class<? extends Item> clazz;
        final Object[] pattern;

        private ToolType(String name, Class<? extends Item> clazz, Object ... pattern) {
            this.name = name;
            this.clazz = clazz;
            this.pattern = pattern;
        }

        public Item createItem(String modid, String name, Item.ToolMaterial material, CreativeTabs tab) {
            try {
                return (Item)ReflectionHelper.findConstructor(this.clazz, (Class[])new Class[]{String.class, String.class, Item.ToolMaterial.class, CreativeTabs.class}).newInstance(modid, name, material, tab);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }

        public void registerRecipe(String modid, String material, Item item, Ingredient ingredient) {
            Object[] recipe = new Object[]{Character.valueOf('M'), ingredient, Character.valueOf('S'), new OreIngredient("stickWood")};
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(modid, material.toLowerCase() + "_" + this.name), (ResourceLocation)new ResourceLocation(modid, material.toLowerCase() + "_" + this.name), (ItemStack)new ItemStack(item), (Object[])ArrayUtils.addAll((Object[])this.pattern, (Object[])recipe));
        }
    }
}

