/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.data;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.smileycorp.atlas.api.data.DataType;

public class UnaryOperation<T extends Number> {
    private static final Map<String, UnaryOperation> registry = Maps.newHashMap();
    public static final UnaryOperation ABS = UnaryOperation.register("abs", "abs", DataType.DOUBLE, Math::abs);
    public static final UnaryOperation LOG = UnaryOperation.register("log", "ln", DataType.DOUBLE, Math::log);
    public static final UnaryOperation SIN = UnaryOperation.register("sin", "sin", DataType.DOUBLE, Math::sin);
    public static final UnaryOperation COS = UnaryOperation.register("cos", "cos", DataType.DOUBLE, Math::cos);
    public static final UnaryOperation TAN = UnaryOperation.register("tan", "tan", DataType.DOUBLE, Math::tan);
    public static final UnaryOperation ARCSIN = UnaryOperation.register("arcsin", "asin", DataType.DOUBLE, Math::asin);
    public static final UnaryOperation ARCCOS = UnaryOperation.register("arccos", "acos", DataType.DOUBLE, Math::acos);
    public static final UnaryOperation ARCTAN = UnaryOperation.register("arctan", "atan", DataType.DOUBLE, Math::atan);
    public static final UnaryOperation SINH = UnaryOperation.register("sinh", "sinh", DataType.DOUBLE, Math::sinh);
    public static final UnaryOperation COSH = UnaryOperation.register("cosh", "cosh", DataType.DOUBLE, Math::cosh);
    public static final UnaryOperation TANH = UnaryOperation.register("tanh", "tanh", DataType.DOUBLE, Math::tanh);
    public static final UnaryOperation ROUND = UnaryOperation.register("round", "round", DataType.DOUBLE, a -> Math.round(a));
    public static final UnaryOperation FLOOR = UnaryOperation.register("floor", "floor", DataType.DOUBLE, Math::floor);
    public static final UnaryOperation CEILING = UnaryOperation.register("ceiling", "ceil", DataType.DOUBLE, Math::ceil);
    public static final UnaryOperation TRUNCATE = UnaryOperation.register("truncate", "trunc", DataType.DOUBLE, a -> a.intValue());
    public static final UnaryOperation RAND = UnaryOperation.register("random", "rand", DataType.INT, new Random()::nextInt);
    public static final UnaryOperation BITWISE_NOT = UnaryOperation.register("bitwise_not", "!", DataType.INT, a -> ~a.intValue());
    private final String name;
    private final String symbol;
    private final DataType<T> type;
    private final Function<T, T> function;

    private UnaryOperation(String name, String symbol, DataType<T> type, Function<T, T> function) {
        this.name = name;
        this.symbol = symbol;
        this.type = type;
        this.function = function;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public T apply(Comparable a) {
        return (T)((Number)this.function.apply(this.type.cast(a)));
    }

    private static <T extends Number> UnaryOperation register(String name, String symbol, DataType<T> type, Function<T, T> function) {
        UnaryOperation<T> operation = new UnaryOperation<T>(name, symbol, type, function);
        return registry.put(symbol, operation);
    }

    public static UnaryOperation of(String symbol) {
        if (registry.containsKey(symbol)) {
            return registry.get(symbol);
        }
        return null;
    }

    public static Collection<UnaryOperation> values() {
        return registry.values();
    }
}

