/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.data;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.nbt.NBTTagCompound;

public class DataType<T extends Comparable<T>> {
    private static Map<String, DataType<?>> registry = new HashMap();
    public static DataType<Byte> BYTE = new DataType<Byte>("byte", Byte.class, (byte)0, JsonElement::getAsByte, NBTTagCompound::func_74771_c);
    public static DataType<Short> SHORT = new DataType<Short>("short", Short.class, (short)0, JsonElement::getAsShort, NBTTagCompound::func_74765_d);
    public static DataType<Integer> INT = new DataType<Integer>("int", Integer.class, 0, JsonElement::getAsInt, NBTTagCompound::func_74762_e);
    public static DataType<Long> LONG = new DataType<Long>("long", Long.class, 0L, JsonElement::getAsLong, NBTTagCompound::func_74763_f);
    public static DataType<Float> FLOAT = new DataType<Float>("float", Float.class, Float.valueOf(0.0f), JsonElement::getAsFloat, NBTTagCompound::func_74760_g);
    public static DataType<Double> DOUBLE = new DataType<Double>("double", Double.class, 0.0, JsonElement::getAsDouble, NBTTagCompound::func_74769_h);
    public static DataType<String> STRING = new DataType<String>("string", String.class, "", JsonElement::getAsString, (nbt, key) -> nbt.func_74779_i(key));
    public static DataType<Boolean> BOOLEAN = new DataType<Boolean>("boolean", Boolean.class, false, JsonElement::getAsBoolean, NBTTagCompound::func_74767_n);
    private final String name;
    private final Class<T> clazz;
    private final T defaultValue;
    private final Function<JsonElement, T> jsonReader;
    private final BiFunction<NBTTagCompound, String, T> nbtReader;

    private DataType(String name, Class<T> clazz, T defaultValue, Function<JsonElement, T> jsonReader, BiFunction<NBTTagCompound, String, T> nbtReader) {
        this.name = name;
        this.clazz = clazz;
        this.defaultValue = defaultValue;
        this.jsonReader = jsonReader;
        this.nbtReader = nbtReader;
        registry.put(name, this);
    }

    public Class<T> getType() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public Boolean isNumber() {
        return Number.class.isAssignableFrom(this.clazz);
    }

    public T cast(Comparable<?> value) {
        return (T)((Comparable)this.clazz.cast(value));
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T readFromJson(JsonElement element) {
        return (T)((Comparable)this.jsonReader.apply(element));
    }

    public T readFromNBT(NBTTagCompound nbt, String key) {
        return (T)((Comparable)this.nbtReader.apply(nbt, key));
    }

    public static DataType<?> of(String name) {
        if (registry.containsKey(name)) {
            return registry.get(name);
        }
        return null;
    }

    public static DataType<?> of(Class<?> clazz) {
        for (DataType<?> type : registry.values()) {
            if (type.getType() != clazz) continue;
            return type;
        }
        return null;
    }
}

