/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.client;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.smileycorp.atlas.api.client.RenderingUtils;

public class TextureAtlasLayered
extends TextureAtlasSprite {
    protected final TextureAtlasSprite sprite0;
    protected final TextureAtlasSprite sprite1;

    public TextureAtlasLayered(ResourceLocation loc, TextureAtlasSprite sprite0, TextureAtlasSprite sprite1) {
        super(loc.toString());
        this.sprite0 = sprite0;
        this.sprite1 = sprite1;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.builder().addAll((Iterable)super.getDependencies()).build();
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        textureGetter = RenderingUtils.defaultTextureGetter;
        try {
            int[][] data = (int[][])Arrays.stream(this.sprite0.func_147965_a(0)).map(rec$ -> (int[])((int[])rec$).clone()).toArray(x$0 -> new int[x$0][]);
            int[][] overlayData = this.sprite1.func_147965_a(0);
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data[i].length; ++j) {
                    int colour = data[i][j];
                    Color colour2 = new Color(overlayData[i][j], true);
                    int r1 = colour >> 16 & 0xFF;
                    int g1 = colour >> 8 & 0xFF;
                    int b1 = colour & 0xFF;
                    int r2 = colour2.getRed();
                    int g2 = colour2.getBlue();
                    int b2 = colour2.getGreen();
                    float a2 = (float)colour2.getAlpha() / 255.0f;
                    int r = Math.round((float)r1 * (1.0f - a2) + (float)r2 * a2);
                    int g = Math.round((float)g1 * (1.0f - a2) + (float)g2 * a2);
                    int b = Math.round((float)b1 * (1.0f - a2) + (float)b2 * a2);
                    data[i][j] = new Color(r, g, b, 255).getRGB();
                }
            }
            if (this.field_110976_a.size() < 1) {
                this.field_110976_a.add(data);
            } else {
                this.field_110976_a.set(0, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static int[] scaleToSmaller(int[] data, int width, int min) {
        if (width == min) {
            return data;
        }
        int scale = width / min;
        int[] output = new int[min * min];
        int j = 0;
        for (int i = 0; i < output.length; ++i) {
            if (i % min == 0) {
                j += width;
            }
            output[i] = data[i * scale + j];
        }
        return output;
    }
}

