/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block.wood;

import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.gen.feature.WorldGenerator;

public interface WoodEnum
extends IStringSerializable {
    @Nullable
    public Function<Random, WorldGenerator> getTree();

    @Nullable
    public Function<Random, WorldGenerator> getLargeTree();

    default public boolean hasTree() {
        return this.getTree() != null;
    }

    default public boolean hasLargeTree() {
        return this.getLargeTree() != null;
    }

    default public boolean hasSapling() {
        return this.hasTree() || this.hasLargeTree();
    }

    public MapColor plankColour();

    public MapColor logColour();

    public MapColor leavesColour();

    default public boolean isFlammable() {
        return true;
    }

    default public SoundType getSoundType() {
        return SoundType.field_185848_a;
    }

    default public SoundType getLeavesSoundType() {
        return SoundType.field_185850_c;
    }

    default public float getHardness() {
        return 2.0f;
    }

    default public float getResistance() {
        return 5.0f;
    }

    public float saplingDropChance();

    default public boolean solidLeaves() {
        return false;
    }

    public Map<ItemStack, Float> getLeafDrops();
}

