/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block.wood;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.smileycorp.atlas.api.block.BlockStairsBase;
import net.smileycorp.atlas.api.block.wood.BlockBaseLeaves;
import net.smileycorp.atlas.api.block.wood.BlockBaseLog;
import net.smileycorp.atlas.api.block.wood.BlockBasePlank;
import net.smileycorp.atlas.api.block.wood.BlockBaseSapling;
import net.smileycorp.atlas.api.block.wood.BlockWoodDoor;
import net.smileycorp.atlas.api.block.wood.BlockWoodFence;
import net.smileycorp.atlas.api.block.wood.BlockWoodFenceGate;
import net.smileycorp.atlas.api.block.wood.BlockWoodSlab;
import net.smileycorp.atlas.api.block.wood.BlockWoodTrapdoor;
import net.smileycorp.atlas.api.block.wood.WoodEnum;
import net.smileycorp.atlas.api.client.WoodStateMapper;
import net.smileycorp.atlas.api.item.IMetaItem;
import net.smileycorp.atlas.api.item.ItemBlockMeta;
import net.smileycorp.atlas.api.item.ItemSlabMeta;

public class WoodBlock<T extends Enum<T>> {
    private final String modid;
    private final T[] types;
    private final List<BlockBasePlank<T>> planks = Lists.newArrayList();
    private final List<BlockBaseLog<T>> logs = Lists.newArrayList();
    private final List<BlockBaseLeaves<T>> leaves = Lists.newArrayList();
    private final List<BlockBaseSapling<T>> saplings = Lists.newArrayList();
    private final List<Tuple<BlockWoodSlab<T>, BlockWoodSlab<T>>> slabs = Lists.newArrayList();
    private final List<BlockStairsBase> stairs = Lists.newArrayList();
    private final List<BlockWoodDoor<T>> doors = Lists.newArrayList();
    private final List<BlockWoodTrapdoor<T>> trapdoors = Lists.newArrayList();
    private final List<BlockWoodFence<T>> fences = Lists.newArrayList();
    private final List<BlockWoodFenceGate<T>> gates = Lists.newArrayList();

    public WoodBlock(String modid, CreativeTabs tab, Class<T> types) {
        this(modid, tab, types, false);
    }

    public WoodBlock(String modid, CreativeTabs tab, Class<T> types, boolean forceSimpleNames) {
        int i;
        this.modid = modid;
        this.types = (Enum[])types.getEnumConstants();
        int size = this.types.length;
        for (i = 0; i <= (size - 1) / 16; ++i) {
            this.planks.add(BlockBasePlank.create("plank_" + (forceSimpleNames || size - 2 > i * 16 ? Integer.valueOf(i) : ((IStringSerializable)this.types[i * 16]).func_176610_l()), modid, tab, types, i));
        }
        for (i = 0; i <= (size - 1) / 8; ++i) {
            this.slabs.add(BlockWoodSlab.create("slab_" + (forceSimpleNames || size - 2 > i * 8 ? String.valueOf(i) : ((IStringSerializable)this.types[i * 8]).func_176610_l()), modid, tab, types, i));
        }
        for (i = 0; i <= (size - 1) / 4; ++i) {
            String name = forceSimpleNames || size - 2 > i * 4 ? String.valueOf(i) : ((IStringSerializable)this.types[i * 4]).func_176610_l();
            this.logs.add(BlockBaseLog.create("log_" + name, modid, tab, types, i));
            BlockBaseSapling<T> sapling = BlockBaseSapling.create("sapling_" + name, modid, tab, types, i);
            this.leaves.add(BlockBaseLeaves.create("leaves_" + name, modid, tab, sapling, types, i));
            this.saplings.add(sapling);
        }
        for (T type : this.types) {
            this.stairs.add(new BlockStairsBase(((IStringSerializable)type).func_176610_l(), this.getPlankState(type)));
            this.doors.add(new BlockWoodDoor<T>(modid, type, tab));
            this.trapdoors.add(new BlockWoodTrapdoor<T>(modid, type, tab));
            this.fences.add(new BlockWoodFence<T>(modid, type, tab));
            this.gates.add(new BlockWoodFenceGate<T>(modid, type, tab));
        }
    }

    public ItemStack getPlankStack(T type, int amount) {
        return new ItemStack((Block)this.planks.get(((Enum)type).ordinal() / 16), amount, ((Enum)type).ordinal() % 16);
    }

    public IBlockState getPlankState(T type) {
        BlockBasePlank<T> plank = this.planks.get(((Enum)type).ordinal() / 16);
        return plank.func_176223_P().func_177226_a(plank.getVariantProperty(), type);
    }

    public ItemStack getLogStack(T type, int amount) {
        return new ItemStack((Block)this.logs.get(((Enum)type).ordinal() / 4), amount, ((Enum)type).ordinal() % 4);
    }

    public ItemStack getWoodStack(T type, int amount) {
        return new ItemStack((Block)this.logs.get(((Enum)type).ordinal() / 4), amount, ((Enum)type).ordinal() % 4 + 12);
    }

    public IBlockState getLogState(T type, BlockLog.EnumAxis axis) {
        BlockBaseLog<T> log = this.logs.get(((Enum)type).ordinal() / 4);
        return log.func_176223_P().func_177226_a(log.getVariantProperty(), type).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis);
    }

    public ItemStack getLeavesStack(T type, int amount) {
        return new ItemStack((Block)this.leaves.get(((Enum)type).ordinal() / 4), amount, ((Enum)type).ordinal() % 4);
    }

    public IBlockState getLeavesState(T type) {
        return this.getLeavesState(type, true, true);
    }

    public IBlockState getLeavesState(T type, boolean decayable, boolean check_decay) {
        BlockBaseLeaves<T> leaf = this.leaves.get(((Enum)type).ordinal() / 4);
        return leaf.func_176223_P().func_177226_a(leaf.getVariantProperty(), type).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(decayable)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(check_decay));
    }

    public ItemStack getSaplingStack(T type, int amount) {
        BlockBaseSapling<T> sapling = this.saplings.get(((Enum)type).ordinal() / 4);
        return sapling == null | !((WoodEnum)type).hasSapling() ? ItemStack.field_190927_a : new ItemStack(sapling, amount, ((Enum)type).ordinal() % 4);
    }

    public IBlockState getSaplingState(T type) {
        return this.getSaplingState(type, 0);
    }

    public IBlockState getSaplingState(T type, int stage) {
        BlockBaseSapling<T> sapling = this.saplings.get(((Enum)type).ordinal() / 4);
        return sapling == null | !((WoodEnum)type).hasSapling() ? Blocks.field_150350_a.func_176223_P() : sapling.func_176223_P().func_177226_a(sapling.getVariantProperty(), type).func_177226_a((IProperty)BlockSapling.field_176479_b, (Comparable)Integer.valueOf(stage % 4));
    }

    public ItemStack getSlabStack(T type, int amount) {
        return new ItemStack((Block)this.slabs.get(((Enum)type).ordinal() / 8).func_76341_a(), amount, ((Enum)type).ordinal() % 8);
    }

    public IBlockState getSlabState(T type, BlockSlab.EnumBlockHalf half) {
        BlockWoodSlab slab = (BlockWoodSlab)this.slabs.get(((Enum)type).ordinal() / 8).func_76341_a();
        return slab.func_176223_P().func_177226_a(slab.getVariantProperty(), type).func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)half);
    }

    public IBlockState getDoubleSlabState(T type) {
        BlockWoodSlab slab = (BlockWoodSlab)this.slabs.get(((Enum)type).ordinal() / 8).func_76340_b();
        return slab.func_176223_P().func_177226_a(slab.getVariantProperty(), type);
    }

    public ItemStack getStairStack(T type, int amount) {
        return new ItemStack((Block)this.stairs.get(((Enum)type).ordinal()), amount);
    }

    public IBlockState getStairState(T type, BlockStairs.EnumHalf half, BlockStairs.EnumShape shape, EnumFacing facing) {
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.stairs.get(((Enum)type).ordinal()).func_176223_P().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)half).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)shape).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)facing);
    }

    public BlockWoodDoor<T> getDoor(T type) {
        return this.doors.get(((Enum)type).ordinal());
    }

    public ItemStack getDoorStack(T type, int amount) {
        return new ItemStack(this.doors.get(((Enum)type).ordinal()).func_176509_j(), amount);
    }

    public BlockWoodTrapdoor<T> getTrapdoor(T type) {
        return this.trapdoors.get(((Enum)type).ordinal());
    }

    public ItemStack getTrapDoorStack(T type, int amount) {
        return new ItemStack((Block)this.trapdoors.get(((Enum)type).ordinal()), amount);
    }

    public BlockWoodFence<T> getFence(T type) {
        return this.fences.get(((Enum)type).ordinal());
    }

    public ItemStack getFenceStack(T type, int amount) {
        return new ItemStack((Block)this.fences.get(((Enum)type).ordinal()), amount);
    }

    public BlockWoodFenceGate<T> getFenceGate(T type) {
        return this.gates.get(((Enum)type).ordinal());
    }

    public ItemStack getFenceGateStack(T type, int amount) {
        return new ItemStack((Block)this.gates.get(((Enum)type).ordinal()), amount);
    }

    public void registerBlocks(IForgeRegistry<Block> registry) {
        this.planks.forEach(arg_0 -> registry.register(arg_0));
        this.logs.forEach(arg_0 -> registry.register(arg_0));
        this.leaves.forEach(arg_0 -> registry.register(arg_0));
        for (BlockBaseSapling<T> blockBaseSapling : this.saplings) {
            if (blockBaseSapling == null) continue;
            registry.register(blockBaseSapling);
        }
        for (Tuple tuple : this.slabs) {
            registry.register((IForgeRegistryEntry)tuple.func_76341_a());
            registry.register((IForgeRegistryEntry)tuple.func_76340_b());
        }
        this.stairs.forEach(arg_0 -> registry.register(arg_0));
        this.doors.forEach(arg_0 -> registry.register(arg_0));
        this.trapdoors.forEach(arg_0 -> registry.register(arg_0));
        this.fences.forEach(arg_0 -> registry.register(arg_0));
        this.gates.forEach(arg_0 -> registry.register(arg_0));
    }

    public void registerItems(IForgeRegistry<Item> registry) {
        ItemBlock item;
        for (BlockBasePlank<T> blockBasePlank : this.planks) {
            registry.register((IForgeRegistryEntry)new ItemBlockMeta(blockBasePlank));
        }
        for (BlockBaseLog blockBaseLog : this.logs) {
            registry.register((IForgeRegistryEntry)new ItemBlockMeta((Block)blockBaseLog));
        }
        for (BlockBaseLeaves blockBaseLeaves : this.leaves) {
            registry.register((IForgeRegistryEntry)new ItemBlockMeta((Block)blockBaseLeaves));
        }
        for (BlockBaseSapling blockBaseSapling : this.saplings) {
            if (blockBaseSapling == null) continue;
            registry.register((IForgeRegistryEntry)new ItemBlockMeta((Block)blockBaseSapling));
        }
        for (Tuple tuple : this.slabs) {
            registry.register((IForgeRegistryEntry)new ItemSlabMeta((BlockSlab)tuple.func_76341_a(), (BlockSlab)tuple.func_76340_b()));
        }
        for (BlockStairsBase blockStairsBase : this.stairs) {
            item = new ItemBlock((Block)blockStairsBase);
            item.setRegistryName(blockStairsBase.getRegistryName());
            item.func_77655_b(blockStairsBase.func_149739_a());
            registry.register((IForgeRegistryEntry)item);
        }
        for (BlockWoodDoor blockWoodDoor : this.doors) {
            registry.register((IForgeRegistryEntry)blockWoodDoor.func_176509_j());
        }
        for (BlockWoodTrapdoor blockWoodTrapdoor : this.trapdoors) {
            item = new ItemBlock((Block)blockWoodTrapdoor);
            item.setRegistryName(blockWoodTrapdoor.getRegistryName());
            item.func_77655_b(blockWoodTrapdoor.func_149739_a());
            registry.register((IForgeRegistryEntry)item);
        }
        for (BlockWoodFence blockWoodFence : this.fences) {
            item = new ItemBlock((Block)blockWoodFence);
            item.setRegistryName(blockWoodFence.getRegistryName());
            item.func_77655_b(blockWoodFence.func_149739_a());
            registry.register((IForgeRegistryEntry)item);
        }
        for (BlockWoodFenceGate blockWoodFenceGate : this.gates) {
            item = new ItemBlock((Block)blockWoodFenceGate);
            item.setRegistryName(blockWoodFenceGate.getRegistryName());
            item.func_77655_b(blockWoodFenceGate.func_149739_a());
            registry.register((IForgeRegistryEntry)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (BlockBasePlank<T> blockBasePlank : this.planks) {
            ModelLoader.setCustomStateMapper(blockBasePlank, new WoodStateMapper<T>(blockBasePlank));
            this.registerModel(blockBasePlank);
        }
        for (BlockBaseLog blockBaseLog : this.logs) {
            ModelLoader.setCustomStateMapper((Block)blockBaseLog, new WoodStateMapper(blockBaseLog));
            Item item = Item.func_150898_a((Block)blockBaseLog);
            this.registerModel(item);
            for (int i = 12; i < blockBaseLog.getMaxMeta() + 12; ++i) {
                ModelResourceLocation loc = new ModelResourceLocation(this.modid + ":" + ((IMetaItem)item).byMeta(i));
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)loc);
            }
        }
        for (BlockBaseLeaves blockBaseLeaves : this.leaves) {
            ModelLoader.setCustomStateMapper((Block)blockBaseLeaves, new WoodStateMapper(blockBaseLeaves));
            this.registerModel((Block)blockBaseLeaves);
        }
        for (BlockBaseSapling blockBaseSapling : this.saplings) {
            if (blockBaseSapling == null) continue;
            ModelLoader.setCustomStateMapper((Block)blockBaseSapling, new WoodStateMapper(blockBaseSapling));
            this.registerModel((Block)blockBaseSapling);
        }
        for (Tuple tuple : this.slabs) {
            BlockWoodSlab single = (BlockWoodSlab)tuple.func_76341_a();
            ModelLoader.setCustomStateMapper((Block)single, new WoodStateMapper(single));
            ModelLoader.setCustomStateMapper((Block)((Block)tuple.func_76340_b()), new WoodStateMapper(single));
            this.registerModel((Block)single);
        }
        for (BlockStairsBase blockStairsBase : this.stairs) {
            this.registerModel((Block)blockStairsBase);
        }
        for (BlockWoodDoor blockWoodDoor : this.doors) {
            ModelLoader.setCustomStateMapper((Block)blockWoodDoor, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
            this.registerModel(blockWoodDoor.func_176509_j());
        }
        this.trapdoors.forEach(this::registerModel);
        this.fences.forEach(this::registerModel);
        for (BlockWoodFenceGate blockWoodFenceGate : this.gates) {
            ModelLoader.setCustomStateMapper((Block)blockWoodFenceGate, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
            this.registerModel((Block)blockWoodFenceGate);
        }
        this.gates.forEach(this::registerModel);
    }

    @SideOnly(value=Side.CLIENT)
    private void registerModel(Block block) {
        this.registerModel(Item.func_150898_a((Block)block));
    }

    @SideOnly(value=Side.CLIENT)
    private void registerModel(Item item) {
        if (item instanceof IMetaItem) {
            for (int i = 0; i < ((IMetaItem)item).getMaxMeta(); ++i) {
                ModelResourceLocation loc = new ModelResourceLocation(this.modid + ":" + ((IMetaItem)item).byMeta(i), "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)loc);
            }
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    public void registerRecipes() {
        for (BlockBasePlank<T> blockBasePlank : this.planks) {
            OreDictionary.registerOre((String)"plankWood", blockBasePlank);
        }
        for (BlockBaseLog blockBaseLog : this.logs) {
            OreDictionary.registerOre((String)"logWood", (Block)blockBaseLog);
            GameRegistry.addSmelting((Block)blockBaseLog, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        }
        for (BlockBaseLeaves blockBaseLeaves : this.leaves) {
            OreDictionary.registerOre((String)"treeLeaves", (Block)blockBaseLeaves);
        }
        for (BlockBaseSapling blockBaseSapling : this.saplings) {
            OreDictionary.registerOre((String)"treeSapling", (Block)blockBaseSapling);
        }
        for (Tuple tuple : this.slabs) {
            OreDictionary.registerOre((String)"slabWood", (Block)((Block)tuple.func_76341_a()));
        }
        for (BlockStairsBase blockStairsBase : this.stairs) {
            OreDictionary.registerOre((String)"stairWood", (Block)blockStairsBase);
        }
        for (Iterator<Object> type : this.types) {
            String name = ((IStringSerializable)type).func_176610_l();
            GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation(this.modid, name + "_plank"), (ResourceLocation)new ResourceLocation(this.modid, name), (ItemStack)this.getPlankStack(type, 4), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.getLogStack(type, 1)})});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(this.modid, name + "_wood"), (ResourceLocation)new ResourceLocation(this.modid, name), (ItemStack)this.getWoodStack(type, 3), (Object[])new Object[]{"  #", " ##", "###", Character.valueOf('#'), this.getLogStack(type, 1)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(this.modid, name + "_slab"), (ResourceLocation)new ResourceLocation(this.modid, name), (ItemStack)this.getSlabStack(type, 6), (Object[])new Object[]{"###", Character.valueOf('#'), this.getPlankStack(type, 1)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(this.modid, name + "_stair"), (ResourceLocation)new ResourceLocation(this.modid, name), (ItemStack)this.getStairStack(type, 4), (Object[])new Object[]{"  #", " ##", "###", Character.valueOf('#'), this.getPlankStack(type, 1)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(this.modid, name + "_door"), (ResourceLocation)new ResourceLocation(this.modid, name), (ItemStack)this.getDoorStack(type, 3), (Object[])new Object[]{"##", "##", "##", Character.valueOf('#'), this.getPlankStack(type, 1)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(this.modid, name + "_trapdoor"), (ResourceLocation)new ResourceLocation(this.modid, name), (ItemStack)this.getTrapDoorStack(type, 2), (Object[])new Object[]{"###", "###", Character.valueOf('#'), this.getPlankStack(type, 1)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(this.modid, name + "_fence"), (ResourceLocation)new ResourceLocation(this.modid, name), (ItemStack)this.getFenceStack(type, 3), (Object[])new Object[]{"#S#", "#S#", Character.valueOf('#'), this.getPlankStack(type, 1), Character.valueOf('S'), "stickWood"});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(this.modid, name + "_fence_gate"), (ResourceLocation)new ResourceLocation(this.modid, name), (ItemStack)this.getFenceGateStack(type, 1), (Object[])new Object[]{"S#S", "S#S", Character.valueOf('#'), this.getPlankStack(type, 1), Character.valueOf('S'), "stickWood"});
        }
    }
}

