/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block.wood;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.smileycorp.atlas.api.block.wood.WoodEnum;
import net.smileycorp.atlas.api.block.wood.WoodVariant;

public class BlockBaseSapling<T extends Enum<T>>
extends BlockBush
implements WoodVariant<T>,
IGrowable {
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
    private static PropertyEnum staticProp;
    private final Class<T> types;
    private final int ordinal;
    private PropertyEnum<T> type;

    private BlockBaseSapling(String name, String modid, CreativeTabs tab, Class<T> types, int ordinal) {
        this.types = types;
        this.ordinal = ordinal;
        this.setRegistryName(new ResourceLocation(modid, name));
        this.func_149663_c(modid + "." + name);
        this.func_149647_a(tab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(this.type, (Comparable)((Object)((Enum[])types.getEnumConstants())[ordinal * 4])));
    }

    protected BlockStateContainer func_180661_e() {
        this.type = staticProp;
        return new BlockStateContainer((Block)this, new IProperty[]{this.type, BlockSapling.field_176479_b});
    }

    public int func_176201_c(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b(this.type))).ordinal() % 4 + (Integer)state.func_177229_b((IProperty)BlockSapling.field_176479_b) * 4;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.type, (Comparable)((Object)((Enum[])this.types.getEnumConstants())[this.ordinal * 4 + meta % 4])).func_177226_a((IProperty)BlockSapling.field_176479_b, (Comparable)Integer.valueOf(meta / 4));
    }

    @Override
    public int getMaxMeta() {
        return this.type.func_177700_c().size();
    }

    @Override
    public String byMeta(int meta) {
        return this.byState(this.func_176203_a(meta));
    }

    @Override
    public String byState(IBlockState state) {
        return ((IStringSerializable)((Enum)((Object)state.func_177229_b(this.type)))).func_176610_l() + "_sapling";
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(this.type, (Comparable)((Object)((Enum[])this.types.getEnumConstants())[this.ordinal * 4 + placer.func_184586_b(hand).func_77960_j() % 4]));
    }

    public int func_180651_a(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b(this.type))).ordinal() % 4;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, ((Enum)((Object)state.func_177229_b(this.type))).ordinal() % 4);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return ((WoodEnum)((Object)((Enum)((Object)state.func_177229_b(this.type))))).getLeavesSoundType();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < this.type.func_177700_c().size(); ++i) {
            if (!((WoodEnum)((Object)((Enum[])this.types.getEnumConstants())[this.ordinal * 4 + i])).hasSapling()) continue;
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        super.func_180650_b(world, pos, state, rand);
        if (!world.func_175697_a(pos, 1)) {
            return;
        }
        if (world.func_175671_l(pos.func_177984_a()) < 9 || rand.nextInt(7) > 0) {
            return;
        }
        this.grow(world, pos, state, rand);
    }

    public void grow(World world, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)BlockSapling.field_176479_b) == 0) {
            world.func_180501_a(pos, state.func_177231_a((IProperty)BlockSapling.field_176479_b), 4);
        } else {
            this.generateTree(world, pos, state, rand);
        }
    }

    public void generateTree(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos)) {
            return;
        }
        Enum type = (Enum)((Object)state.func_177229_b(this.type));
        if (((WoodEnum)((Object)type)).hasLargeTree()) {
            if (this.generateLargeTree(world, pos, state, rand, type)) {
                return;
            }
            if (!((WoodEnum)((Object)type)).hasTree()) {
                return;
            }
        }
        WorldGenerator worldgenerator = ((WoodEnum)((Object)type)).getTree().apply(rand);
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        world.func_180501_a(pos, air, 4);
        world.func_175698_g(pos);
        if (!worldgenerator.func_180709_b(world, rand, pos)) {
            world.func_180501_a(pos, state, 4);
        }
    }

    private boolean generateLargeTree(World world, BlockPos pos, IBlockState state, Random rand, T type) {
        for (int i = 0; i >= -1; --i) {
            for (int j = 0; j >= -1; --j) {
                if (!this.isTwoByTwoOfType(world, pos, i, j, type)) continue;
                WorldGenerator worldgenerator = ((WoodEnum)type).getLargeTree().apply(rand);
                IBlockState air = Blocks.field_150350_a.func_176223_P();
                world.func_180501_a(pos.func_177982_a(i, 0, j), air, 4);
                world.func_180501_a(pos.func_177982_a(i + 1, 0, j), air, 4);
                world.func_180501_a(pos.func_177982_a(i, 0, j + 1), air, 4);
                world.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), air, 4);
                if (!worldgenerator.func_180709_b(world, rand, pos)) {
                    world.func_180501_a(pos.func_177982_a(i, 0, j), state, 4);
                    world.func_180501_a(pos.func_177982_a(i + 1, 0, j), state, 4);
                    world.func_180501_a(pos.func_177982_a(i, 0, j + 1), state, 4);
                    world.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), state, 4);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isTwoByTwoOfType(World world, BlockPos pos, int i, int j, T type) {
        return this.isTypeAt(world, pos.func_177982_a(i, 0, j), type) && this.isTypeAt(world, pos.func_177982_a(i + 1, 0, j), type) && this.isTypeAt(world, pos.func_177982_a(i, 0, j + 1), type) && this.isTypeAt(world, pos.func_177982_a(i + 1, 0, j + 1), type);
    }

    public boolean isTypeAt(World world, BlockPos pos, T type) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this && state.func_177229_b(this.type) == type;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return (double)world.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.grow(world, pos, state, rand);
    }

    @Override
    public PropertyEnum<T> getVariantProperty() {
        return this.type;
    }

    @Nullable
    public static <T extends Enum<T>> BlockBaseSapling<T> create(String name, String modid, CreativeTabs tab, Class<T> clazz, int ordinal) {
        HashSet types = Sets.newHashSet();
        boolean hasTree = false;
        for (int i = ordinal * 4; i < (ordinal + 1) * 4 && i < ((Enum[])clazz.getEnumConstants()).length; ++i) {
            Enum type = ((Enum[])clazz.getEnumConstants())[i];
            types.add(type);
            if (!((WoodEnum)((Object)type)).hasSapling()) continue;
            hasTree = true;
        }
        staticProp = PropertyEnum.func_177707_a((String)"type", clazz, (Collection)types);
        return hasTree ? new BlockBaseSapling<T>(name, modid, tab, clazz, ordinal) : null;
    }
}

