/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block.wood;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.smileycorp.atlas.api.block.wood.WoodEnum;
import net.smileycorp.atlas.api.block.wood.WoodVariant;

public class BlockBasePlank<T extends Enum<T>>
extends Block
implements WoodVariant<T> {
    private static PropertyEnum staticProp;
    private final Class<T> types;
    private final int ordinal;
    private PropertyEnum<T> type;

    private BlockBasePlank(String name, String modid, CreativeTabs tab, Class<T> types, int ordinal) {
        super(Material.field_151575_d);
        this.types = types;
        this.ordinal = ordinal;
        this.setRegistryName(new ResourceLocation(modid, name));
        this.func_149663_c(modid + "." + name);
        this.func_149647_a(tab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(this.type, (Comparable)((Object)((Enum[])types.getEnumConstants())[ordinal * 16])));
    }

    protected BlockStateContainer func_180661_e() {
        this.type = staticProp;
        return new BlockStateContainer((Block)this, new IProperty[]{this.type});
    }

    public int func_176201_c(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b(this.type))).ordinal() % 16;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.type, (Comparable)((Object)((Enum[])this.types.getEnumConstants())[this.ordinal * 16 + meta]));
    }

    @Override
    public int getMaxMeta() {
        return this.type.func_177700_c().size();
    }

    @Override
    public String byMeta(int meta) {
        return this.byState(this.func_176203_a(meta));
    }

    @Override
    public String byState(IBlockState state) {
        return ((IStringSerializable)((Enum)((Object)state.func_177229_b(this.type)))).func_176610_l() + "_planks";
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(this.type, (Comparable)((Object)((Enum[])this.types.getEnumConstants())[this.ordinal * 16 + placer.func_184586_b(hand).func_77960_j() % 16]));
    }

    public int func_180651_a(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b(this.type))).ordinal() % 16;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, ((Enum)((Object)state.func_177229_b(this.type))).ordinal() % 16);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((WoodEnum)((Object)((Enum)((Object)state.func_177229_b(this.type))))).plankColour();
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return ((WoodEnum)((Object)((Enum)((Object)world.func_180495_p(pos).func_177229_b(this.type))))).isFlammable();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.isFlammable(world, pos, facing) ? 20 : super.getFlammability(world, pos, facing);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.isFlammable(world, pos, facing) ? 5 : super.getFireSpreadSpeed(world, pos, facing);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return ((WoodEnum)((Object)((Enum)((Object)state.func_177229_b(this.type))))).getSoundType();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return ((WoodEnum)((Object)((Enum)((Object)state.func_177229_b(this.type))))).getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return ((WoodEnum)((Object)((Enum)((Object)world.func_180495_p(pos).func_177229_b(this.type))))).getResistance() / 5.0f;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < this.type.func_177700_c().size(); ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public PropertyEnum<T> getVariantProperty() {
        return this.type;
    }

    public static <T extends Enum<T>> BlockBasePlank<T> create(String name, String modid, CreativeTabs tab, Class<T> clazz, int ordinal) {
        HashSet types = Sets.newHashSet();
        for (int i = ordinal * 16; i < (ordinal + 1) * 16 && i < ((Enum[])clazz.getEnumConstants()).length; ++i) {
            types.add(((Enum[])clazz.getEnumConstants())[i]);
        }
        staticProp = PropertyEnum.func_177707_a((String)"type", clazz, (Collection)types);
        return new BlockBasePlank<T>(name, modid, tab, clazz, ordinal);
    }
}

