/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block.wood;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.smileycorp.atlas.api.block.wood.WoodEnum;
import net.smileycorp.atlas.api.block.wood.WoodVariant;

public class BlockBaseLog<T extends Enum<T>>
extends BlockLog
implements WoodVariant<T> {
    private static PropertyEnum staticProp;
    private final Class<T> types;
    private final int ordinal;
    private PropertyEnum<T> type;

    private BlockBaseLog(String name, String modid, CreativeTabs tab, Class<T> types, int ordinal) {
        this.types = types;
        this.ordinal = ordinal;
        this.setRegistryName(new ResourceLocation(modid, name));
        this.func_149663_c(modid + "." + name);
        this.func_149647_a(tab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(this.type, (Comparable)((Object)((Enum[])types.getEnumConstants())[ordinal * 4])));
    }

    protected BlockStateContainer func_180661_e() {
        this.type = staticProp;
        return new BlockStateContainer((Block)this, new IProperty[]{this.type, field_176299_a});
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((Enum)((Object)state.func_177229_b(this.type))).ordinal() % 4;
        switch ((BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a)) {
            case X: {
                return 4 + meta;
            }
            case Y: {
                return meta;
            }
            case Z: {
                return 8 + meta;
            }
        }
        return 12 + meta;
    }

    public IBlockState func_176203_a(int meta) {
        BlockLog.EnumAxis axis = BlockLog.EnumAxis.NONE;
        if (meta < 4) {
            axis = BlockLog.EnumAxis.Y;
        } else if (meta < 8) {
            axis = BlockLog.EnumAxis.X;
        } else if (meta < 12) {
            axis = BlockLog.EnumAxis.Z;
        }
        return this.func_176223_P().func_177226_a(this.type, (Comparable)((Object)((Enum[])this.types.getEnumConstants())[this.ordinal * 4 + meta % 4])).func_177226_a((IProperty)field_176299_a, (Comparable)axis);
    }

    @Override
    public int getMaxMeta() {
        return this.type.func_177700_c().size();
    }

    @Override
    public String byMeta(int meta) {
        return this.byState(this.func_176203_a(meta));
    }

    @Override
    public String byState(IBlockState state) {
        String name = ((IStringSerializable)((Enum)((Object)state.func_177229_b(this.type)))).func_176610_l();
        return name + (state.func_177229_b((IProperty)field_176299_a) == BlockLog.EnumAxis.NONE ? (name.contains("wood") ? "" : "_wood") : "_log");
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        ItemStack stack = placer.func_184586_b(hand);
        return (stack.func_77960_j() < 12 ? super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand) : this.func_176223_P().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.NONE)).func_177226_a(this.type, (Comparable)((Object)((Enum[])this.types.getEnumConstants())[this.ordinal * 4 + stack.func_77960_j() % 4]));
    }

    public int func_180651_a(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b(this.type))).ordinal() % 4;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state) % 4);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((WoodEnum)((Object)((Enum)((Object)state.func_177229_b(this.type))))).logColour();
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return ((WoodEnum)((Object)((Enum)((Object)world.func_180495_p(pos).func_177229_b(this.type))))).isFlammable();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.isFlammable(world, pos, facing) ? 20 : super.getFlammability(world, pos, facing);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.isFlammable(world, pos, facing) ? 5 : super.getFireSpreadSpeed(world, pos, facing);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return ((WoodEnum)((Object)((Enum)((Object)state.func_177229_b(this.type))))).getSoundType();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return ((WoodEnum)((Object)((Enum)((Object)state.func_177229_b(this.type))))).getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return ((WoodEnum)((Object)((Enum)((Object)world.func_180495_p(pos).func_177229_b(this.type))))).getResistance() / 5.0f;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < this.type.func_177700_c().size(); ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
            items.add((Object)new ItemStack((Block)this, 1, i + 12));
        }
    }

    @Override
    public PropertyEnum<T> getVariantProperty() {
        return this.type;
    }

    public static <T extends Enum<T>> BlockBaseLog<T> create(String name, String modid, CreativeTabs tab, Class<T> clazz, int ordinal) {
        HashSet types = Sets.newHashSet();
        for (int i = ordinal * 4; i < (ordinal + 1) * 4 && i < ((Enum[])clazz.getEnumConstants()).length; ++i) {
            types.add(((Enum[])clazz.getEnumConstants())[i]);
        }
        staticProp = PropertyEnum.func_177707_a((String)"type", clazz, (Collection)types);
        return new BlockBaseLog<T>(name, modid, tab, clazz, ordinal);
    }
}

