/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block.wood;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.smileycorp.atlas.api.block.wood.BlockBaseSapling;
import net.smileycorp.atlas.api.block.wood.WoodEnum;
import net.smileycorp.atlas.api.block.wood.WoodVariant;

public class BlockBaseLeaves<T extends Enum<T>>
extends BlockLeaves
implements WoodVariant<T> {
    private static PropertyEnum staticProp;
    private final Class<T> types;
    private final int ordinal;
    private PropertyEnum<T> type;
    protected BlockBaseSapling sapling;

    private BlockBaseLeaves(String name, String modid, CreativeTabs tab, BlockBaseSapling sapling, Class<T> types, int ordinal) {
        this.types = types;
        this.ordinal = ordinal;
        this.setRegistryName(new ResourceLocation(modid, name));
        this.func_149663_c(modid + "." + name);
        this.func_149647_a(tab);
        this.sapling = sapling;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(this.type, (Comparable)((Object)((Enum[])types.getEnumConstants())[ordinal])).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        this.type = staticProp;
        return new BlockStateContainer((Block)this, new IProperty[]{this.type, field_176237_a, field_176236_b});
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((Enum)((Object)state.func_177229_b(this.type))).ordinal() % 4;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            meta += 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            meta += 8;
        }
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.type, (Comparable)((Object)((Enum[])this.types.getEnumConstants())[this.ordinal * 4 + meta % 4])).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(meta % 8 < 4)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(meta >= 8));
    }

    @Override
    public int getMaxMeta() {
        return this.type.func_177700_c().size();
    }

    @Override
    public String byMeta(int meta) {
        return this.byState(this.func_176203_a(meta));
    }

    @Override
    public String byState(IBlockState state) {
        return ((IStringSerializable)((Enum)((Object)state.func_177229_b(this.type)))).func_176610_l() + "_leaves";
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(this.type, (Comparable)((Object)((Enum[])this.types.getEnumConstants())[this.ordinal * 4 + placer.func_184586_b(hand).func_77960_j() % 4]));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, ((Enum)((Object)state.func_177229_b(this.type))).ordinal() % 4);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((WoodEnum)((Object)((Enum)((Object)state.func_177229_b(this.type))))).leavesColour();
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return ((WoodEnum)((Object)((Enum)((Object)world.func_180495_p(pos).func_177229_b(this.type))))).isFlammable();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.isFlammable(world, pos, facing) ? 20 : super.getFlammability(world, pos, facing);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.isFlammable(world, pos, facing) ? 5 : super.getFireSpreadSpeed(world, pos, facing);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return ((WoodEnum)((Object)((Enum)((Object)state.func_177229_b(this.type))))).getLeavesSoundType();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < this.type.func_177700_c().size(); ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)this, 1, ((Enum)((Object)world.func_180495_p(pos).func_177229_b(this.type))).ordinal() % 4)});
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        Enum type = (Enum)((Object)state.func_177229_b(this.type));
        if (((WoodEnum)((Object)type)).hasSapling() && rand.nextFloat() < this.getModifiedChance(((WoodEnum)((Object)type)).saplingDropChance(), fortune)) {
            drops.add((Object)new ItemStack((Block)this.sapling, 1, type.ordinal() % 4));
        }
        for (Map.Entry<ItemStack, Float> drop : ((WoodEnum)((Object)type)).getLeafDrops().entrySet()) {
            if (!(rand.nextFloat() < this.getModifiedChance(drop.getValue().floatValue(), fortune))) continue;
            drops.add((Object)drop.getKey());
        }
    }

    private float getModifiedChance(float base, int fortune) {
        return Math.min(1.0f, 0.01f * (float)(fortune * fortune) + base);
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((WoodEnum)((Object)((Enum)((Object)state.func_177229_b(this.type))))).solidLeaves() ? 255 : super.getLightOpacity(state, world, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return !blockAccess.func_180495_p(pos.func_177972_a(side)).doesSideBlockRendering(blockAccess, pos.func_177972_a(side), side.func_176734_d());
    }

    @Override
    public PropertyEnum<T> getVariantProperty() {
        return this.type;
    }

    public static <T extends Enum<T>> BlockBaseLeaves<T> create(String name, String modid, CreativeTabs tab, BlockBaseSapling sapling, Class<T> clazz, int ordinal) {
        HashSet types = Sets.newHashSet();
        for (int i = ordinal * 4; i < (ordinal + 1) * 4 && i < ((Enum[])clazz.getEnumConstants()).length; ++i) {
            types.add(((Enum[])clazz.getEnumConstants())[i]);
        }
        staticProp = PropertyEnum.func_177707_a((String)"type", clazz, (Collection)types);
        return new BlockBaseLeaves<T>(name, modid, tab, sapling, clazz, ordinal);
    }
}

