/*
 * Decompiled with CFR 0.152.
 */
package xt9.inworldcrafting.common.crafttweaker;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import xt9.inworldcrafting.common.event.EntityMatcher;
import xt9.inworldcrafting.common.recipe.FluidToItemRecipe;

@ZenClass(value="mods.inworldcrafting.FluidToItem")
public class FluidToItem {
    @ZenMethod
    public static void transform(IItemStack outputItem, ILiquidStack inputFluid, IIngredient[] ingredients) {
        FluidToItem.transform(outputItem, inputFluid, ingredients, false);
    }

    @ZenMethod
    public static void transform(IItemStack outputItem, ILiquidStack inputFluid, IIngredient[] ingredients, boolean consume) {
        for (int i = 0; i < ingredients.length; ++i) {
            if (ingredients[i].getLiquids().size() <= 0) continue;
            return;
        }
        int inputlength = ingredients.length > 4 ? 4 : ingredients.length;
        IIngredient[] inputs = new IIngredient[inputlength];
        System.arraycopy(ingredients, 0, inputs, 0, inputs.length);
        ItemStack outputItemStack = CraftTweakerMC.getItemStack((IItemStack)outputItem);
        String inputFluidName = FluidToItem.getFluidName(inputFluid);
        EntityMatcher.allValidInputs.add((Object)ingredients[0]);
        FluidToItemRecipe.addRecipe(outputItemStack, inputFluidName, inputs, consume);
    }

    private static String getFluidName(ILiquidStack stack) {
        return stack.getDefinition().getName();
    }
}

