/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.villagertrades.trades;

import java.util.HashMap;
import net.crazysnailboy.mods.villagertrades.trades.CustomTrades;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class TradeHandlers {
    public static final HashMap<Class<? extends EntityVillager.ITradeList>, ITradeHandler> tradeHandlers = new HashMap();

    static {
        tradeHandlers.put(EntityVillager.EmeraldForItems.class, new EmeraldForItemsHandler());
        tradeHandlers.put(CustomTrades.VTTVillagerBuyingTrade.class, new VTTVillagerBuyingHandler());
        tradeHandlers.put(EntityVillager.ItemAndEmeraldToItem.class, new ItemAndEmeraldToItemHandler());
        tradeHandlers.put(EntityVillager.ListEnchantedBookForEmeralds.class, new ListEnchantedBookForEmeraldsHandler());
        tradeHandlers.put(EntityVillager.ListEnchantedItemForEmeralds.class, new ListEnchantedItemForEmeraldsHandler());
        tradeHandlers.put(EntityVillager.ListItemForEmeralds.class, new ListItemForEmeraldsHandler());
        try {
            Class<?> TreasureMapForEmeralds$class = Class.forName("net.minecraft.entity.passive.EntityVillager$TreasureMapForEmeralds");
            tradeHandlers.put(TreasureMapForEmeralds$class, new TreasureMapForEmeraldsHandler());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        tradeHandlers.put(CustomTrades.VTTVillagerSellingTrade.class, new VTTVillagerSellingHandler());
    }

    public static class TreasureMapForEmeraldsHandler
    extends VTTVillagerSellingHandler {
        @Override
        public ItemStack getSellingStack(EntityVillager.ITradeList t) {
            ItemStack stack = new ItemStack((Item)Items.field_151098_aY, 1);
            return stack;
        }
    }

    public static class ListItemForEmeraldsHandler
    extends VTTVillagerSellingHandler {
        @Override
        public ItemStack getSellingStack(EntityVillager.ITradeList t) {
            EntityVillager.ListItemForEmeralds trade = (EntityVillager.ListItemForEmeralds)t;
            ItemStack stack = trade.field_179403_a.func_77946_l();
            return stack;
        }
    }

    public static class ListEnchantedItemForEmeraldsHandler
    extends VTTVillagerSellingHandler {
        @Override
        public ItemStack getSellingStack(EntityVillager.ITradeList t) {
            EntityVillager.ListEnchantedItemForEmeralds trade = (EntityVillager.ListEnchantedItemForEmeralds)t;
            ItemStack stack = trade.field_179407_a.func_77946_l();
            return stack;
        }
    }

    public static class ListEnchantedBookForEmeraldsHandler
    extends VTTVillagerSellingHandler {
        @Override
        public ItemStack getSellingStack(EntityVillager.ITradeList t) {
            EntityVillager.ListEnchantedBookForEmeralds trade = (EntityVillager.ListEnchantedBookForEmeralds)t;
            ItemStack stack = new ItemStack(Items.field_151134_bR, 1, 0);
            return stack;
        }
    }

    public static class ItemAndEmeraldToItemHandler
    extends VTTVillagerSellingHandler {
        @Override
        public ItemStack getSellingStack(EntityVillager.ITradeList t) {
            EntityVillager.ItemAndEmeraldToItem trade = (EntityVillager.ItemAndEmeraldToItem)t;
            ItemStack stack = trade.field_179410_c.func_77946_l();
            return stack;
        }
    }

    public static class VTTVillagerSellingHandler
    implements ITradeHandler {
        public ItemStack getSellingStack(EntityVillager.ITradeList trade) {
            return ItemStack.field_190927_a;
        }
    }

    public static class EmeraldForItemsHandler
    extends VTTVillagerBuyingHandler {
        @Override
        public ItemStack getBuyingStack(EntityVillager.ITradeList t) {
            EntityVillager.EmeraldForItems trade = (EntityVillager.EmeraldForItems)t;
            ItemStack stack = new ItemStack(trade.field_179405_a, 1, 0);
            return stack;
        }
    }

    public static class VTTVillagerBuyingHandler
    implements ITradeHandler {
        public ItemStack getBuyingStack(EntityVillager.ITradeList trade) {
            return ItemStack.field_190927_a;
        }
    }

    public static interface ITradeHandler {
    }
}

