/*
 * Decompiled with CFR 0.152.
 */
package com.leviathanstudio.craftstudio.client.model;

import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CSModelBox {
    private final TexturedQuad[] quadList;
    public String boxName;
    private static final double NORM_PREC = 1.0E-4;

    public CSModelBox(ModelRenderer renderer, int texU, int texV, float x, float y, float z, float dx, float dy, float dz) {
        this(renderer, texU, texV, x, y, z, dx, dy, dz, renderer.field_78809_i);
    }

    public CSModelBox(ModelRenderer renderer, int texU, int texV, float x, float y, float z, float dx, float dy, float dz, boolean mirror) {
        this(renderer, CSModelBox.getVerticesForRect(x, y, z, dx, dy, dz, mirror), CSModelBox.getTextureUVsForRect(texU, texV, dx, dy, dz), mirror);
    }

    public CSModelBox(ModelRenderer renderer, PositionTextureVertex[] positionTextureVertex, int[][] textUVs) {
        this(renderer, positionTextureVertex, textUVs, renderer.field_78809_i);
    }

    public CSModelBox(ModelRenderer renderer, PositionTextureVertex[] positionTextureVertex, int[][] textUVs, boolean mirror) {
        this(positionTextureVertex);
        this.setTexture(renderer, textUVs);
        this.checkBlockForShadow();
        if (mirror) {
            for (TexturedQuad texturedquad : this.quadList) {
                texturedquad.func_78235_a();
            }
        }
    }

    public CSModelBox(PositionTextureVertex[] positionTextureVertex) {
        this(6);
        this.setVertex(positionTextureVertex);
    }

    public CSModelBox(int facesNumber) {
        this.quadList = new TexturedQuad[facesNumber];
    }

    public void setVertex(PositionTextureVertex[] positionTextureVertex) {
        if (positionTextureVertex.length == 8) {
            this.quadList[0] = new TexturedQuad(new PositionTextureVertex[]{positionTextureVertex[5], positionTextureVertex[1], positionTextureVertex[2], positionTextureVertex[6]});
            this.quadList[1] = new TexturedQuad(new PositionTextureVertex[]{positionTextureVertex[0], positionTextureVertex[4], positionTextureVertex[7], positionTextureVertex[3]});
            this.quadList[2] = new TexturedQuad(new PositionTextureVertex[]{positionTextureVertex[5], positionTextureVertex[4], positionTextureVertex[0], positionTextureVertex[1]});
            this.quadList[3] = new TexturedQuad(new PositionTextureVertex[]{positionTextureVertex[2], positionTextureVertex[3], positionTextureVertex[7], positionTextureVertex[6]});
            this.quadList[4] = new TexturedQuad(new PositionTextureVertex[]{positionTextureVertex[1], positionTextureVertex[0], positionTextureVertex[3], positionTextureVertex[2]});
            this.quadList[5] = new TexturedQuad(new PositionTextureVertex[]{positionTextureVertex[4], positionTextureVertex[5], positionTextureVertex[6], positionTextureVertex[7]});
        }
    }

    private void checkBlockForShadow() {
        Vec3d or = this.quadList[1].field_78239_a[0].field_78243_a;
        double x = this.quadList[0].field_78239_a[1].field_78243_a.field_72450_a;
        double y = this.quadList[1].field_78239_a[3].field_78243_a.field_72448_b;
        double z = this.quadList[1].field_78239_a[1].field_78243_a.field_72449_c;
        if (x - or.field_72450_a < 0.0) {
            this.flipFaces();
        }
        if (y - or.field_72448_b > 0.0) {
            this.flipFaces();
        }
        if (z - or.field_72449_c > 0.0) {
            this.flipFaces();
        }
    }

    private void flipFaces() {
        for (int i = 0; i < this.quadList.length; ++i) {
            this.quadList[i].func_78235_a();
        }
    }

    public void setTexture(ModelRenderer renderer, int[][] textUVs) {
        if (textUVs.length == 6) {
            for (int i = 0; i < 6; ++i) {
                int[] textUV = textUVs[i];
                if (textUV.length != 4) continue;
                this.quadList[i] = new TexturedQuad(this.quadList[i].field_78239_a, textUV[0], textUV[1], textUV[2], textUV[3], renderer.field_78801_a, renderer.field_78799_b);
            }
        }
    }

    public static PositionTextureVertex[] getVerticesForRect(float x, float y, float z, float dx, float dy, float dz, boolean mirror) {
        PositionTextureVertex[] positionTextureVertex = new PositionTextureVertex[8];
        float endX = x + dx;
        float endY = y + dy;
        float endZ = z + dz;
        if (mirror) {
            float buffer = endX;
            endX = x;
            x = buffer;
        }
        positionTextureVertex[0] = new PositionTextureVertex(x, y, z, 0.0f, 0.0f);
        positionTextureVertex[1] = new PositionTextureVertex(endX, y, z, 0.0f, 0.0f);
        positionTextureVertex[2] = new PositionTextureVertex(endX, endY, z, 0.0f, 0.0f);
        positionTextureVertex[3] = new PositionTextureVertex(x, endY, z, 0.0f, 0.0f);
        positionTextureVertex[4] = new PositionTextureVertex(x, y, endZ, 0.0f, 0.0f);
        positionTextureVertex[5] = new PositionTextureVertex(endX, y, endZ, 0.0f, 0.0f);
        positionTextureVertex[6] = new PositionTextureVertex(endX, endY, endZ, 0.0f, 0.0f);
        positionTextureVertex[7] = new PositionTextureVertex(x, endY, endZ, 0.0f, 0.0f);
        return positionTextureVertex;
    }

    public static int[][] getTextureUVsForRect(int texU, int texV, float dx, float dy, float dz) {
        dy = -dy;
        dz = -dz;
        int[][] tab = new int[][]{{(int)((float)texU + dz + dx + dz), (int)((float)texV + dz + dy), (int)((float)texU + dz + dx), (int)((float)texV + dz)}, {(int)((float)texU + dz), (int)((float)texV + dz + dy), texU, (int)((float)texV + dz)}, {(int)((float)texU + dz + dx), texV, (int)((float)texU + dz + dx + dx), (int)((float)texV + dz)}, {(int)((float)texU + dz), texV, (int)((float)texU + dz + dx), (int)((float)texV + dz)}, {(int)((float)texU + dz + dx + dz + dx), (int)((float)texV + dz + dy), (int)((float)texU + dz + dx + dz), (int)((float)texV + dz)}, {(int)((float)texU + dz + dx), (int)((float)texV + dz + dy), (int)((float)texU + dz), (int)((float)texV + dz)}};
        return tab;
    }

    public void render(BufferBuilder renderer, float scale) {
        for (TexturedQuad texturedquad : this.quadList) {
            texturedquad.func_178765_a(renderer, scale);
        }
    }

    public CSModelBox setBoxName(String name) {
        this.boxName = name;
        return this;
    }

    public TexturedQuad[] getQuadList() {
        return this.quadList;
    }
}

