/*
 * Decompiled with CFR 0.152.
 */
package com.leviathanstudio.craftstudio.client.animation;

import com.leviathanstudio.craftstudio.client.animation.EnumAnimationMode;
import com.leviathanstudio.craftstudio.client.animation.KeyFrame;
import com.leviathanstudio.craftstudio.common.animation.InfoChannel;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientChannel
extends InfoChannel {
    private Map<Integer, KeyFrame> keyFrames = new HashMap<Integer, KeyFrame>();
    private EnumAnimationMode animationMode = EnumAnimationMode.LINEAR;

    public ClientChannel(String channelName, boolean initialize) {
        super(channelName);
        if (initialize) {
            this.initializeAllFrames();
        }
    }

    public ClientChannel(String animationName, float fps, int totalFrames, EnumAnimationMode animationMode, boolean initialize) {
        this(animationName, initialize);
        this.fps = fps;
        this.totalFrames = totalFrames;
        this.setAnimationMode(animationMode);
        if (animationMode == EnumAnimationMode.LOOP) {
            this.looped = true;
        }
    }

    protected void initializeAllFrames() {
    }

    public KeyFrame getPreviousRotationKeyFrameForBox(String boxName, float currentFrame) {
        int latestFramePosition = -1;
        int lastFramePosition = -1;
        KeyFrame latestKeyFrame = null;
        for (Map.Entry<Integer, KeyFrame> entry : this.keyFrames.entrySet()) {
            Integer key = entry.getKey();
            KeyFrame value = entry.getValue();
            if ((float)key.intValue() <= currentFrame && key > latestFramePosition && value.useBoxInRotations(boxName)) {
                latestFramePosition = key;
                latestKeyFrame = value;
            }
            if (key <= lastFramePosition || !value.useBoxInRotations(boxName)) continue;
            lastFramePosition = key;
        }
        if (latestKeyFrame == null && lastFramePosition >= 0) {
            this.keyFrames.put(lastFramePosition - this.totalFrames, this.keyFrames.get(lastFramePosition).clone());
            latestKeyFrame = this.keyFrames.get(lastFramePosition - this.totalFrames);
        }
        return latestKeyFrame;
    }

    public KeyFrame getNextRotationKeyFrameForBox(String boxName, float currentFrame) {
        int nextFramePosition = -1;
        int firstFramePosition = this.totalFrames + 1;
        KeyFrame nextKeyFrame = null;
        if (currentFrame > (float)this.totalFrames) {
            return this.keyFrames.get(this.totalFrames);
        }
        for (Map.Entry<Integer, KeyFrame> entry : this.keyFrames.entrySet()) {
            Integer key = entry.getKey();
            KeyFrame value = entry.getValue();
            if ((float)key.intValue() > currentFrame && (key < nextFramePosition || nextFramePosition == -1) && value.useBoxInRotations(boxName)) {
                nextFramePosition = key;
                nextKeyFrame = value;
            }
            if (key >= firstFramePosition || !value.useBoxInRotations(boxName)) continue;
            firstFramePosition = key;
        }
        if (nextKeyFrame == null && firstFramePosition < this.totalFrames + 1) {
            this.keyFrames.put(this.totalFrames + firstFramePosition, this.keyFrames.get(firstFramePosition).clone());
            nextKeyFrame = this.keyFrames.get(this.totalFrames + firstFramePosition);
        }
        return nextKeyFrame;
    }

    public KeyFrame getPreviousTranslationKeyFrameForBox(String boxName, float currentFrame) {
        int latestFramePosition = -1;
        int lastFramePosition = -1;
        KeyFrame latestKeyFrame = null;
        for (Map.Entry<Integer, KeyFrame> entry : this.keyFrames.entrySet()) {
            Integer key = entry.getKey();
            KeyFrame value = entry.getValue();
            if ((float)key.intValue() <= currentFrame && key > latestFramePosition && value.useBoxInTranslations(boxName)) {
                latestFramePosition = key;
                latestKeyFrame = value;
            }
            if (key <= lastFramePosition || !value.useBoxInTranslations(boxName)) continue;
            lastFramePosition = key;
        }
        if (latestKeyFrame == null && lastFramePosition >= 0) {
            this.keyFrames.put(lastFramePosition - this.totalFrames, this.keyFrames.get(lastFramePosition).clone());
            latestKeyFrame = this.keyFrames.get(lastFramePosition - this.totalFrames);
        }
        return latestKeyFrame;
    }

    public KeyFrame getNextTranslationKeyFrameForBox(String boxName, float currentFrame) {
        int nextFramePosition = -1;
        int firstFramePosition = this.totalFrames + 1;
        KeyFrame nextKeyFrame = null;
        if (currentFrame > (float)this.totalFrames) {
            return this.keyFrames.get(this.totalFrames);
        }
        for (Map.Entry<Integer, KeyFrame> entry : this.keyFrames.entrySet()) {
            Integer key = entry.getKey();
            KeyFrame value = entry.getValue();
            if ((float)key.intValue() > currentFrame && (key < nextFramePosition || nextFramePosition == -1) && value.useBoxInTranslations(boxName)) {
                nextFramePosition = key;
                nextKeyFrame = value;
            }
            if (key >= firstFramePosition || !value.useBoxInTranslations(boxName)) continue;
            firstFramePosition = key;
        }
        if (nextKeyFrame == null && firstFramePosition < this.totalFrames + 1) {
            this.keyFrames.put(this.totalFrames + firstFramePosition, this.keyFrames.get(firstFramePosition).clone());
            nextKeyFrame = this.keyFrames.get(this.totalFrames + firstFramePosition);
        }
        return nextKeyFrame;
    }

    public KeyFrame getPreviousOffsetKeyFrameForBox(String boxName, float currentFrame) {
        int latestFramePosition = -1;
        int lastFramePosition = -1;
        KeyFrame latestKeyFrame = null;
        for (Map.Entry<Integer, KeyFrame> entry : this.keyFrames.entrySet()) {
            Integer key = entry.getKey();
            KeyFrame value = entry.getValue();
            if ((float)key.intValue() <= currentFrame && key > latestFramePosition && value.useBoxInOffsets(boxName)) {
                latestFramePosition = key;
                latestKeyFrame = value;
            }
            if (key <= lastFramePosition || !value.useBoxInOffsets(boxName)) continue;
            lastFramePosition = key;
        }
        if (latestKeyFrame == null && lastFramePosition >= 0) {
            this.keyFrames.put(lastFramePosition - this.totalFrames, this.keyFrames.get(lastFramePosition).clone());
            latestKeyFrame = this.keyFrames.get(lastFramePosition - this.totalFrames);
        }
        return latestKeyFrame;
    }

    public KeyFrame getNextOffsetKeyFrameForBox(String boxName, float currentFrame) {
        int nextFramePosition = -1;
        int firstFramePosition = this.totalFrames + 1;
        KeyFrame nextKeyFrame = null;
        if (currentFrame > (float)this.totalFrames) {
            return this.keyFrames.get(this.totalFrames);
        }
        for (Map.Entry<Integer, KeyFrame> entry : this.keyFrames.entrySet()) {
            Integer key = entry.getKey();
            KeyFrame value = entry.getValue();
            if ((float)key.intValue() > currentFrame && (key < nextFramePosition || nextFramePosition == -1) && value.useBoxInOffsets(boxName)) {
                nextFramePosition = key;
                nextKeyFrame = value;
            }
            if (key >= firstFramePosition || !value.useBoxInOffsets(boxName)) continue;
            firstFramePosition = key;
        }
        if (nextKeyFrame == null && firstFramePosition < this.totalFrames + 1) {
            this.keyFrames.put(this.totalFrames + firstFramePosition, this.keyFrames.get(firstFramePosition).clone());
            nextKeyFrame = this.keyFrames.get(this.totalFrames + firstFramePosition);
        }
        return nextKeyFrame;
    }

    public KeyFrame getPreviousStretchKeyFrameForBox(String boxName, float currentFrame) {
        int latestFramePosition = -1;
        int lastFramePosition = -1;
        KeyFrame latestKeyFrame = null;
        for (Map.Entry<Integer, KeyFrame> entry : this.keyFrames.entrySet()) {
            Integer key = entry.getKey();
            KeyFrame value = entry.getValue();
            if ((float)key.intValue() <= currentFrame && key > latestFramePosition && value.useBoxInStretchs(boxName)) {
                latestFramePosition = key;
                latestKeyFrame = value;
            }
            if (key <= lastFramePosition || !value.useBoxInStretchs(boxName)) continue;
            lastFramePosition = key;
        }
        if (latestKeyFrame == null && lastFramePosition >= 0) {
            this.keyFrames.put(lastFramePosition - this.totalFrames, this.keyFrames.get(lastFramePosition).clone());
            latestKeyFrame = this.keyFrames.get(lastFramePosition - this.totalFrames);
        }
        return latestKeyFrame;
    }

    public KeyFrame getNextStretchKeyFrameForBox(String boxName, float currentFrame) {
        int nextFramePosition = -1;
        int firstFramePosition = this.totalFrames + 1;
        KeyFrame nextKeyFrame = null;
        if (currentFrame > (float)this.totalFrames) {
            return this.keyFrames.get(this.totalFrames);
        }
        for (Map.Entry<Integer, KeyFrame> entry : this.keyFrames.entrySet()) {
            Integer key = entry.getKey();
            KeyFrame value = entry.getValue();
            if ((float)key.intValue() > currentFrame && (key < nextFramePosition || nextFramePosition == -1) && value.useBoxInStretchs(boxName)) {
                nextFramePosition = key;
                nextKeyFrame = value;
            }
            if (key >= firstFramePosition || !value.useBoxInStretchs(boxName)) continue;
            firstFramePosition = key;
        }
        if (nextKeyFrame == null && firstFramePosition < this.totalFrames + 1) {
            this.keyFrames.put(this.totalFrames + firstFramePosition, this.keyFrames.get(firstFramePosition).clone());
            nextKeyFrame = this.keyFrames.get(this.totalFrames + firstFramePosition);
        }
        return nextKeyFrame;
    }

    public int getKeyFramePosition(KeyFrame keyFrame) {
        if (keyFrame != null) {
            for (Map.Entry<Integer, KeyFrame> entry : this.keyFrames.entrySet()) {
                Integer key = entry.getKey();
                KeyFrame keyframe = entry.getValue();
                if (keyframe != keyFrame) continue;
                return key;
            }
        }
        return -1;
    }

    public ClientChannel getInvertedChannel(String name) {
        ClientChannel chan = new ClientChannel(name, this.fps, this.totalFrames, this.getAnimationMode(), true);
        for (Map.Entry<Integer, KeyFrame> entry : this.keyFrames.entrySet()) {
            chan.keyFrames.put(this.totalFrames - entry.getKey(), entry.getValue().clone());
        }
        return chan;
    }

    public Map<Integer, KeyFrame> getKeyFrames() {
        return this.keyFrames;
    }

    public void setKeyFrames(Map<Integer, KeyFrame> keyFrames) {
        this.keyFrames = keyFrames;
    }

    public EnumAnimationMode getAnimationMode() {
        return this.animationMode;
    }

    public void setAnimationMode(EnumAnimationMode animationMode) {
        this.animationMode = animationMode;
    }
}

