/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.command;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.silentchaos512.lib.command.CommandBaseSL;
import net.silentchaos512.scalinghealth.config.Config;
import net.silentchaos512.scalinghealth.utils.SHPlayerDataHandler;
import net.silentchaos512.scalinghealth.world.ScalingHealthSavedData;

public class CommandScalingHealth
extends CommandBaseSL {
    private static final String NUMFORMAT = "%.2f";

    public String func_71517_b() {
        return "scalinghealth";
    }

    public String func_71518_a(ICommandSender sender) {
        return TextFormatting.RED + "Usage: /" + this.func_71517_b() + " <difficulty|health|world_difficulty> <get|set|add|sub> [value] [player]";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        boolean isGet;
        if (args.length == 1 && "config_reload".equals(args[0])) {
            CommandScalingHealth.executeConfigReload(sender);
            return;
        }
        if (args.length < 2) {
            CommandScalingHealth.tell(sender, this.func_71518_a(sender), false, new Object[0]);
            return;
        }
        String command = args[0];
        SubCommand subCommand = SubCommand.fromArg(args[1]);
        boolean bl = isGet = subCommand == SubCommand.GET;
        if (subCommand == null || !isGet && args.length < 3) {
            CommandScalingHealth.tell(sender, this.func_71518_a(sender), false, new Object[0]);
            return;
        }
        double value = isGet ? -1.0 : CommandScalingHealth.func_175765_c((String)args[2]);
        List<EntityPlayerMP> targets = CommandScalingHealth.getTargetPlayers(server, sender, isGet, args);
        if ("difficulty".equals(command)) {
            CommandScalingHealth.executeDifficulty(server, sender, subCommand, value, targets);
        } else if ("health".equals(command)) {
            CommandScalingHealth.executeHealth(server, sender, subCommand, value, targets);
        } else if ("world_difficulty".equals(command)) {
            CommandScalingHealth.executeWorldDifficulty(server, sender, subCommand, value, sender.func_130014_f_());
        } else {
            CommandScalingHealth.tell(sender, this.func_71518_a(sender), false, new Object[0]);
        }
    }

    private static List<EntityPlayerMP> getTargetPlayers(MinecraftServer server, ICommandSender sender, boolean isGet, String[] args) throws PlayerNotFoundException, CommandException {
        int index = isGet ? 2 : 3;
        return args.length < index + 1 ? ImmutableList.of((Object)CommandScalingHealth.func_71521_c((ICommandSender)sender)) : CommandScalingHealth.func_193513_a((MinecraftServer)server, (ICommandSender)sender, (String)args[index]);
    }

    private static void executeDifficulty(MinecraftServer server, ICommandSender sender, @Nonnull SubCommand subCommand, double value, List<EntityPlayerMP> targets) {
        if (targets.isEmpty()) {
            return;
        }
        for (EntityPlayerMP player : targets) {
            double max;
            double current;
            SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get((EntityPlayer)player);
            if (data == null) {
                CommandScalingHealth.tell(sender, "Player data is null for " + player.func_70005_c_(), false, new Object[0]);
                continue;
            }
            if (subCommand == SubCommand.GET) {
                current = data.getDifficulty();
                String strCurrent = String.format(NUMFORMAT, current);
                String strMax = String.format(NUMFORMAT, Float.valueOf(Config.Difficulty.maxValue));
                CommandScalingHealth.tell(sender, "showDifficulty", true, player.func_70005_c_(), strCurrent, strMax);
                continue;
            }
            current = data.getDifficulty();
            double toSet = CommandScalingHealth.getValueToSet(subCommand, value, current);
            double min = CommandScalingHealth.getMinValue(subCommand, current, Config.Difficulty.minValue, Config.Difficulty.maxValue);
            if (!CommandScalingHealth.checkBounds(value, min, max = CommandScalingHealth.getMaxValue(subCommand, current, Config.Difficulty.minValue, Config.Difficulty.maxValue))) {
                CommandScalingHealth.tell(sender, TextFormatting.RED, "outOfBounds", true, String.format(NUMFORMAT, min), String.format(NUMFORMAT, max));
                return;
            }
            data.setDifficulty(toSet);
            CommandScalingHealth.tell(sender, "setDifficulty", true, player.func_70005_c_(), String.format(NUMFORMAT, toSet));
        }
    }

    private static void executeWorldDifficulty(MinecraftServer server, ICommandSender sender, @Nonnull SubCommand subCommand, double value, World world) {
        ScalingHealthSavedData data = ScalingHealthSavedData.get(world);
        if (data == null) {
            CommandScalingHealth.tell(sender, "World data is null!", false, new Object[0]);
            return;
        }
        if (subCommand == SubCommand.GET) {
            double current = data.difficulty;
            String strCurrent = String.format(NUMFORMAT, current);
            String strMax = String.format(NUMFORMAT, Float.valueOf(Config.Difficulty.maxValue));
            CommandScalingHealth.tell(sender, "showWorldDifficulty", true, strCurrent, strMax);
        } else {
            double max;
            double current = data.difficulty;
            double toSet = CommandScalingHealth.getValueToSet(subCommand, value, current);
            double min = CommandScalingHealth.getMinValue(subCommand, current, Config.Difficulty.minValue, Config.Difficulty.maxValue);
            if (!CommandScalingHealth.checkBounds(value, min, max = CommandScalingHealth.getMaxValue(subCommand, current, Config.Difficulty.minValue, Config.Difficulty.maxValue))) {
                CommandScalingHealth.tell(sender, TextFormatting.RED, "outOfBounds", true, String.format(NUMFORMAT, min), String.format(NUMFORMAT, max));
                return;
            }
            data.difficulty = toSet;
            data.func_76185_a();
            CommandScalingHealth.tell(sender, "setWorldDifficulty", true, String.format(NUMFORMAT, toSet));
        }
    }

    private static void executeHealth(MinecraftServer server, ICommandSender sender, @Nonnull SubCommand subCommand, double value, List<EntityPlayerMP> targets) {
        if (targets.isEmpty()) {
            return;
        }
        for (EntityPlayerMP player : targets) {
            double max;
            SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get((EntityPlayer)player);
            if (data == null) {
                CommandScalingHealth.tell(sender, "Player data is null for " + player.func_70005_c_(), false, new Object[0]);
                continue;
            }
            if (subCommand == SubCommand.GET) {
                float current = player.func_110143_aJ();
                float max2 = player.func_110138_aP();
                float modValue = data.getMaxHealth() - (float)Config.Player.Health.startingHealth;
                String strCurrent = String.format(NUMFORMAT, Float.valueOf(current));
                String strMax = String.format(NUMFORMAT, Float.valueOf(max2));
                String strMod = (modValue >= 0.0f ? "+" : "") + modValue;
                CommandScalingHealth.tell(sender, "showHealth", true, player.func_70005_c_(), strCurrent, strMax, strMod);
                continue;
            }
            double current = data.getMaxHealth();
            double toSet = CommandScalingHealth.getValueToSet(subCommand, value, current);
            double hardMax = Config.Player.Health.maxHealth;
            hardMax = (int)(hardMax <= 0.0 ? SharedMonsterAttributes.field_111267_a.func_111109_a(2.147483647E9) : hardMax);
            double min = CommandScalingHealth.getMinValue(subCommand, current, 2.0, hardMax);
            if (!CommandScalingHealth.checkBounds(value, min, max = CommandScalingHealth.getMaxValue(subCommand, current, 2.0, hardMax))) {
                CommandScalingHealth.tell(sender, TextFormatting.RED, "outOfBounds", true, min, max);
                return;
            }
            float toHeal = (float)(toSet - current);
            data.setMaxHealth((float)toSet);
            if (toHeal > 0.0f) {
                player.func_70691_i(toHeal);
            }
            CommandScalingHealth.tell(sender, "setHealth", true, player.func_70005_c_(), toSet);
        }
    }

    private static void executeConfigReload(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString("Attempting to reload config, check log for details"));
        Config.INSTANCE.load();
    }

    private static double getValueToSet(SubCommand subCommand, double value, double current) {
        double toSet = value;
        if (subCommand == SubCommand.ADD) {
            toSet = current + value;
        } else if (subCommand == SubCommand.SUB) {
            toSet = current - value;
        }
        return toSet;
    }

    private static double getMinValue(SubCommand subCommand, double current, double min, double max) {
        if (subCommand == SubCommand.ADD) {
            return min - current;
        }
        if (subCommand == SubCommand.SUB) {
            return current - max;
        }
        return min;
    }

    private static double getMaxValue(SubCommand subCommand, double current, double min, double max) {
        if (subCommand == SubCommand.ADD) {
            return max - current;
        }
        if (subCommand == SubCommand.SUB) {
            return current - min;
        }
        return max;
    }

    private static boolean checkBounds(double value, double min, double max) {
        return !(value < min) && !(value > max);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            return CommandScalingHealth.func_71530_a((String[])args, (String[])new String[]{"difficulty", "health", "world_difficulty"});
        }
        if (args.length == 2) {
            return CommandScalingHealth.func_71530_a((String[])args, (String[])new String[]{"get", "set", "add", "sub"});
        }
        if (this.func_82358_a(args, args.length)) {
            return CommandScalingHealth.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return ImmutableList.of();
    }

    public boolean func_82358_a(String[] args, int index) {
        return args.length > 2 && "get".equals(args[1]) ? index == 3 : index == 4;
    }

    private static void tell(ICommandSender sender, String key, boolean fromLocalizationFile, Object ... args) {
        CommandScalingHealth.tell(sender, TextFormatting.RESET, key, fromLocalizationFile, args);
    }

    private static void tell(ICommandSender sender, TextFormatting format, String key, boolean fromLocalizationFile, Object ... args) {
        key = "command.scalinghealth." + key;
        if (fromLocalizationFile) {
            sender.func_145747_a(new TextComponentString(String.valueOf(format)).func_150257_a((ITextComponent)new TextComponentTranslation(key, args)));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(format + String.format(key, args)));
        }
    }

    static enum SubCommand {
        GET,
        SET,
        ADD,
        SUB;


        @Nullable
        static SubCommand fromArg(String arg) {
            for (SubCommand val : SubCommand.values()) {
                if (!val.name().equalsIgnoreCase(arg)) continue;
                return val;
            }
            return null;
        }
    }
}

