/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule.parse;

import com.codetaylor.mc.athenaeum.parser.recipe.item.MalformedRecipeItemException;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.Rule;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleDrop;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleList;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.ILogger;
import com.codetaylor.mc.dropt.modules.dropt.rule.parse.IRuleListParser;
import com.codetaylor.mc.dropt.modules.dropt.rule.parse.ParserUtil;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class ParserRuleDropItem
implements IRuleListParser {
    @Override
    public void parse(RecipeItemParser parser, RuleList ruleList, Rule rule, ILogger logger, DebugFileWrapper debugFileWrapper) {
        int dropIndex = 0;
        for (RuleDrop drop : rule.drops) {
            ItemStack itemStack;
            Item item;
            ParserUtil.NBTParseResult parse;
            if (drop == null) {
                logger.warn(String.format("[PARSE] Malformed JSON caused null RuleDrop, skipping null RuleDrop at index %d in file %s", dropIndex, ruleList._filename));
                ++dropIndex;
                continue;
            }
            if (drop.item == null) {
                if (rule.debug) {
                    debugFileWrapper.debug(String.format("[PARSE] Drop item object not defined in IRuleDrop at index %d, skipped parsing drop item", dropIndex));
                }
                ++dropIndex;
                continue;
            }
            if (drop.item.items == null || drop.item.items.length == 0) {
                if (rule.debug) {
                    debugFileWrapper.debug(String.format("[PARSE] Drop item.items object not defined or empty in IRuleDrop at index %d, skipped parsing drop item", dropIndex));
                }
                ++dropIndex;
                continue;
            }
            if (rule.debug) {
                debugFileWrapper.debug("[PARSE] Parsing drop items for IRuleDrop at index " + dropIndex);
            }
            for (String itemString : drop.item.items) {
                try {
                    parse = ParserUtil.parseWithNBT(itemString, logger);
                }
                catch (MalformedRecipeItemException e) {
                    logger.error("[PARSE] Unable to parse itemString [" + itemString + "] in file: " + ruleList._filename, e);
                    continue;
                }
                if (rule.debug) {
                    debugFileWrapper.debug("[PARSE] Parsed item drop: " + parse.getDomain() + ":" + parse.getPath());
                    if (parse.getTag() != null) {
                        debugFileWrapper.debug("[PARSE] Parsed item drop nbt: " + parse.getTag());
                    }
                }
                if ("ore".equals(parse.getDomain())) {
                    NonNullList ores = OreDictionary.getOres((String)parse.getPath());
                    if (ores.isEmpty()) {
                        logger.warn("[PARSE] No entries found for oreDict entry [ore:" + parse.getPath() + "] in file: " + ruleList._filename);
                    } else if (rule.debug) {
                        debugFileWrapper.debug("[PARSE] Expanding oreDict entry: " + parse);
                    }
                    for (ItemStack ore : ores) {
                        if (ore.func_77973_b().func_77614_k()) {
                            ParserUtil.addSubItemsToList(ore.func_77973_b(), drop.item._items, debugFileWrapper, rule.debug);
                            continue;
                        }
                        ItemStack itemStack2 = new ItemStack(ore.func_77973_b(), parse.getQuantity(), ore.func_77960_j());
                        if (parse.getTag() != null) {
                            itemStack2.func_77982_d(parse.getTag().func_74737_b());
                        }
                        drop.item._items.add(itemStack2);
                        if (!rule.debug) continue;
                        debugFileWrapper.debug("[PARSE] Added itemStack to drop: " + itemStack2);
                    }
                    continue;
                }
                item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parse.getDomain(), parse.getPath()));
                if (item == null) {
                    logger.error("[PARSE] Unable to find registered item [" + parse.toString() + "] in file: " + ruleList._filename);
                    continue;
                }
                if (rule.debug) {
                    debugFileWrapper.debug("[PARSE] Found registered item: " + item);
                }
                if (parse.getMeta() == Short.MAX_VALUE) {
                    if (!item.func_77614_k()) {
                        logger.error("[PARSE] Wildcard used for item [" + parse.toString() + "], but item has no subtypes: " + ruleList._filename);
                        continue;
                    }
                    ParserUtil.addSubItemsToList(item, drop.item._items, debugFileWrapper, rule.debug);
                    continue;
                }
                itemStack = new ItemStack(item, parse.getQuantity(), parse.getMeta());
                if (parse.getTag() != null) {
                    itemStack.func_77982_d(parse.getTag().func_74737_b());
                }
                drop.item._items.add(itemStack);
                if (!rule.debug) continue;
                debugFileWrapper.debug("[PARSE] Added itemStack to drop: " + itemStack);
            }
            if (drop.item.matchQuantity.drops.length > 0) {
                for (String itemString : drop.item.matchQuantity.drops) {
                    try {
                        parse = parser.parse(itemString);
                    }
                    catch (MalformedRecipeItemException e) {
                        logger.error("[PARSE] Unable to parse item drop [" + itemString + "] in file: " + ruleList._filename, e);
                        continue;
                    }
                    if ("ore".equals(parse.getDomain())) {
                        drop.item.matchQuantity._drops.add((Ingredient)new OreIngredient(parse.getPath()));
                        if (!rule.debug) continue;
                        debugFileWrapper.debug("[PARSE] Added ore ingredient to match quantity: " + parse.getPath());
                        continue;
                    }
                    item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parse.getDomain(), parse.getPath()));
                    if (item == null) {
                        logger.error("[PARSE] Unable to find registered item [" + parse.toString() + "] in file: " + ruleList._filename);
                        continue;
                    }
                    if (rule.debug) {
                        debugFileWrapper.debug("[PARSE] Found registered item: " + item);
                    }
                    if (parse.getMeta() == Short.MAX_VALUE) {
                        if (!item.func_77614_k()) {
                            logger.error("[PARSE] Wildcard used for item [" + parse.toString() + "], but item has no subtypes: " + ruleList._filename);
                            continue;
                        }
                        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                        ParserUtil.addSubItemsToList(item, items, debugFileWrapper, rule.debug);
                        drop.item.matchQuantity._drops.add(Ingredient.func_193369_a((ItemStack[])items.toArray(new ItemStack[0])));
                        continue;
                    }
                    itemStack = new ItemStack(item, 1, parse.getMeta());
                    drop.item.matchQuantity._drops.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{itemStack}));
                    if (!rule.debug) continue;
                    debugFileWrapper.debug("[PARSE] Added itemStack ingredient to match quantity: " + itemStack);
                }
            }
            ++dropIndex;
        }
    }
}

