/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule.match;

import com.codetaylor.mc.dropt.api.reference.EnumListType;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleMatchSpawnDistance;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import net.minecraft.util.math.BlockPos;

public class SpawnDistanceMatcher {
    public boolean matches(RuleMatchSpawnDistance ruleMatchSpawnDistance, BlockPos position, BlockPos spawnPoint, DebugFileWrapper logFile, boolean debug) {
        boolean isBlacklist;
        double diffZ;
        int min = Math.max(ruleMatchSpawnDistance.min, 0);
        int max = ruleMatchSpawnDistance.max == -1 ? Integer.MAX_VALUE : Math.max(0, ruleMatchSpawnDistance.max);
        double diffX = spawnPoint.func_177958_n() - position.func_177958_n();
        double distance = Math.sqrt(diffX * diffX + (diffZ = (double)(spawnPoint.func_177952_p() - position.func_177952_p())) * diffZ);
        if (distance <= (double)max && distance >= (double)min) {
            boolean isWhitelist;
            boolean bl = isWhitelist = ruleMatchSpawnDistance.type == EnumListType.WHITELIST;
            if (debug) {
                if (isWhitelist) {
                    logFile.debug("[MATCH] [OK] Distance [" + distance + "] within range [" + min + "," + max + "]");
                } else {
                    logFile.debug("[MATCH] [!!] Distance [" + distance + "] outside range [" + min + "," + max + "]");
                }
            }
            return isWhitelist;
        }
        boolean bl = isBlacklist = ruleMatchSpawnDistance.type == EnumListType.BLACKLIST;
        if (debug) {
            if (isBlacklist) {
                logFile.debug("[MATCH] [OK] Distance [" + distance + "] outside range [" + min + "," + max + "]");
            } else {
                logFile.debug("[MATCH] [!!] Distance [" + distance + "] inside range [" + min + "," + max + "]");
            }
        }
        return isBlacklist;
    }
}

