/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule.match;

import com.codetaylor.mc.dropt.api.reference.EnumListType;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleMatchBiome;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import net.minecraft.world.biome.Biome;

public class BiomeMatcher {
    public boolean matches(RuleMatchBiome ruleMatchBiome, Biome biome, DebugFileWrapper logFile, boolean debug) {
        boolean result;
        if (ruleMatchBiome._biomes.isEmpty()) {
            if (debug) {
                logFile.debug("[MATCH] [OK] No biome matches defined");
            }
            return true;
        }
        if (debug) {
            logFile.debug("[MATCH] [--] Biome list type: " + (Object)((Object)ruleMatchBiome.type));
        }
        if (ruleMatchBiome.type == EnumListType.WHITELIST) {
            boolean result2 = ruleMatchBiome._biomes.contains(biome);
            if (debug) {
                if (result2) {
                    logFile.debug(String.format("[MATCH] [OK] Biome whitelisted: (matches) %s contains %s (candidate)", ruleMatchBiome._biomes, biome));
                } else {
                    logFile.debug(String.format("[MATCH] [!!] Biome not whitelisted: (matches) %s does not contain %s (candidate)", ruleMatchBiome._biomes, biome));
                }
            }
            return result2;
        }
        boolean bl = result = !ruleMatchBiome._biomes.contains(biome);
        if (debug) {
            if (result) {
                logFile.debug(String.format("[MATCH] [OK] Biome not blacklisted: (matches) %s does not contain %s (candidate)", ruleMatchBiome._biomes, biome));
            } else {
                logFile.debug(String.format("[MATCH] [!!] Biome blacklisted: (matches) %s contains %s (candidate)", ruleMatchBiome._biomes, biome));
            }
        }
        return result;
    }
}

