/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule;

import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.dropt.api.event.DroptLoadRulesEvent;
import com.codetaylor.mc.dropt.modules.dropt.ModuleDroptConfig;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.Rule;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleList;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.ILogger;
import com.codetaylor.mc.dropt.modules.dropt.rule.parse.ParserRuleDropItem;
import com.codetaylor.mc.dropt.modules.dropt.rule.parse.ParserRuleDropReplaceBlock;
import com.codetaylor.mc.dropt.modules.dropt.rule.parse.ParserRuleMatchBiome;
import com.codetaylor.mc.dropt.modules.dropt.rule.parse.ParserRuleMatchBlocks;
import com.codetaylor.mc.dropt.modules.dropt.rule.parse.ParserRuleMatchHarvesterHeldItemMainHand;
import com.codetaylor.mc.dropt.modules.dropt.rule.parse.ParserRuleMatchHarvesterHeldItemOffHand;
import com.codetaylor.mc.dropt.modules.dropt.rule.parse.ParserRuleMatchItems;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RuleLoader {
    public static void loadRuleLists(Path path, List<RuleList> ruleLists, ILogger logger, DebugFileWrapper debugFileWrapper) {
        DirectoryStream<Path> stream;
        long start = System.currentTimeMillis();
        MinecraftForge.EVENT_BUS.post((Event)new DroptLoadRulesEvent());
        if (ModuleDroptConfig.ENABLE_PROFILE_LOG_OUTPUT) {
            debugFileWrapper.info(String.format("Loaded %d mod rule lists in %d ms", ruleLists.size(), System.currentTimeMillis() - start));
        }
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                debugFileWrapper.info("Created path: " + path);
            }
            catch (Exception e) {
                logger.error("Unable to create path: " + path, e);
                return;
            }
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            logger.error("Not a directory: " + path);
            return;
        }
        try {
            stream = Files.newDirectoryStream(path, entry -> Files.isRegularFile(entry, new LinkOption[0]) && entry.toFile().getName().endsWith(".json"));
        }
        catch (Exception e) {
            logger.error("Unable to load json files in path: " + path, e);
            return;
        }
        ArrayList<Path> jsonFiles = new ArrayList<Path>();
        for (Path pathFile : stream) {
            jsonFiles.add(pathFile);
            debugFileWrapper.info("Located rule file: " + path.relativize(pathFile));
        }
        start = System.currentTimeMillis();
        GsonBuilder gsonBuilder = new GsonBuilder();
        if (ModuleDroptConfig.JSON_STRICT_MODE) {
            gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ValidatorAdapterFactory());
        }
        Gson gson = gsonBuilder.setPrettyPrinting().create();
        for (Path jsonFile : jsonFiles) {
            try {
                RuleList ruleList = (RuleList)gson.fromJson((Reader)new FileReader(jsonFile.toFile()), RuleList.class);
                ruleList._filename = path.relativize(jsonFile).toString();
                ruleLists.add(ruleList);
                debugFileWrapper.info("Rule file loaded: " + ruleList._filename);
            }
            catch (Exception e) {
                logger.error("Unable to load rule file: " + path.relativize(jsonFile).toString(), e);
            }
        }
        Collections.sort(ruleLists);
        if (ruleLists.isEmpty()) {
            debugFileWrapper.info("No rule files loaded.");
        } else if (ModuleDroptConfig.ENABLE_PROFILE_LOG_OUTPUT) {
            debugFileWrapper.info(String.format("Loaded %d rule lists in %d ms", ruleLists.size(), System.currentTimeMillis() - start));
        }
    }

    public static void parseRuleLists(List<RuleList> ruleLists, ILogger logger, DebugFileWrapper debugFileWrapper) {
        RecipeItemParser parser = new RecipeItemParser();
        long start = System.currentTimeMillis();
        int rulesParsed = 0;
        for (RuleList ruleList : ruleLists) {
            int ruleIndex = 0;
            for (Rule rule : ruleList.rules) {
                if (rule == null) {
                    logger.warn("Malformed JSON caused null Rule, skipping null Rule");
                    continue;
                }
                if (rule.debug) {
                    debugFileWrapper.debug("--------------------------------------------------------------------------------------");
                    debugFileWrapper.debug(String.format("Parsing rule %d in file %s", ruleIndex, ruleList._filename));
                }
                new ParserRuleMatchBlocks().parse(parser, ruleList, rule, logger, debugFileWrapper);
                new ParserRuleMatchItems().parse(parser, ruleList, rule, logger, debugFileWrapper);
                new ParserRuleMatchHarvesterHeldItemMainHand().parse(parser, ruleList, rule, logger, debugFileWrapper);
                new ParserRuleMatchHarvesterHeldItemOffHand().parse(parser, ruleList, rule, logger, debugFileWrapper);
                new ParserRuleMatchBiome().parse(parser, ruleList, rule, logger, debugFileWrapper);
                new ParserRuleDropItem().parse(parser, ruleList, rule, logger, debugFileWrapper);
                new ParserRuleDropReplaceBlock().parse(parser, ruleList, rule, logger, debugFileWrapper);
                ++ruleIndex;
                ++rulesParsed;
            }
        }
        if (ModuleDroptConfig.ENABLE_PROFILE_LOG_OUTPUT) {
            debugFileWrapper.info(String.format("Parsed %d rules in %d ms", rulesParsed, System.currentTimeMillis() - start));
        }
    }

    private static class ValidatorAdapterFactory
    implements TypeAdapterFactory {
        private ValidatorAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            if (delegate instanceof ReflectiveTypeAdapterFactory.Adapter) {
                try {
                    Field f = delegate.getClass().getDeclaredField("boundFields");
                    f.setAccessible(true);
                    Map boundFields = (Map)f.get(delegate);
                    boundFields = new LinkedHashMap(boundFields){

                        @Override
                        public Object get(Object key) {
                            Object value = super.get(key);
                            if (value == null) {
                                throw new JsonParseException("Invalid property name: " + key);
                            }
                            return value;
                        }
                    };
                    f.set(delegate, boundFields);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return delegate;
        }
    }
}

