/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.compat.crafttweaker;

import com.codetaylor.mc.dropt.api.api.IDroptRuleBuilder;
import com.codetaylor.mc.dropt.modules.dropt.compat.crafttweaker.ZenRule;
import com.codetaylor.mc.dropt.modules.dropt.compat.crafttweaker.export.ZenDocClass;
import com.codetaylor.mc.dropt.modules.dropt.compat.crafttweaker.export.ZenDocMethod;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.dropt.RuleList", description={"This class is a container for rules.", "@see /json/syntax/#irulelist"})
@ZenClass(value="mods.dropt.RuleList")
public class ZenRuleList {
    private List<IDroptRuleBuilder> ruleList = new ArrayList<IDroptRuleBuilder>();
    private ResourceLocation resourceLocation;
    private int priority;

    ZenRuleList(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    @ZenDocMethod(order=1, description={"Set the priority of this rule list.", "Rule lists with a larger priority will be matched first.", "@see /json/syntax/#irulelist"}, args={"priority"})
    @ZenMethod
    public ZenRuleList priority(int priority) {
        this.priority = priority;
        return this;
    }

    @ZenDocMethod(order=2, description={"Add a configured rule to this rule list.", "@see /json/syntax/#irulelist"}, args={"rule"})
    @ZenMethod
    public ZenRuleList add(ZenRule rule) {
        this.ruleList.add(rule.getRule());
        return this;
    }

    public List<IDroptRuleBuilder> getRuleList() {
        return this.ruleList;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public int getPriority() {
        return this.priority;
    }
}

