/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.DungeonTactics;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTCreativeTab;
import pegbeard.dungeontactics.handlers.DTItems;

public class DTEdibleGeneric
extends ItemFood {
    private String toolTip = null;
    private PotionEffect[] effects = null;
    private boolean glow = false;
    private int eatTime = 32;

    public DTEdibleGeneric(String name, boolean glint, int useTime, String info, int food, float saturation, boolean wolfFood, PotionEffect ... potion) {
        super(food, saturation, wolfFood);
        this.setRegistryName("dungeontactics", name);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77637_a(DTCreativeTab.DT_TAB);
        if (!DTConfigHandler.configuration.get("1-Feature", "Seasonal Events", true).getBoolean(true)) {
            if (name == "candy_skull") {
                this.func_77637_a(null);
            }
            if (name == "mince_pie") {
                this.func_77637_a(null);
            }
        }
        if (name == "candy_skull" && !DungeonTactics.samhain) {
            this.func_77637_a(null);
        }
        if (name == "mince_pie" && !DungeonTactics.solstice) {
            this.func_77637_a(null);
        }
        this.toolTip = info;
        this.glow = glint;
        this.eatTime = useTime;
        this.effects = potion;
    }

    public DTEdibleGeneric(String name, boolean glint, int useTime, int food, float saturation, boolean wolfFood, PotionEffect ... potion) {
        super(food, saturation, wolfFood);
        this.setRegistryName("dungeontactics", name);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77637_a(DTCreativeTab.DT_TAB);
        this.glow = glint;
        this.eatTime = useTime;
        this.effects = potion;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (this == DTItems.MILK_BOTTLE) {
            return EnumAction.DRINK;
        }
        return EnumAction.EAT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.glow;
    }

    public int func_77626_a(ItemStack stack) {
        return this.eatTime;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (this.toolTip != null) {
            tooltip.add(this.toolTip);
            return;
        }
        if (this.effects != null) {
            this.addPotionTooltip(stack, tooltip, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addPotionTooltip(ItemStack itemIn, List<String> lores, float durationFactor) {
        ArrayList list1 = Lists.newArrayList();
        if (this.effects == null) {
            return;
        }
        for (int i = 0; i < this.effects.length; ++i) {
            if (this.effects[i] == null || this.effects[i].func_188419_a() == null) continue;
            PotionEffect potioneffect = this.effects[i];
            String s1 = I18n.func_74838_a((String)potioneffect.func_76453_d()).trim();
            Potion potion = potioneffect.func_188419_a();
            Map map = potion.func_111186_k();
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), attributemodifier), attributemodifier.func_111169_c());
                    list1.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1));
                }
            }
            if (potioneffect.func_76458_c() > 0) {
                s1 = s1 + " " + I18n.func_74838_a((String)("potion.potency." + potioneffect.func_76458_c())).trim();
            }
            if (potioneffect.func_76459_b() > 20) {
                s1 = s1 + " (" + Potion.func_188410_a((PotionEffect)potioneffect, (float)durationFactor) + ")";
            }
            if (potion.func_76398_f()) {
                lores.add(TextFormatting.RED + s1);
                continue;
            }
            lores.add(TextFormatting.BLUE + s1);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        EntityPlayer player;
        if (entityLiving instanceof EntityPlayer && !(player = (EntityPlayer)entityLiving).func_184812_l_() && stack.func_77973_b() == DTItems.MILK_BOTTLE && !player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo))) {
            player.func_71019_a(new ItemStack(Items.field_151069_bo), false);
        }
        return super.func_77654_b(stack, world, entityLiving);
    }

    public void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        super.func_77849_c(stack, world, player);
        if (this == DTItems.CHERRYBOMB && !world.field_72995_K) {
            world.func_72885_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, 0.1f, false, false);
        }
        if (this == DTItems.INCINDIBERRY && !world.field_72995_K) {
            player.func_70015_d(4);
        }
        if (this == DTItems.MILK_BOTTLE && !world.field_72995_K) {
            player.curePotionEffects(new ItemStack(Items.field_151117_aB));
        }
        if (this == DTItems.SPIDEREYE_SOUP) {
            Potion effect = this.getEffect();
            if (!world.field_72995_K && effect != null) {
                player.func_70690_d(new PotionEffect(effect, 600, field_77697_d.nextInt(2), false, true));
            }
        }
        if (this.effects != null) {
            for (int i = 0; i < this.effects.length; ++i) {
                if (world.field_72995_K || this.effects[i] == null || this.effects[i].func_188419_a() == null) continue;
                player.func_70690_d(new PotionEffect(this.effects[i].func_188419_a(), this.effects[i].func_76459_b(), this.effects[i].func_76458_c(), this.effects[i].func_82720_e(), true));
            }
        }
    }

    public Potion getEffect() {
        Potion effect = null;
        int i = field_77697_d.nextInt(6);
        if (i == 0) {
            effect = MobEffects.field_76424_c;
        } else if (i == 1) {
            effect = MobEffects.field_76420_g;
        } else if (i == 2) {
            effect = MobEffects.field_76428_l;
        } else if (i == 3) {
            effect = MobEffects.field_76441_p;
        }
        return effect;
    }
}

