/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.handlers.client;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import pegbeard.dungeontactics.DungeonTactics;
import pegbeard.dungeontactics.blocks.tileentities.DTPowderKegEntity;
import pegbeard.dungeontactics.entities.DTEntityCompanion;
import pegbeard.dungeontactics.entities.DTEntityCucco;
import pegbeard.dungeontactics.entities.DTEntityTowerGuardian;
import pegbeard.dungeontactics.entities.projectiles.DTEntityBullet;
import pegbeard.dungeontactics.entities.projectiles.DTEntityCryoBomb;
import pegbeard.dungeontactics.entities.projectiles.DTEntityFragBomb;
import pegbeard.dungeontactics.entities.projectiles.DTEntityGoldNugget;
import pegbeard.dungeontactics.entities.projectiles.DTEntityPortBomb;
import pegbeard.dungeontactics.entities.projectiles.DTEntityPyroBomb;
import pegbeard.dungeontactics.entities.projectiles.DTEntitySlingshotAmmo;
import pegbeard.dungeontactics.entities.projectiles.DTEntityThrowingKnife;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.handlers.client.renderers.DTRenderBullet;
import pegbeard.dungeontactics.handlers.client.renderers.DTRenderCompanion;
import pegbeard.dungeontactics.handlers.client.renderers.DTRenderCryoBomb;
import pegbeard.dungeontactics.handlers.client.renderers.DTRenderCucco;
import pegbeard.dungeontactics.handlers.client.renderers.DTRenderFragBomb;
import pegbeard.dungeontactics.handlers.client.renderers.DTRenderGoldNugget;
import pegbeard.dungeontactics.handlers.client.renderers.DTRenderPortBomb;
import pegbeard.dungeontactics.handlers.client.renderers.DTRenderPowderKeg;
import pegbeard.dungeontactics.handlers.client.renderers.DTRenderPyroBomb;
import pegbeard.dungeontactics.handlers.client.renderers.DTRenderSlingshotAmmo;
import pegbeard.dungeontactics.handlers.client.renderers.DTRenderThrowingKnife;
import pegbeard.dungeontactics.handlers.client.renderers.DTRenderTowerGuardian;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="dungeontactics")
public final class DTRenderRegister {
    public static final DTRenderRegister INSTANCE = new DTRenderRegister();
    private static boolean models = DTConfigHandler.configuration.get("1-Feature", "3D Item Models", true).getBoolean(true);

    @SubscribeEvent
    public static void registerAllModels(ModelRegistryEvent event) {
        INSTANCE.registerItemModels();
        if (models) {
            INSTANCE.register3dModels();
        }
        INSTANCE.registerBlockModels();
        INSTANCE.registerEntityModels();
    }

    public static void registerItemModels() {
        DTRenderRegister.regBooks(DTItems.DUNGEONPEDIA_MAIN);
        DTRenderRegister.regBooks(DTItems.DUNGEONPEDIA_WEAPONS);
        DTRenderRegister.regBooks(DTItems.DUNGEONPEDIA_TRINKETS);
        DTRenderRegister.regBooks(DTItems.DUNGEONPEDIA_MAGIC);
        DTRenderRegister.regBooks(DTItems.DUNGEONPEDIA_CAULDRON_RECIPES);
        DTRenderRegister.regBooks(DTItems.DUNGEONPEDIA_UNIQUE_WEAPONS);
        DTRenderRegister.regBooks(DTItems.DUNGEONPEDIA_ENGINEERING);
        DTRenderRegister.regBooks(DTItems.DUNGEONPEDIA_WORLD);
        ModelLoader.setCustomModelResourceLocation((Item)DTItems.PEG_HAMMER, (int)0, (ModelResourceLocation)new ModelResourceLocation(DTItems.GOLDEN_HAMMER.getRegistryName(), "inventory"));
        DTRenderRegister.regMasterModels(DTItems.HAMMER_SMASH);
        DTRenderRegister.regMasterModels(DTItems.HAMMER_LEAP);
        DTRenderRegister.regMasterModels(DTItems.CUTLASS_RIPOSTE);
        DTRenderRegister.regMasterModels(DTItems.CUTLASS_PIERCE);
        DTRenderRegister.regMasterModels(DTItems.KNIFE_SMOKEBOMB);
        DTRenderRegister.regMasterModels(DTItems.KNIFE_MULTISTRIKE);
        DTRenderRegister.regMasterModels(DTItems.CESTUS_ROAR);
        DTRenderRegister.regMasterModels(DTItems.CESTUS_PUMMEL);
        DTRenderRegister.regModels(DTItems.WOODEN_HAMMER);
        DTRenderRegister.regModels(DTItems.BONE_HAMMER);
        DTRenderRegister.regModels(DTItems.STONE_HAMMER);
        DTRenderRegister.regModels(DTItems.IRON_HAMMER);
        DTRenderRegister.regModels(DTItems.SILVER_HAMMER);
        DTRenderRegister.regModels(DTItems.GOLDEN_HAMMER);
        DTRenderRegister.regModels(DTItems.STEEL_HAMMER);
        DTRenderRegister.regModels(DTItems.DIAMOND_HAMMER);
        DTRenderRegister.regModels(DTItems.MITHRIL_HAMMER);
        DTRenderRegister.regModels(DTItems.WOODEN_BATTLEAXE);
        DTRenderRegister.regModels(DTItems.BONE_BATTLEAXE);
        DTRenderRegister.regModels(DTItems.STONE_BATTLEAXE);
        DTRenderRegister.regModels(DTItems.IRON_BATTLEAXE);
        DTRenderRegister.regModels(DTItems.SILVER_BATTLEAXE);
        DTRenderRegister.regModels(DTItems.GOLDEN_BATTLEAXE);
        DTRenderRegister.regModels(DTItems.STEEL_BATTLEAXE);
        DTRenderRegister.regModels(DTItems.DIAMOND_BATTLEAXE);
        DTRenderRegister.regModels(DTItems.MITHRIL_BATTLEAXE);
        DTRenderRegister.regModels(DTItems.WOODEN_GLAIVE);
        DTRenderRegister.regModels(DTItems.BONE_GLAIVE);
        DTRenderRegister.regModels(DTItems.STONE_GLAIVE);
        DTRenderRegister.regModels(DTItems.IRON_GLAIVE);
        DTRenderRegister.regModels(DTItems.SILVER_GLAIVE);
        DTRenderRegister.regModels(DTItems.GOLDEN_GLAIVE);
        DTRenderRegister.regModels(DTItems.STEEL_GLAIVE);
        DTRenderRegister.regModels(DTItems.DIAMOND_GLAIVE);
        DTRenderRegister.regModels(DTItems.MITHRIL_GLAIVE);
        DTRenderRegister.regModels(DTItems.WOODEN_CLUB);
        DTRenderRegister.regModels(DTItems.BONE_CLUB);
        DTRenderRegister.regModels(DTItems.STONE_CLUB);
        DTRenderRegister.regModels(DTItems.IRON_CLUB);
        DTRenderRegister.regModels(DTItems.SILVER_CLUB);
        DTRenderRegister.regModels(DTItems.GOLDEN_CLUB);
        DTRenderRegister.regModels(DTItems.STEEL_CLUB);
        DTRenderRegister.regModels(DTItems.DIAMOND_CLUB);
        DTRenderRegister.regModels(DTItems.MITHRIL_CLUB);
        DTRenderRegister.regModels(DTItems.BONE_SWORD);
        DTRenderRegister.regModels(DTItems.SILVER_SWORD);
        DTRenderRegister.regModels(DTItems.STEEL_SWORD);
        DTRenderRegister.regModels(DTItems.MITHRIL_SWORD);
        DTRenderRegister.regModels(DTItems.WOODEN_CUTLASS);
        DTRenderRegister.regModels(DTItems.BONE_CUTLASS);
        DTRenderRegister.regModels(DTItems.STONE_CUTLASS);
        DTRenderRegister.regModels(DTItems.IRON_CUTLASS);
        DTRenderRegister.regModels(DTItems.SILVER_CUTLASS);
        DTRenderRegister.regModels(DTItems.GOLDEN_CUTLASS);
        DTRenderRegister.regModels(DTItems.STEEL_CUTLASS);
        DTRenderRegister.regModels(DTItems.DIAMOND_CUTLASS);
        DTRenderRegister.regModels(DTItems.MITHRIL_CUTLASS);
        DTRenderRegister.regModels(DTItems.WOODEN_KNIFE);
        DTRenderRegister.regModels(DTItems.BONE_KNIFE);
        DTRenderRegister.regModels(DTItems.STONE_KNIFE);
        DTRenderRegister.regModels(DTItems.IRON_KNIFE);
        DTRenderRegister.regModels(DTItems.SILVER_KNIFE);
        DTRenderRegister.regModels(DTItems.GOLDEN_KNIFE);
        DTRenderRegister.regModels(DTItems.STEEL_KNIFE);
        DTRenderRegister.regModels(DTItems.DIAMOND_KNIFE);
        DTRenderRegister.regModels(DTItems.MITHRIL_KNIFE);
        DTRenderRegister.regModels(DTItems.WOODEN_CESTUS);
        DTRenderRegister.regModels(DTItems.BONE_CESTUS);
        DTRenderRegister.regModels(DTItems.STONE_CESTUS);
        DTRenderRegister.regModels(DTItems.IRON_CESTUS);
        DTRenderRegister.regModels(DTItems.SILVER_CESTUS);
        DTRenderRegister.regModels(DTItems.GOLDEN_CESTUS);
        DTRenderRegister.regModels(DTItems.STEEL_CESTUS);
        DTRenderRegister.regModels(DTItems.DIAMOND_CESTUS);
        DTRenderRegister.regModels(DTItems.MITHRIL_CESTUS);
        DTRenderRegister.regModels(DTItems.WOODEN_SHIELD);
        DTRenderRegister.regModels(DTItems.BONE_SHIELD);
        DTRenderRegister.regModels(DTItems.STONE_SHIELD);
        DTRenderRegister.regModels(DTItems.IRON_SHIELD);
        DTRenderRegister.regModels(DTItems.SILVER_SHIELD);
        DTRenderRegister.regModels(DTItems.GOLDEN_SHIELD);
        DTRenderRegister.regModels(DTItems.STEEL_SHIELD);
        DTRenderRegister.regModels(DTItems.DIAMOND_SHIELD);
        DTRenderRegister.regModels(DTItems.MITHRIL_SHIELD);
        DTRenderRegister.regModels(DTItems.SHARP_STICK);
        DTRenderRegister.regModels(DTItems.THROWINGKNIFE);
        DTRenderRegister.regModels(DTItems.SLOWNESSKNIFE);
        DTRenderRegister.regModels(DTItems.WEAKNESSKNIFE);
        DTRenderRegister.regModels(DTItems.POISONKNIFE);
        DTRenderRegister.regModels(DTItems.CAUSTICKNIFE);
        DTRenderRegister.regModels(DTItems.SLINGSHOT);
        DTRenderRegister.regModels(DTItems.SLINGSHOTAMMO);
        if (!DungeonTactics.samhain || !DTConfigHandler.configuration.get("1-Feature", "Seasonal Events", true).getBoolean(true)) {
            DTRenderRegister.regModels(DTItems.BOMB_FRAG);
            DTRenderRegister.regModels(DTItems.BOMB_FRAG_CLUSTER);
            DTRenderRegister.regModels(DTItems.BOMB_PYRO);
            DTRenderRegister.regModels(DTItems.BOMB_PYRO_CLUSTER);
            DTRenderRegister.regModels(DTItems.BOMB_CRYO);
            DTRenderRegister.regModels(DTItems.BOMB_CRYO_CLUSTER);
            DTRenderRegister.regModels(DTItems.BOMB_PORTING);
            DTRenderRegister.regModels(DTItems.BOMB_PORTING_CLUSTER);
        } else if (DungeonTactics.samhain && DTConfigHandler.configuration.get("1-Feature", "Seasonal Events", true).getBoolean(true)) {
            DTRenderRegister.regSamhainModels(DTItems.BOMB_FRAG);
            DTRenderRegister.regSamhainModels(DTItems.BOMB_FRAG_CLUSTER);
            DTRenderRegister.regSamhainModels(DTItems.BOMB_PYRO);
            DTRenderRegister.regSamhainModels(DTItems.BOMB_PYRO_CLUSTER);
            DTRenderRegister.regSamhainModels(DTItems.BOMB_CRYO);
            DTRenderRegister.regSamhainModels(DTItems.BOMB_CRYO_CLUSTER);
            DTRenderRegister.regSamhainModels(DTItems.BOMB_PORTING);
            DTRenderRegister.regSamhainModels(DTItems.BOMB_PORTING_CLUSTER);
        }
        DTRenderRegister.regModels(DTItems.POTSHOT);
        DTRenderRegister.regModels(DTItems.POTSHOTAMMO);
        DTRenderRegister.regModels(DTItems.STONEPLATE_HEAD);
        DTRenderRegister.regModels(DTItems.STONEPLATE_CHEST);
        DTRenderRegister.regModels(DTItems.STONEPLATE_LEGS);
        DTRenderRegister.regModels(DTItems.STONEPLATE_FEET);
        DTRenderRegister.regModels(DTItems.IRONPLATE_HEAD);
        DTRenderRegister.regModels(DTItems.IRONPLATE_CHEST);
        DTRenderRegister.regModels(DTItems.IRONPLATE_LEGS);
        DTRenderRegister.regModels(DTItems.IRONPLATE_FEET);
        DTRenderRegister.regModels(DTItems.SILVERPLATE_HEAD);
        DTRenderRegister.regModels(DTItems.SILVERPLATE_CHEST);
        DTRenderRegister.regModels(DTItems.SILVERPLATE_LEGS);
        DTRenderRegister.regModels(DTItems.SILVERPLATE_FEET);
        DTRenderRegister.regModels(DTItems.GOLDPLATE_HEAD);
        DTRenderRegister.regModels(DTItems.GOLDPLATE_CHEST);
        DTRenderRegister.regModels(DTItems.GOLDPLATE_LEGS);
        DTRenderRegister.regModels(DTItems.GOLDPLATE_FEET);
        DTRenderRegister.regModels(DTItems.STEELPLATE_HEAD);
        DTRenderRegister.regModels(DTItems.STEELPLATE_CHEST);
        DTRenderRegister.regModels(DTItems.STEELPLATE_LEGS);
        DTRenderRegister.regModels(DTItems.STEELPLATE_FEET);
        DTRenderRegister.regModels(DTItems.DIAMONDPLATE_HEAD);
        DTRenderRegister.regModels(DTItems.DIAMONDPLATE_CHEST);
        DTRenderRegister.regModels(DTItems.DIAMONDPLATE_LEGS);
        DTRenderRegister.regModels(DTItems.DIAMONDPLATE_FEET);
        DTRenderRegister.regModels(DTItems.MITHRILPLATE_HEAD);
        DTRenderRegister.regModels(DTItems.MITHRILPLATE_CHEST);
        DTRenderRegister.regModels(DTItems.MITHRILPLATE_LEGS);
        DTRenderRegister.regModels(DTItems.MITHRILPLATE_FEET);
        DTRenderRegister.regModels(DTItems.BONE_HELMET);
        DTRenderRegister.regModels(DTItems.BONE_CHESTPLATE);
        DTRenderRegister.regModels(DTItems.BONE_LEGGINGS);
        DTRenderRegister.regModels(DTItems.BONE_BOOTS);
        DTRenderRegister.regModels(DTItems.STUDDED_HELMET);
        DTRenderRegister.regModels(DTItems.STUDDED_CHESTPLATE);
        DTRenderRegister.regModels(DTItems.STUDDED_LEGGINGS);
        DTRenderRegister.regModels(DTItems.STUDDED_BOOTS);
        DTRenderRegister.regModels(DTItems.SILVER_HELMET);
        DTRenderRegister.regModels(DTItems.SILVER_CHESTPLATE);
        DTRenderRegister.regModels(DTItems.SILVER_LEGGINGS);
        DTRenderRegister.regModels(DTItems.SILVER_BOOTS);
        DTRenderRegister.regModels(DTItems.STEEL_HELMET);
        DTRenderRegister.regModels(DTItems.STEEL_CHESTPLATE);
        DTRenderRegister.regModels(DTItems.STEEL_LEGGINGS);
        DTRenderRegister.regModels(DTItems.STEEL_BOOTS);
        DTRenderRegister.regModels(DTItems.MITHRIL_HELMET);
        DTRenderRegister.regModels(DTItems.MITHRIL_CHESTPLATE);
        DTRenderRegister.regModels(DTItems.MITHRIL_LEGGINGS);
        DTRenderRegister.regModels(DTItems.MITHRIL_BOOTS);
        DTRenderRegister.regModels(DTItems.MAGIC_POWDER);
        DTRenderRegister.regModels(DTItems.MAGIC_POUCH);
        DTRenderRegister.regModels(DTItems.MAGIC_SCROLL);
        DTRenderRegister.regUniqueModels(DTItems.HIGH_STRIKER);
        DTRenderRegister.regUniqueModels(DTItems.GNOME_STICK);
        DTRenderRegister.regUniqueModels(DTItems.WACKERJAB);
        DTRenderRegister.regUniqueModels(DTItems.TASER);
        DTRenderRegister.regUniqueModels(DTItems.CLAWS);
        DTRenderRegister.regUniqueModels(DTItems.LITHEN_SCYTHE);
        DTRenderRegister.regUniqueModels(DTItems.ALCHEMIST_BREW);
        DTRenderRegister.regUniqueModels(DTItems.TERRIBLE_FEATHER);
        DTRenderRegister.regUniqueModels(DTItems.HOOK);
        DTRenderRegister.regUniqueModels(DTItems.COIN_CANNON);
        DTRenderRegister.regUniqueModels(DTItems.BACKFIRE_CANNON);
        DTRenderRegister.regUniqueModels(DTItems.HOT_POTATOE);
        DTRenderRegister.regUniqueModels(DTItems.FIRE_WATER);
        DTRenderRegister.regUniqueModels(DTItems.BOBS);
        DTRenderRegister.regUniqueModels(DTItems.ICARUSRING);
        DTRenderRegister.regModels(DTItems.ENGINEERS_DUNGAREES);
        DTRenderRegister.regModels(DTItems.REXO_GOGGLES);
        DTRenderRegister.regModels(DTItems.REXO_LEGGINGS);
        DTRenderRegister.regModels(DTItems.REXO_BOOTS);
        DTRenderRegister.regModels(DTItems.TUNNELER);
        DTRenderRegister.regModels(DTItems.PISTONGLOVE);
        DTRenderRegister.regModels(DTItems.STICKYPISTONGLOVE);
        DTRenderRegister.regModels(DTItems.WRENCH_IRON);
        DTRenderRegister.regModels(DTItems.WRENCH_STEEL);
        DTRenderRegister.regModels(DTItems.BONE_PICK);
        DTRenderRegister.regModels(DTItems.BONE_SHOVEL);
        DTRenderRegister.regModels(DTItems.BONE_AXE);
        DTRenderRegister.regModels(DTItems.BONE_HOE);
        DTRenderRegister.regModels(DTItems.SILVER_PICK);
        DTRenderRegister.regModels(DTItems.SILVER_SHOVEL);
        DTRenderRegister.regModels(DTItems.SILVER_AXE);
        DTRenderRegister.regModels(DTItems.SILVER_HOE);
        DTRenderRegister.regModels(DTItems.STEEL_PICK);
        DTRenderRegister.regModels(DTItems.STEEL_SHOVEL);
        DTRenderRegister.regModels(DTItems.STEEL_AXE);
        DTRenderRegister.regModels(DTItems.STEEL_HOE);
        DTRenderRegister.regModels(DTItems.MITHRIL_PICK);
        DTRenderRegister.regModels(DTItems.MITHRIL_SHOVEL);
        DTRenderRegister.regModels(DTItems.MITHRIL_AXE);
        DTRenderRegister.regModels(DTItems.MITHRIL_HOE);
        DTRenderRegister.regModels(DTItems.SOULGEM);
        DTRenderRegister.regModels(DTItems.MORTARPESTLE);
        DTRenderRegister.regModels(DTItems.FIRESTARTER);
        DTRenderRegister.regModels(DTItems.ESCAPEROPE);
        DTRenderRegister.regModels(DTItems.PHYLACTERY);
        DTRenderRegister.regModels(DTItems.ENDERBAG);
        DTRenderRegister.regModels(DTItems.DUCT_TAPE);
        DTRenderRegister.regModels(DTItems.HEART_DROP);
        DTRenderRegister.regModels(DTItems.HEART_JAR);
        DTRenderRegister.regModels(DTItems.HEART_GOLDEN);
        DTRenderRegister.regModels(DTItems.IRONLINKS);
        DTRenderRegister.regModels(DTItems.INGOT_SILVER);
        DTRenderRegister.regModels(DTItems.INGOT_STEEL);
        DTRenderRegister.regModels(DTItems.INGOT_MITHRIL);
        DTRenderRegister.regModels(DTItems.NUGGET_SILVER);
        DTRenderRegister.regModels(DTItems.NUGGET_STEEL);
        DTRenderRegister.regModels(DTItems.CUT_DIAMOND);
        DTRenderRegister.regModels(DTItems.NUGGET_MITHRIL);
        DTRenderRegister.regModels(DTItems.DUST_COAL);
        DTRenderRegister.regModels(DTItems.DUST_IRON);
        DTRenderRegister.regModels(DTItems.DUST_SILVER);
        DTRenderRegister.regModels(DTItems.DUST_STEEL);
        DTRenderRegister.regModels(DTItems.DUST_GOLD);
        DTRenderRegister.regModels(DTItems.DUST_MITHRIL);
        DTRenderRegister.regModels(DTItems.DUST_TIN);
        DTRenderRegister.regModels(DTItems.DUST_COPPER);
        DTRenderRegister.regModels(DTItems.DUST_ALUMINIUM);
        DTRenderRegister.regModels(DTItems.DUST_NICKEL);
        DTRenderRegister.regModels(DTItems.DUST_LEAD);
        DTRenderRegister.regModels(DTItems.DUST_PLATINUM);
        DTRenderRegister.regModels(DTItems.DUST_TUNGSTEN);
        DTRenderRegister.regModels(DTItems.DUST_TITANIUM);
        DTRenderRegister.regModels(DTItems.DUST_OSMIUM);
        DTRenderRegister.regModels(DTItems.TINYDUST_GUNPOWDER);
        DTRenderRegister.regModels(DTItems.TINYDUST_COAL);
        DTRenderRegister.regModels(DTItems.TINYDUST_IRON);
        DTRenderRegister.regModels(DTItems.TINYDUST_SILVER);
        DTRenderRegister.regModels(DTItems.TINYDUST_STEEL);
        DTRenderRegister.regModels(DTItems.TINYDUST_GOLD);
        DTRenderRegister.regModels(DTItems.TINYDUST_MITHRIL);
        DTRenderRegister.regModels(DTItems.TINYDUST_TIN);
        DTRenderRegister.regModels(DTItems.TINYDUST_COPPER);
        DTRenderRegister.regModels(DTItems.TINYDUST_ALUMINIUM);
        DTRenderRegister.regModels(DTItems.TINYDUST_NICKEL);
        DTRenderRegister.regModels(DTItems.TINYDUST_LEAD);
        DTRenderRegister.regModels(DTItems.TINYDUST_PLATINUM);
        DTRenderRegister.regModels(DTItems.TINYDUST_TUNGSTEN);
        DTRenderRegister.regModels(DTItems.TINYDUST_TITANIUM);
        DTRenderRegister.regModels(DTItems.TINYDUST_OSMIUM);
        DTRenderRegister.regModels(DTItems.CLUSTER_IRON);
        DTRenderRegister.regModels(DTItems.CLUSTER_SILVER);
        DTRenderRegister.regModels(DTItems.CLUSTER_GOLD);
        DTRenderRegister.regModels(DTItems.CLUSTER_MITHRIL);
        DTRenderRegister.regModels(DTItems.CLUSTER_TIN);
        DTRenderRegister.regModels(DTItems.CLUSTER_COPPER);
        DTRenderRegister.regModels(DTItems.CLUSTER_ALUMINIUM);
        DTRenderRegister.regModels(DTItems.CLUSTER_NICKEL);
        DTRenderRegister.regModels(DTItems.CLUSTER_LEAD);
        DTRenderRegister.regModels(DTItems.CLUSTER_PLATINUM);
        DTRenderRegister.regModels(DTItems.CLUSTER_TUNGSTEN);
        DTRenderRegister.regModels(DTItems.CLUSTER_TITANIUM);
        DTRenderRegister.regModels(DTItems.CLUSTER_OSMIUM);
        DTRenderRegister.regModels(DTItems.CHERRYBOMB);
        DTRenderRegister.regModels(DTItems.INCINDIBERRY);
        DTRenderRegister.regModels(DTItems.GLOWCURRENT);
        DTRenderRegister.regModels(DTItems.FISH_SWIFT);
        DTRenderRegister.regModels(DTItems.FISH_SWIFT_COOKED);
        DTRenderRegister.regModels(DTItems.FISH_FLYING);
        DTRenderRegister.regModels(DTItems.FISH_FLYING_COOKED);
        DTRenderRegister.regModels(DTItems.FISH_LAVA);
        DTRenderRegister.regModels(DTItems.FISH_LAVA_COOKED);
        DTRenderRegister.regModels(DTItems.FISH_MUSCLE);
        DTRenderRegister.regModels(DTItems.FISH_MUSCLE_COOKED);
        DTRenderRegister.regModels(DTItems.FISH_LUNG);
        DTRenderRegister.regModels(DTItems.FISH_LUNG_COOKED);
        DTRenderRegister.regModels(DTItems.FISH_OBSIDIAN);
        DTRenderRegister.regModels(DTItems.FISH_OBSIDIAN_COOKED);
        DTRenderRegister.regModels(DTItems.FISH_TUNNEL);
        DTRenderRegister.regModels(DTItems.FISH_TUNNEL_COOKED);
        DTRenderRegister.regModels(DTItems.FLOUR);
        DTRenderRegister.regModels(DTItems.MILK_BOTTLE);
        DTRenderRegister.regModels(DTItems.BREADSLICE);
        DTRenderRegister.regModels(DTItems.TOAST);
        DTRenderRegister.regModels(DTItems.TOASTSLICE);
        DTRenderRegister.regModels(DTItems.JAM);
        DTRenderRegister.regModels(DTItems.JAMSLICE);
        DTRenderRegister.regModels(DTItems.RATION_STANDARD);
        DTRenderRegister.regModels(DTItems.RATION_IRON);
        DTRenderRegister.regModels(DTItems.RATION_SILVER);
        DTRenderRegister.regModels(DTItems.RATION_GOLD);
        DTRenderRegister.regModels(DTItems.SPIDEREYE_SOUP);
        DTRenderRegister.regRingModels(DTItems.IRONRING);
        DTRenderRegister.regRingModels(DTItems.GOLDENRING);
        DTRenderRegister.regRingModels(DTItems.DIAMONDRING);
        DTRenderRegister.regModels(DTItems.CHARM_TOXIC);
        DTRenderRegister.regModels(DTItems.CHARM_SAPPING);
        DTRenderRegister.regModels(DTItems.CHARM_HEAVY);
        DTRenderRegister.regModels(DTItems.CHARM_EMACIATED);
        DTRenderRegister.regModels(DTItems.CHARM_UNINTELLIGIBLE);
        DTRenderRegister.regModels(DTItems.CHARM_DARKENED);
        DTRenderRegister.regModels(DTItems.CHARM_FAMINE);
        DTRenderRegister.regModels(DTItems.CHARM_BARREN);
        DTRenderRegister.regModels(DTItems.CHARM_SEARING);
        DTRenderRegister.regModels(DTItems.CHARM_BLEAK);
        DTRenderRegister.regModels(DTItems.BAG_FOOD);
        DTRenderRegister.regModels(DTItems.BAG_ARBOUR);
        DTRenderRegister.regModels(DTItems.BAG_ORE);
        DTRenderRegister.regModels(DTItems.BAG_TOOL);
        DTRenderRegister.regModels(DTItems.BAG_BOOK);
        DTRenderRegister.regModels(DTItems.BAG_QUIVER);
        DTRenderRegister.regModels(DTItems.BAG_MAGIC);
        DTRenderRegister.regModels(DTItems.BAG_POTION);
        DTRenderRegister.regModels(DTItems.BAG_RECORD);
        DTRenderRegister.regModels(DTItems.BAG_MYSTERY);
        DTRenderRegister.regModels(DTItems.BAG_STARTER);
        DTRenderRegister.regSamhainModels(DTItems.BAG_SAMHAIN);
        DTRenderRegister.regSamhainModels(DTItems.CANDY_SKULL);
        DTRenderRegister.regSolsticeModels(DTItems.BAG_SOLSTICE);
        DTRenderRegister.regSolsticeModels(DTItems.MINCE_PIE);
    }

    public static void register3dModels() {
        DTRenderRegister.regUnique3dModels(DTItems.HIGH_STRIKER);
        DTRenderRegister.regUnique3dModels(DTItems.WACKERJAB);
        DTRenderRegister.regUnique3dModels(DTItems.TASER);
        DTRenderRegister.regUnique3dModels(DTItems.BACKFIRE_CANNON);
        DTRenderRegister.regUnique3dModels(DTItems.COIN_CANNON);
        DTRenderRegister.regUnique3dModels(DTItems.HOT_POTATOE);
        DTRenderRegister.reg3dModels(DTItems.WOODEN_HAMMER);
        DTRenderRegister.reg3dModels(DTItems.BONE_HAMMER);
        DTRenderRegister.reg3dModels(DTItems.STONE_HAMMER);
        DTRenderRegister.reg3dModels(DTItems.IRON_HAMMER);
        DTRenderRegister.reg3dModels(DTItems.SILVER_HAMMER);
        DTRenderRegister.reg3dModels(DTItems.GOLDEN_HAMMER);
        DTRenderRegister.reg3dModels(DTItems.STEEL_HAMMER);
        DTRenderRegister.reg3dModels(DTItems.DIAMOND_HAMMER);
        DTRenderRegister.reg3dModels(DTItems.MITHRIL_HAMMER);
        DTRenderRegister.reg3dModels(DTItems.WOODEN_BATTLEAXE);
        DTRenderRegister.reg3dModels(DTItems.BONE_BATTLEAXE);
        DTRenderRegister.reg3dModels(DTItems.STONE_BATTLEAXE);
        DTRenderRegister.reg3dModels(DTItems.IRON_BATTLEAXE);
        DTRenderRegister.reg3dModels(DTItems.SILVER_BATTLEAXE);
        DTRenderRegister.reg3dModels(DTItems.GOLDEN_BATTLEAXE);
        DTRenderRegister.reg3dModels(DTItems.STEEL_BATTLEAXE);
        DTRenderRegister.reg3dModels(DTItems.DIAMOND_BATTLEAXE);
        DTRenderRegister.reg3dModels(DTItems.MITHRIL_BATTLEAXE);
        DTRenderRegister.reg3dModels(DTItems.WOODEN_GLAIVE);
        DTRenderRegister.reg3dModels(DTItems.BONE_GLAIVE);
        DTRenderRegister.reg3dModels(DTItems.STONE_GLAIVE);
        DTRenderRegister.reg3dModels(DTItems.IRON_GLAIVE);
        DTRenderRegister.reg3dModels(DTItems.SILVER_GLAIVE);
        DTRenderRegister.reg3dModels(DTItems.GOLDEN_GLAIVE);
        DTRenderRegister.reg3dModels(DTItems.STEEL_GLAIVE);
        DTRenderRegister.reg3dModels(DTItems.DIAMOND_GLAIVE);
        DTRenderRegister.reg3dModels(DTItems.MITHRIL_GLAIVE);
        DTRenderRegister.reg3dModels(DTItems.BONE_SWORD);
        DTRenderRegister.regVanilla3dModels(Items.field_151041_m, "wooden_sword");
        DTRenderRegister.regVanilla3dModels(Items.field_151052_q, "stone_sword");
        DTRenderRegister.regVanilla3dModels(Items.field_151040_l, "iron_sword");
        DTRenderRegister.reg3dModels(DTItems.SILVER_SWORD);
        DTRenderRegister.regVanilla3dModels(Items.field_151010_B, "golden_sword");
        DTRenderRegister.reg3dModels(DTItems.STEEL_SWORD);
        DTRenderRegister.regVanilla3dModels(Items.field_151048_u, "diamond_sword");
        DTRenderRegister.reg3dModels(DTItems.MITHRIL_SWORD);
        DTRenderRegister.reg3dModels(DTItems.WOODEN_CUTLASS);
        DTRenderRegister.reg3dModels(DTItems.BONE_CUTLASS);
        DTRenderRegister.reg3dModels(DTItems.STONE_CUTLASS);
        DTRenderRegister.reg3dModels(DTItems.IRON_CUTLASS);
        DTRenderRegister.reg3dModels(DTItems.SILVER_CUTLASS);
        DTRenderRegister.reg3dModels(DTItems.GOLDEN_CUTLASS);
        DTRenderRegister.reg3dModels(DTItems.STEEL_CUTLASS);
        DTRenderRegister.reg3dModels(DTItems.DIAMOND_CUTLASS);
        DTRenderRegister.reg3dModels(DTItems.MITHRIL_CUTLASS);
        DTRenderRegister.reg3dModels(DTItems.BONE_KNIFE);
        DTRenderRegister.reg3dModels(DTItems.WOODEN_KNIFE);
        DTRenderRegister.reg3dModels(DTItems.STONE_KNIFE);
        DTRenderRegister.reg3dModels(DTItems.IRON_KNIFE);
        DTRenderRegister.reg3dModels(DTItems.SILVER_KNIFE);
        DTRenderRegister.reg3dModels(DTItems.GOLDEN_KNIFE);
        DTRenderRegister.reg3dModels(DTItems.STEEL_KNIFE);
        DTRenderRegister.reg3dModels(DTItems.DIAMOND_KNIFE);
        DTRenderRegister.reg3dModels(DTItems.MITHRIL_KNIFE);
        DTRenderRegister.reg3dModels(DTItems.WOODEN_CESTUS);
        DTRenderRegister.reg3dModels(DTItems.BONE_CESTUS);
        DTRenderRegister.reg3dModels(DTItems.STONE_CESTUS);
        DTRenderRegister.reg3dModels(DTItems.IRON_CESTUS);
        DTRenderRegister.reg3dModels(DTItems.SILVER_CESTUS);
        DTRenderRegister.reg3dModels(DTItems.GOLDEN_CESTUS);
        DTRenderRegister.reg3dModels(DTItems.STEEL_CESTUS);
        DTRenderRegister.reg3dModels(DTItems.DIAMOND_CESTUS);
        DTRenderRegister.reg3dModels(DTItems.MITHRIL_CESTUS);
        DTRenderRegister.reg3dModels(DTItems.THROWINGKNIFE);
        DTRenderRegister.reg3dModels(DTItems.SLOWNESSKNIFE);
        DTRenderRegister.reg3dModels(DTItems.WEAKNESSKNIFE);
        DTRenderRegister.reg3dModels(DTItems.POISONKNIFE);
        DTRenderRegister.reg3dModels(DTItems.CAUSTICKNIFE);
        DTRenderRegister.reg3dModels(DTItems.SLINGSHOT);
        DTRenderRegister.reg3dModels(DTItems.SLINGSHOTAMMO);
        DTRenderRegister.reg3dModels(DTItems.BOMB_FRAG);
        DTRenderRegister.reg3dModels(DTItems.BOMB_FRAG_CLUSTER);
        DTRenderRegister.reg3dModels(DTItems.BOMB_PYRO);
        DTRenderRegister.reg3dModels(DTItems.BOMB_PYRO_CLUSTER);
        DTRenderRegister.reg3dModels(DTItems.BOMB_CRYO);
        DTRenderRegister.reg3dModels(DTItems.BOMB_CRYO_CLUSTER);
        DTRenderRegister.reg3dModels(DTItems.BOMB_PORTING);
        DTRenderRegister.reg3dModels(DTItems.BOMB_PORTING_CLUSTER);
        DTRenderRegister.reg3dModels(DTItems.POTSHOT);
        DTRenderRegister.reg3dModels(DTItems.TUNNELER);
        DTRenderRegister.reg3dModels(DTItems.PISTONGLOVE);
        DTRenderRegister.reg3dModels(DTItems.STICKYPISTONGLOVE);
    }

    public static void registerBlockModels() {
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.ORE_SILVER));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.ORE_MITHRIL));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.NETHER_GOLD));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.STONE_QUARTZ));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.END_DIAMOND));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.END_LAPIS));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.BLOCK_SILVER));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.BLOCK_STEEL));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.BLOCK_MITHRIL));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.OBSIDIAN_BRICK));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.DUNGEON_GLASS));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.WHITECUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.LIGHTGREYCUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.GREYCUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.BLACKCUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.PINKCUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.REDCUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.ORANGECUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.YELLOWCUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.LIMECUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.GREENCUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.LIGHTBLUECUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.BLUECUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.CYANCUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.MAGENTACUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.PURPLECUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.BROWNCUSHION));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.WOODCHAIR));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.WOODTABLE));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.RADIO));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.BRAZIER));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.LANTERN_IRON));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.LANTERN_MAGIC));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.ALCHEMYCAULDRON));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.BARREL));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.POWDERKEG));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.WITHER_WEB));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.CLIMBINGROPE));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.POWERED_FENCE));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.FAN_BLOCK));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.FLAMER_BLOCK));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.GRINDER_BLOCK));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.CALTROPS));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.CALTROPSPOISON));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.TRAP_CLAMP));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.TRAP_BOOM));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.TRAP_PISTON));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.TRAP_FIRE));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.TRAP_FOUL));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.TRAP_AILMENT));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.TRAP_PORT));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.TRAP_AMBUSH));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.TRAP_SPECTRAL));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.MUSHROOM_BLAST));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.MUSHROOM_COAL));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.MUSHROOM_IRON));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.MUSHROOM_SILVER));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.MUSHROOM_GOLD));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.MUSHROOM_STEEL));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.MUSHROOM_MITHRIL));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.FLOWER_SANGUINE));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.FLOWER_XP));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.FLOWER_BRAMBLE));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.FLOWER_BARK));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.FLOWER_CINDER));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.FLOWER_TANGLE));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.FLOWER_AILMENT));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.FLOWER_FADE));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.FLOWER_FEATHER));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.CHERRYBOMB_BUSH));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.INCINDIBERRY_BUSH));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.GLOWCURRENT_BUSH));
        DTRenderRegister.regModels(ItemBlock.func_150898_a((Block)DTBlocks.GUARDIAN_ALTER));
    }

    public static void registerEntityModels() {
        DTRenderRegister.registerEntityRenderer(DTEntitySlingshotAmmo.class, DTRenderSlingshotAmmo.class);
        DTRenderRegister.registerEntityRenderer(DTEntityGoldNugget.class, DTRenderGoldNugget.class);
        DTRenderRegister.registerEntityRenderer(DTEntityThrowingKnife.class, DTRenderThrowingKnife.class);
        DTRenderRegister.registerEntityRenderer(DTEntityBullet.class, DTRenderBullet.class);
        DTRenderRegister.registerEntityRenderer(DTEntityFragBomb.class, DTRenderFragBomb.class);
        DTRenderRegister.registerEntityRenderer(DTEntityPyroBomb.class, DTRenderPyroBomb.class);
        DTRenderRegister.registerEntityRenderer(DTEntityPortBomb.class, DTRenderPortBomb.class);
        DTRenderRegister.registerEntityRenderer(DTEntityCryoBomb.class, DTRenderCryoBomb.class);
        DTRenderRegister.registerEntityRenderer(DTPowderKegEntity.class, DTRenderPowderKeg.class);
        DTRenderRegister.registerEntityRenderer(DTEntityTowerGuardian.class, DTRenderTowerGuardian.class);
        DTRenderRegister.registerEntityRenderer(DTEntityCompanion.class, DTRenderCompanion.class);
        DTRenderRegister.registerEntityRenderer(DTEntityCucco.class, DTRenderCucco.class);
    }

    public static void regModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    public static void reg3dModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("dungeontactics".toLowerCase() + ":item3d/" + item.func_77658_a().substring(20), "inventory"));
    }

    public static void regVanilla3dModels(Item item, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("dungeontactics".toLowerCase() + ":item3d/" + name, "inventory"));
    }

    public static void regUnique3dModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("dungeontactics".toLowerCase() + ":item3d/unique_item/" + item.func_77658_a().substring(20), "inventory"));
    }

    public static void regMasterModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("dungeontactics".toLowerCase() + ":master_weapons/" + item.func_77658_a().substring(20), "inventory"));
    }

    public static void regUniqueModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("dungeontactics".toLowerCase() + ":unique_item/" + item.func_77658_a().substring(20), "inventory"));
    }

    public static void regRingModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)1, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "_active"));
    }

    public static void regBooks(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("dungeontactics".toLowerCase() + ":dungeonpedia", "inventory"));
    }

    public static void regExtraModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("dungeontactics".toLowerCase() + ":misc/extra_materials/" + item.func_77658_a().substring(20), "inventory"));
    }

    public static void regSamhainModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("dungeontactics".toLowerCase() + ":misc/samhain/" + item.func_77658_a().substring(20), "inventory"));
    }

    public static void regSolsticeModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("dungeontactics".toLowerCase() + ":misc/solstice/" + item.func_77658_a().substring(20), "inventory"));
    }

    private static <E extends Entity> void registerEntityRenderer(Class<E> entityClass, Class<? extends Render<E>> renderClass) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, new EntityRenderFactory(renderClass));
    }

    private static class EntityRenderFactory<E extends Entity>
    implements IRenderFactory<E> {
        private Class<? extends Render<E>> renderClass;

        private EntityRenderFactory(Class<? extends Render<E>> renderClassIn) {
            this.renderClass = renderClassIn;
        }

        public Render<E> createRenderFor(RenderManager manager) {
            Render<E> renderer = null;
            try {
                renderer = this.renderClass.getConstructor(RenderManager.class).newInstance(manager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return renderer;
        }
    }
}

