/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.handlers;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.IWorldGenerator;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.reference.Reference;
import pegbeard.dungeontactics.worldgen.DTDungeon;
import pegbeard.dungeontactics.worldgen.DTTemplates;
import pegbeard.dungeontactics.worldgen.DTTower;
import pegbeard.dungeontactics.worldgen.DTWorldDecorator;

public class DTWorldGen
implements IWorldGenerator {
    int shrooms = DTConfigHandler.configuration.get("7-World", "Mushroom Generation", 32).getInt(32);
    int flowers = DTConfigHandler.configuration.get("7-World", "Flower Generation", 32).getInt(32);
    int silverOre = DTConfigHandler.configuration.get("7-World", "Silver Ore", 6).getInt(6);
    int mithrilOre = DTConfigHandler.configuration.get("7-World", "Mithril Ore", 2).getInt(2);
    int netherGold = DTConfigHandler.configuration.get("7-World", "Nether Gold", 6).getInt(6);
    int stoneQuartz = DTConfigHandler.configuration.get("7-World", "Overworld Quartz", 6).getInt(6);
    int endDiamond = DTConfigHandler.configuration.get("7-World", "Overworld Quartz", 6).getInt(6);
    int endLapis = DTConfigHandler.configuration.get("7-World", "Overworld Quartz", 6).getInt(6);
    boolean structures = DTConfigHandler.configuration.get("7-World", "Dungeon Generation", true).getBoolean(true);
    int dungeonDistance = DTConfigHandler.configuration.get("7-World", "Dungeon Spacing", 1000).getInt(1000);
    int shipDistance = DTConfigHandler.configuration.get("7-World", "Ship Spacing", 500).getInt(500);
    private final List<Biome> isOcean = Lists.newArrayList();

    public DTWorldGen() {
        this.isOcean.add(Biomes.field_76771_b);
        this.isOcean.add(Biomes.field_150575_M);
        this.isOcean.add(Biomes.field_76776_l);
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.generateNether(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateOverworld(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                this.generateEnd(world, rand, chunkX * 16, chunkZ * 16);
            }
        }
        if (DTConfigHandler.canSpawnHere(world)) {
            this.generateDungeon(world, rand, chunkX * 16, chunkZ * 16);
        }
    }

    private static int floordiv(int start, int distance) {
        if (start % distance != 0) {
            // empty if block
        }
        return start / distance - (start < 0 ^ distance < 0 ? 1 : 0);
    }

    private boolean chunkContainsASpawnPosition(int coord, int spacing) {
        int chunksize = 16;
        int lowerEdge = DTWorldGen.floordiv(coord - 1, spacing);
        int upperEdge = DTWorldGen.floordiv(coord + chunksize - 1, spacing);
        return upperEdge - lowerEdge == 1;
    }

    private void generateNether(World world, Random rand, int chunkXStart, int chunkZStart) {
        int i;
        int chunkX = chunkXStart + 8;
        int chunkZ = chunkZStart + 8;
        BlockPos pos = new BlockPos(chunkX, world.func_72940_L(), chunkZ);
        if (this.netherGold > 0) {
            for (int k = 0; k < this.netherGold; ++k) {
                int XCoord = chunkXStart + rand.nextInt(16);
                int YCoord = 5 + rand.nextInt(118);
                int ZCoord = chunkZStart + rand.nextInt(16);
                new WorldGenMinable(DTBlocks.NETHER_GOLD.func_176223_P(), 6, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL)).func_180709_b(world, rand, new BlockPos(XCoord, YCoord, ZCoord));
            }
        }
        if (this.shrooms > 0) {
            for (i = 0; i < this.shrooms; ++i) {
                pos = new BlockPos(chunkX + rand.nextInt(16), rand.nextInt(48), chunkZ + rand.nextInt(16));
                if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
                new DTWorldDecorator().generateMushroom(world, rand, pos, DTWorldDecorator.mushroomVarientNether.get(rand.nextInt(DTWorldDecorator.mushroomVarientNether.size())));
            }
        }
        for (i = 0; i < this.flowers / 2; ++i) {
            pos = new BlockPos(chunkX + rand.nextInt(16), 5 + rand.nextInt(118), chunkZ + rand.nextInt(16));
            if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
            new DTWorldDecorator().generateBush(world, rand, pos, DTBlocks.GLOWCURRENT_BUSH);
        }
    }

    private void generateOverworld(World world, Random rand, int chunkXStart, int chunkZStart) {
        int i;
        int ZCoord;
        int YCoord;
        int XCoord;
        int k;
        int chunkX = chunkXStart + 8;
        int chunkZ = chunkZStart + 8;
        BlockPos pos = new BlockPos(chunkX, world.func_72940_L(), chunkZ);
        Biome biome = world.field_73011_w.getBiomeForCoords(pos);
        Property configBiomes = DTConfigHandler.configuration.get("8-WorldGen", "Flower Biomes", Reference.FLOWERBIOMESDEFAULT);
        ArrayList<String> biomeList = new ArrayList<String>(Arrays.asList(configBiomes.getStringList()));
        if (this.silverOre > 0) {
            for (k = 0; k < this.silverOre; ++k) {
                XCoord = chunkXStart + rand.nextInt(16);
                YCoord = 3 + rand.nextInt(12);
                ZCoord = chunkZStart + rand.nextInt(16);
                new WorldGenMinable(DTBlocks.ORE_SILVER.func_176223_P(), 6, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b)).func_180709_b(world, rand, new BlockPos(XCoord, YCoord, ZCoord));
            }
        }
        if (this.mithrilOre > 0) {
            for (k = 0; k < this.mithrilOre; ++k) {
                XCoord = chunkXStart + rand.nextInt(16);
                YCoord = 3 + rand.nextInt(12);
                ZCoord = chunkZStart + rand.nextInt(16);
                new WorldGenMinable(DTBlocks.ORE_MITHRIL.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b)).func_180709_b(world, rand, new BlockPos(XCoord, YCoord, ZCoord));
            }
        }
        if (this.stoneQuartz > 0) {
            for (k = 0; k < this.stoneQuartz; ++k) {
                XCoord = chunkXStart + rand.nextInt(16);
                YCoord = 3 + rand.nextInt(12);
                ZCoord = chunkZStart + rand.nextInt(16);
                new WorldGenMinable(DTBlocks.STONE_QUARTZ.func_176223_P(), 6, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b)).func_180709_b(world, rand, new BlockPos(XCoord, YCoord, ZCoord));
            }
        }
        if (this.shrooms > 0) {
            for (i = 0; i < this.shrooms; ++i) {
                pos = new BlockPos(chunkX + rand.nextInt(16), rand.nextInt(48), chunkZ + rand.nextInt(16));
                if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
                new DTWorldDecorator().generateMushroom(world, rand, pos, DTWorldDecorator.mushroomVarientOverWorld.get(rand.nextInt(DTWorldDecorator.mushroomVarientOverWorld.size())));
            }
        }
        if (this.flowers > 0) {
            if (biomeList.contains(biome.getRegistryName().toString())) {
                for (i = 0; i < this.flowers; ++i) {
                    pos = new BlockPos(chunkX + rand.nextInt(16), 52 + rand.nextInt(48), chunkZ + rand.nextInt(16));
                    if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
                    new DTWorldDecorator().generateFlower(world, rand, pos);
                }
            }
            for (i = 0; i < this.flowers; ++i) {
                pos = new BlockPos(chunkX + rand.nextInt(16), rand.nextInt(48), chunkZ + rand.nextInt(16));
                if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
                new DTWorldDecorator().generateFlower(world, rand, pos);
            }
        }
        for (i = 0; i < this.flowers / 2; ++i) {
            pos = new BlockPos(chunkX + rand.nextInt(16), 52 + rand.nextInt(48), chunkZ + rand.nextInt(16));
            if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
            new DTWorldDecorator().generateBush(world, rand, pos, DTBlocks.CHERRYBOMB_BUSH);
        }
        for (i = 0; i < this.flowers / 2; ++i) {
            pos = new BlockPos(chunkX + rand.nextInt(16), rand.nextInt(48), chunkZ + rand.nextInt(16));
            if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
            new DTWorldDecorator().generateBush(world, rand, pos, DTBlocks.INCINDIBERRY_BUSH);
        }
    }

    private void generateEnd(World world, Random rand, int chunkXStart, int chunkZStart) {
        int ZCoord;
        int YCoord;
        int XCoord;
        int k;
        int chunkX = chunkXStart + 8;
        int chunkZ = chunkZStart + 8;
        BlockPos pos = new BlockPos(chunkX, world.func_72940_L(), chunkZ);
        if (this.endDiamond > 0) {
            for (k = 0; k < this.endDiamond; ++k) {
                XCoord = chunkXStart + rand.nextInt(16);
                YCoord = 5 + rand.nextInt(118);
                ZCoord = chunkZStart + rand.nextInt(16);
                new WorldGenMinable(DTBlocks.END_DIAMOND.func_176223_P(), 6, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs)).func_180709_b(world, rand, new BlockPos(XCoord, YCoord, ZCoord));
            }
        }
        if (this.endLapis > 0) {
            for (k = 0; k < this.endLapis; ++k) {
                XCoord = chunkXStart + rand.nextInt(16);
                YCoord = 5 + rand.nextInt(118);
                ZCoord = chunkZStart + rand.nextInt(16);
                new WorldGenMinable(DTBlocks.END_LAPIS.func_176223_P(), 6, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs)).func_180709_b(world, rand, new BlockPos(XCoord, YCoord, ZCoord));
            }
        }
        if (this.shrooms > 0) {
            for (int i = 0; i < this.shrooms; ++i) {
                pos = new BlockPos(chunkX + rand.nextInt(16), rand.nextInt(48), chunkZ + rand.nextInt(16));
                if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
                new DTWorldDecorator().generateMushroom(world, rand, pos, DTWorldDecorator.mushroomVarientEnd.get(rand.nextInt(DTWorldDecorator.mushroomVarientEnd.size())));
            }
        }
    }

    private void generateDungeon(World world, Random rand, int chunkXStart, int chunkZStart) {
        if (this.structures && world.func_72912_H().func_76089_r()) {
            int multiplier = 16 * (rand.nextInt(6) - rand.nextInt(6));
            int chunkX = chunkXStart + 8;
            int chunkZ = chunkZStart + 8;
            BlockPos pos = new BlockPos(chunkX, world.func_72940_L(), chunkZ);
            Biome biome = world.field_73011_w.getBiomeForCoords(pos);
            int finalY = world.func_72940_L();
            if (world.field_73011_w.getDimension() == -1) {
                finalY = world.func_181545_F() / 2 + (rand.nextInt(25) - rand.nextInt(25));
            }
            int finalX = chunkX + multiplier;
            int finalZ = chunkZ + multiplier;
            int voidY = 63 + rand.nextInt(10) - rand.nextInt(10);
            if (this.chunkContainsASpawnPosition(chunkX, this.dungeonDistance) && this.chunkContainsASpawnPosition(chunkZ, this.dungeonDistance)) {
                while (world.func_175623_d(new BlockPos(finalX, finalY, finalZ)) && finalY > 1) {
                    --finalY;
                }
                if (world.func_175623_d(new BlockPos(finalX, 0, finalZ))) {
                    finalY = voidY;
                }
                if (finalY < 1) {
                    finalY = 1;
                }
                if (!(world.func_180495_p(pos = new BlockPos(finalX, finalY + 2, finalZ)).func_177230_c() instanceof BlockLiquid || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockLiquid || world.func_180495_p(pos.func_177979_c(2)).func_177230_c() instanceof BlockLiquid || world.func_180495_p(pos.func_177979_c(3)).func_177230_c() instanceof BlockLiquid)) {
                    int chance = rand.nextInt(5);
                    if (chance == 0 && pos.func_177956_o() >= 20) {
                        new DTDungeon().settle(world, rand, pos);
                    } else if (chance == 1 && pos.func_177956_o() >= 20) {
                        new DTTower().settle(world, rand, pos);
                    } else if (chance == 2 && pos.func_177956_o() >= 20 && world.field_73011_w.getDimension() != -1) {
                        new DTTemplates().generateTower(world, rand, pos);
                    } else if (chance == 3 && pos.func_177956_o() >= 20 && world.field_73011_w.getDimension() != -1) {
                        new DTTemplates().generateMiniBunker(world, rand, pos);
                    } else if (pos.func_177956_o() >= 20 && world.field_73011_w.getDimension() != -1) {
                        new DTTemplates().generateWaggon(world, rand, pos);
                    }
                }
            }
            if (this.chunkContainsASpawnPosition(chunkX, this.shipDistance) && this.chunkContainsASpawnPosition(chunkZ, this.shipDistance) && this.isOcean.contains(biome) && (world.func_180495_p(pos = new BlockPos(finalX, finalY = world.func_181545_F(), finalZ)).func_177230_c() instanceof BlockLiquid || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockLiquid || world.func_180495_p(pos.func_177979_c(2)).func_177230_c() instanceof BlockLiquid)) {
                new DTTemplates().func_180709_b(world, rand, pos);
            }
        }
    }

    public static BlockPos settle(World world, BlockPos start, int minHeight, boolean isVoid) {
        int level;
        BlockPos ne = new BlockPos(start.func_177958_n() + 4, start.func_177956_o(), start.func_177952_p() - 4);
        BlockPos se = new BlockPos(start.func_177958_n() + 4, start.func_177956_o(), start.func_177952_p() + 4);
        BlockPos sw = new BlockPos(start.func_177958_n() - 4, start.func_177956_o(), start.func_177952_p() + 4);
        BlockPos nw = new BlockPos(start.func_177958_n() - 4, start.func_177956_o(), start.func_177952_p() - 4);
        int count = 0;
        if (!isVoid) {
            for (level = start.func_177956_o(); level > minHeight && (DTWorldGen.blockCheck(world, ne.func_177979_c(count)) || DTWorldGen.blockCheck(world, se.func_177979_c(count)) || DTWorldGen.blockCheck(world, sw.func_177979_c(count)) || DTWorldGen.blockCheck(world, nw.func_177979_c(count))); --level) {
                ++count;
            }
        }
        if (level < minHeight) {
            level = minHeight;
        }
        BlockPos pos = new BlockPos(start.func_177958_n(), level, start.func_177952_p());
        return pos;
    }

    private static boolean blockCheck(World world, BlockPos pos) {
        if (!world.func_175677_d(pos, false)) {
            return true;
        }
        return world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c() instanceof BlockLiquid || world.func_180495_p(pos).func_177230_c() instanceof BlockLog || world.func_180495_p(pos).func_177230_c() instanceof BlockOldLog || world.func_180495_p(pos).func_177230_c() instanceof BlockNewLog || world.func_180495_p(pos).func_177230_c() instanceof BlockLeaves || world.func_180495_p(pos).func_177230_c() instanceof BlockOldLeaf || world.func_180495_p(pos).func_177230_c() instanceof BlockNewLeaf;
    }

    public static void printLocation(String phase, String structure, BlockPos pos) {
        System.out.print("[DT] - " + phase + " Generatiion of " + structure + " @ X=" + pos.func_177958_n() + " Y=" + pos.func_177956_o() + " Z=" + pos.func_177952_p());
    }
}

