/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.blocks.DTBlockGeneric;
import pegbeard.dungeontactics.blocks.tileentities.DTLanternTile;
import pegbeard.dungeontactics.handlers.DTBlocks;

public class DTLantern
extends DTBlockGeneric
implements ITileEntityProvider {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    protected static final AxisAlignedBB HORIZONTAL_AABB = new AxisAlignedBB(0.25, 0.2, 0.25, 0.75, 0.9, 0.75);
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.25, 0.3, 0.25, 0.75, 1.0, 0.75);
    protected static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.575, 0.75);

    public DTLantern(String name, Material material, float hardness, float resistance) {
        super(name, material, hardness, resistance);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return 0;
        }
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return 15;
        }
        return state.func_185906_d();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_149738_a(World world) {
        return 4;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return HORIZONTAL_AABB;
            }
            case WEST: {
                return HORIZONTAL_AABB;
            }
            case SOUTH: {
                return HORIZONTAL_AABB;
            }
            case NORTH: {
                return HORIZONTAL_AABB;
            }
            case UP: {
                return UP_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
        }
        return DOWN_AABB;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)(meta & 7));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LIT});
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (this == DTBlocks.LANTERN_MAGIC) {
            return new DTLanternTile();
        }
        return null;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_177226_a((IProperty)FACING, (Comparable)mirrorIn.func_185803_b((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && player.func_184586_b(hand).func_77973_b() == Items.field_151033_d) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)), 2);
            this.func_149715_a(1.0f);
            world.func_180500_c(EnumSkyBlock.BLOCK, pos);
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
            return true;
        }
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && player.func_184586_b(hand).func_190926_b()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)), 2);
            this.func_149715_a(0.0f);
            world.func_180500_c(EnumSkyBlock.BLOCK, pos);
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.33;
            double z = (double)pos.func_177952_p() + 0.5;
            if (enumfacing != EnumFacing.UP && enumfacing != EnumFacing.DOWN) {
                y = (double)pos.func_177956_o() + 0.53;
                world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            } else if (enumfacing == EnumFacing.UP) {
                y = (double)pos.func_177956_o() + 0.63;
                world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            } else {
                world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this == DTBlocks.LANTERN_MAGIC) {
            boolean b = (Boolean)state.func_177229_b((IProperty)LIT);
            ((DTLanternTile)world.func_175625_s(pos)).setLit(b);
        }
    }
}

