/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.blocks.DTBlockGenericOdd;
import pegbeard.dungeontactics.handlers.DTItems;

public class DTFence
extends DTBlockGenericOdd {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private static double d = 0.0625;
    protected static final AxisAlignedBB[] AABB_BY_DIR = new AxisAlignedBB[]{new AxisAlignedBB(0.4375, 0.0 + d, 0.4375, 0.5625, 1.0 - d, 0.5625), new AxisAlignedBB(0.4375, 0.0 + d, 0.4375, 0.5625, 1.0 - d, 1.0), new AxisAlignedBB(0.0, 0.0 + d, 0.4375, 0.5625, 1.0 - d, 0.5625), new AxisAlignedBB(0.0, 0.0 + d, 0.4375, 0.5625, 1.0 - d, 1.0), new AxisAlignedBB(0.4375, 0.0 + d, 0.0, 0.5625, 1.0 - d, 0.5625), new AxisAlignedBB(0.4375, 0.0 + d, 0.0, 0.5625, 1.0 - d, 1.0), new AxisAlignedBB(0.0, 0.0 + d, 0.0, 0.5625, 1.0 - d, 0.5625), new AxisAlignedBB(0.0, 0.0 + d, 0.0, 0.5625, 1.0 - d, 1.0), new AxisAlignedBB(0.4375, 0.0 + d, 0.4375, 1.0, 1.0 - d, 0.5625), new AxisAlignedBB(0.4375, 0.0 + d, 0.4375, 1.0, 1.0 - d, 1.0), new AxisAlignedBB(0.0, 0.0 + d, 0.4375, 1.0, 1.0 - d, 0.5625), new AxisAlignedBB(0.0, 0.0 + d, 0.4375, 1.0, 1.0 - d, 1.0), new AxisAlignedBB(0.4375, 0.0 + d, 0.0, 1.0, 1.0 - d, 0.5625), new AxisAlignedBB(0.4375, 0.0 + d, 0.0, 1.0, 1.0 - d, 1.0), new AxisAlignedBB(0.0, 0.0 + d, 0.0, 1.0, 1.0 - d, 0.5625), new AxisAlignedBB(0.0, 0.0 + d, 0.0, 1.0, 1.0 - d, 1.0)};

    public DTFence(String name, Material material, float hardness, float resistance) {
        super(name, material, hardness, resistance);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            if (world.field_72995_K) {
                this.doParticles(world, pos);
            }
            if (!this.isEngineer((EntityLivingBase)entity) && entity.field_70172_ad < 10) {
                if (entity instanceof EntityCreeper) {
                    EntityCreeper creeper = (EntityCreeper)entity;
                    EntityLightningBolt lightning = new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false);
                    if (!creeper.func_70830_n()) {
                        creeper.func_70015_d(1);
                        creeper.func_70077_a(lightning);
                    }
                }
                entity.func_70097_a(DamageSource.field_76377_j, 4.0f);
            }
        }
        super.func_180634_a(world, pos, state, entity);
    }

    public boolean isEngineer(EntityLivingBase entity) {
        return !entity.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() && entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == DTItems.ENGINEERS_DUNGAREES;
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, BlockPos pos) {
        Random rand = world.field_73012_v;
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.func_177958_n() + rand.nextFloat();
            double d2 = (float)pos.func_177956_o() + rand.nextFloat();
            double d3 = (float)pos.func_177952_p() + rand.nextFloat();
            if (i == 0 && !world.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() + d0 + 1.0;
            }
            if (i == 1 && !world.func_180495_p(pos.func_177977_b()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() - d0;
            }
            if (i == 2 && !world.func_180495_p(pos.func_177968_d()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() + d0 + 1.0;
            }
            if (i == 3 && !world.func_180495_p(pos.func_177978_c()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() - d0;
            }
            if (i == 4 && !world.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() + d0 + 1.0;
            }
            if (i == 5 && !world.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() - d0;
            }
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1))) continue;
            world.func_175688_a(EnumParticleTypes.REDSTONE, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean b) {
        state = this.func_176221_a(state, (IBlockAccess)world, pos);
        DTFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_DIR[0]);
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            DTFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_DIR[DTFence.getBoundingBoxIndex(EnumFacing.NORTH)]);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            DTFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_DIR[DTFence.getBoundingBoxIndex(EnumFacing.SOUTH)]);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            DTFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_DIR[DTFence.getBoundingBoxIndex(EnumFacing.EAST)]);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            DTFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_DIR[DTFence.getBoundingBoxIndex(EnumFacing.WEST)]);
        }
    }

    private static int getBoundingBoxIndex(EnumFacing facing) {
        return 1 << facing.func_176736_b();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return AABB_BY_DIR[DTFence.getBoundingBoxIndex(state)];
    }

    private static int getBoundingBoxIndex(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= DTFence.getBoundingBoxIndex(EnumFacing.NORTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= DTFence.getBoundingBoxIndex(EnumFacing.EAST);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= DTFence.getBoundingBoxIndex(EnumFacing.SOUTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= DTFence.getBoundingBoxIndex(EnumFacing.WEST);
        }
        return i;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canBeConnectedTo(world, pos, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canBeConnectedTo(world, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canBeConnectedTo(world, pos, EnumFacing.WEST))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canBeConnectedTo(world, pos, EnumFacing.EAST)));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this ? false : super.func_176225_a(state, blockAccess, pos, side);
    }

    public final boolean attachesTo(IBlockAccess blockAccess, IBlockState state, BlockPos pos, EnumFacing facing) {
        Block block = state.func_177230_c();
        BlockFaceShape blockfaceshape = state.func_193401_d(blockAccess, pos, facing);
        return !DTFence.isExcepBlockForAttachWithPiston(block) && blockfaceshape == BlockFaceShape.SOLID || blockfaceshape == BlockFaceShape.MIDDLE_POLE_THIN;
    }

    protected static boolean isExcepBlockForAttachWithPiston(Block block) {
        return block instanceof BlockShulkerBox || block instanceof BlockLeaves || block == Blocks.field_150461_bJ || block == Blocks.field_150383_bp || block == Blocks.field_150426_aN || block == Blocks.field_150432_aD || block == Blocks.field_180398_cJ || block == Blocks.field_150331_J || block == Blocks.field_150320_F || block == Blocks.field_150332_K || block == Blocks.field_150440_ba || block == Blocks.field_150423_aK || block == Blocks.field_150428_aP || block == Blocks.field_180401_cv;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return super.func_185471_a(state, mirror);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH});
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos offset = pos.func_177972_a(facing);
        return this.attachesTo(world, world.func_180495_p(offset), offset, facing.func_176734_d());
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE_THIN : BlockFaceShape.CENTER_SMALL;
    }
}

